/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.core.backup.BackupManager;
import com.day.crx.persistence.tar.Optimize;
import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.TarSetConfig;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.file.FileEntry;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexEntryVisitor;
import com.day.crx.persistence.tar.index.IndexSet;
import com.day.crx.persistence.tar.utils.DataStoreGarbageCollector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.zip.Adler32;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.util.RepositoryLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarUtils {
    public static final int MAX_BACKUP_VERSIONS = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.BackupVersion", 20);
    private static final int CHECK_OPEN_FILES = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.CheckOpenFiles", 200);
    private static Logger log = LoggerFactory.getLogger(TarUtils.class);
    private static String fileSystemError;

    public static void main(String[] args) throws IOException, RepositoryException {
        for (int i = 0; i < args.length; ++i) {
            if ("-list".equals(args[i])) {
                String name = args[++i];
                boolean compressed = name.endsWith(".gz");
                TarFile file = new TarFile(name, 0, compressed, "r");
                TarUtils.list(file, compressed, false, false);
                file.close();
                continue;
            }
            if ("-verifyFix".equals(args[i])) {
                String dir = args[++i];
                TarUtils.verify(dir, true);
                continue;
            }
            if ("-verify".equals(args[i])) {
                String dir = args[++i];
                TarUtils.verify(dir, false);
                continue;
            }
            if ("-listChecksum".equals(args[i])) {
                String name = args[++i];
                boolean compressed = name.endsWith(".gz");
                TarFile file = new TarFile(name, 0, compressed, "r");
                TarUtils.list(file, compressed, true, false);
                continue;
            }
            if ("-extract".equals(args[i])) {
                String name = args[++i];
                boolean compressed = name.endsWith(".gz");
                String dir = args[++i];
                TarFile file = new TarFile(name, 0, compressed, "r");
                TarUtils.extractAll(file, dir);
                continue;
            }
            if ("-lock".equals(args[i])) {
                String dir = args[++i];
                System.out.println("Trying to create a .lock file in " + dir);
                RepositoryLock lock = new RepositoryLock();
                lock.init(dir);
                System.out.println("...acquire...");
                try {
                    lock.acquire();
                    System.out.println("OK");
                }
                catch (Exception e) {
                    System.out.println("Failed: " + e.toString());
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                System.out.println("...acquire again...");
                try {
                    lock.acquire();
                    System.out.println("OK");
                }
                catch (Exception e) {
                    System.out.println("Failed: " + e.toString());
                    e.printStackTrace();
                }
                System.out.println("Done");
                continue;
            }
            if ("-delete".equals(args[i])) {
                String dir = args[++i];
                TarUtils.deleteTarSet(dir);
                continue;
            }
            if ("-find".equals(args[i])) {
                String local = args[++i];
                String shared = args[++i];
                TarSet tarset = new TarSet();
                tarset.setAutoSwitch(false);
                tarset.open(shared, local, false, 0, "r");
                ++i;
                while (i < args.length) {
                    IndexEntry entry = tarset.getIndexEntry(new NodeId(args[i]), 0);
                    System.out.println("UUID: " + args[i]);
                    if (entry != null) {
                        System.out.println(" " + entry);
                    }
                    ++i;
                }
                tarset.close();
                continue;
            }
            if ("-mergeIndex".equals(args[i])) {
                String dir = args[++i];
                boolean deleteFrom = Boolean.valueOf(args[++i]);
                TarUtils.mergeTopIndexFiles(dir, deleteFrom);
                continue;
            }
            if ("-listEntries".equals(args[i])) {
                String name;
                if ((name = args[++i]).endsWith(".gz")) {
                    throw new IOException("listEntries not supported for compressed files");
                }
                TarUtils.listEntries(name);
                continue;
            }
            if ("-read".equals(args[i])) {
                String name = args[++i];
                long pos = Long.decode(args[++i]);
                int len = Integer.decode(args[++i]);
                RandomAccessFile file = new RandomAccessFile(name, "r");
                FileOutputStream out = new FileOutputStream("test.txt");
                byte[] buff = new byte[len];
                file.seek(pos);
                file.readFully(buff);
                out.write(buff);
                out.close();
                continue;
            }
            if ("-optimize".equals(args[i])) {
                String local;
                boolean compress = false;
                if ("compress".equals(args[i + 1])) {
                    compress = true;
                    ++i;
                }
                String shared = local = args[++i];
                if (i < args.length - 1) {
                    shared = args[++i];
                }
                int count = Integer.MAX_VALUE;
                if (i < args.length - 1 && "count".equals(args[i + 1])) {
                    ++i;
                    count = Integer.parseInt(args[++i]);
                }
                log.info("Optimizing local: " + local + " shared: " + shared + " count: " + count);
                TarSet tarset = new TarSet();
                boolean cluster = !shared.equals(local);
                tarset.open(shared, local, cluster, 0, "rw");
                Optimize optimize = new Optimize(tarset, tarset);
                optimize.optimizeAllFiles(compress, count);
                optimize.close();
                continue;
            }
            if ("-stats".equals(args[i])) {
                String fileName = args[++i];
                TarFile file = new TarFile(fileName, 0, false, "r");
                file.readEntries();
                InputStream in = file.getEntry("index.properties").getInputStream();
                Properties prop = new Properties();
                prop.load(in);
                String offsets = prop.getProperty("offsets");
                String[] list = offsets.split(",");
                for (int j = 0; j < list.length; ++j) {
                    System.out.println(j + " " + list[j]);
                }
                continue;
            }
            if ("-get".equals(args[i])) {
                String dir = args[++i];
                String uuid = args[++i];
                int indexType = i >= args.length - 1 ? 0 : Integer.parseInt(args[++i]);
                TarSet set = new TarSet();
                set.open(dir);
                NodeId id = NodeId.valueOf((String)uuid);
                InputStream in = set.getInputStream(id, indexType);
                FileOutputStream out = new FileOutputStream(new File(dir, uuid));
                IOUtils.copy((InputStream)in, (OutputStream)out);
                in.close();
                out.close();
                set.close();
                continue;
            }
            if ("-append".equals(args[i])) {
                String dir = args[++i];
                String uuid = args[++i];
                int indexType = i >= args.length - 1 ? 0 : Integer.parseInt(args[++i]);
                RandomAccessFile f = new RandomAccessFile(new File(dir, uuid), "r");
                byte[] data = new byte[(int)f.length()];
                f.readFully(data);
                f.close();
                TarSet set = new TarSet();
                set.open(dir);
                NodeId id = NodeId.valueOf((String)uuid);
                set.append(id, indexType, data);
                set.close();
                continue;
            }
            if ("-index".equals(args[i])) {
                long time = System.currentTimeMillis();
                String local = args[++i];
                String shared = args[++i];
                TarSet tarset = new TarSet();
                tarset.open(shared, local, true, 0, "rw");
                tarset.close();
                System.out.println("done in " + (System.currentTimeMillis() - time));
                continue;
            }
            if ("-check".equals(args[i])) {
                System.out.println(TarUtils.getFileSystemError());
                continue;
            }
            if ("-dsgc".equals(args[i])) {
                int threads = 1;
                if ("-threads".equals(args[i + 1])) {
                    ++i;
                    threads = Integer.parseInt(args[++i]);
                }
                int delay = 0;
                if ("-delay".equals(args[i + 1])) {
                    ++i;
                    delay = Integer.parseInt(args[++i]);
                }
                int prefetch = 0;
                if ("-prefetch".equals(args[i + 1])) {
                    ++i;
                    prefetch = Integer.parseInt(args[++i]);
                }
                DataStoreGarbageCollector gc = new DataStoreGarbageCollector(args[++i], threads, delay, prefetch);
                gc.setLogSystemOut(true);
                gc.init();
                gc.scanRepository();
                continue;
            }
            if ("-truncate".equals(args[i])) {
                long transaction = TarUtils.convertTransaction(args[++i]);
                log.info("Truncating to " + TarUtils.getTransactionString(transaction));
                String dirs = args[++i];
                for (String dir : dirs.split(",")) {
                    long[] start;
                    TarSet tarset = new TarSet();
                    tarset.open(dir, dir, true, 0, "rw");
                    long[] prev = tarset.findTransactionStart(transaction, true);
                    if (prev != null) {
                        System.out.println("Previous: " + prev[0] + "/" + prev[1] + " for " + dir);
                    }
                    if ((start = tarset.findTransactionStart(transaction, false)) != null) {
                        System.out.println("Found: " + prev[0] + "/" + prev[1] + " for " + dir);
                        tarset.truncate((int)start[0], start[1]);
                    }
                    tarset.close();
                }
                continue;
            }
            System.out.println("options:");
            System.out.println("-verify <dir> (scan all data files in a directory and verify if the checksums match)");
            System.out.println("-optimize [compress] <localDir> [<sharedDir> [count <fileCount>]] (optimizes a tar set, shrinking it)");
            System.out.println("-list <fileName> (lists the entries in a tar file)");
            System.out.println("-extract <fileName> <dir> (extracts the entries to a directory)");
            System.out.println("-delete <dir> (deletes a tar set in a directory)");
            System.out.println("-index <localDir> <sharedDir> (rebuild or update the index if required)");
            System.out.println("-get <dir> <nodeId> (copy the node data from the tar set to a file)");
            System.out.println("-append <dir> <nodeId> (append the file to the tar set as a node)");
            System.out.println("-dsgc <repoDir> (run data store garbage collection)");
        }
    }

    private static void mergeTopIndexFiles(String dir, boolean deleteFrom) throws IOException {
        IndexSet index = new IndexSet(null, new TarSetConfig(), dir);
        index.setDeleteFiles(deleteFrom);
        index.open();
        index.mergeTopIndexFiles();
        index.close();
        Optimize.waitUntilDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void listEntries(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.isDirectory()) {
            File[] list;
            for (File f : list = file.listFiles()) {
                if (!f.isDirectory() && !f.getName().endsWith(".tar")) continue;
                TarUtils.listEntries(f.getAbsolutePath());
            }
            return;
        }
        RandomAccessFile raFile = null;
        try {
            raFile = new RandomAccessFile(file, "r");
            System.out.println("fileName: " + fileName);
            System.out.println("length: " + raFile.length());
            System.out.println("blocks: " + raFile.length() / 512L);
            System.out.println("remaining: " + raFile.length() % 512L);
            byte[] buffer = new byte[512];
            for (long pos = 0L; pos < raFile.length(); pos += 512L) {
                int j;
                raFile.seek(pos);
                raFile.readFully(buffer);
                if (buffer[0] == 0) {
                    System.out.println(pos + ": empty");
                    continue;
                }
                for (j = 0; j < 512 && buffer[j] != 0; ++j) {
                }
                String entryName = new String(buffer, 0, j);
                String length = new String(buffer, 124, 12);
                long len = Long.decode("0" + length.trim());
                System.out.println(pos + ": " + entryName + " length: " + len);
                pos += len;
                while (pos % 512L != 0L) {
                    ++pos;
                }
            }
            TarFile tar = new TarFile(fileName, 0, false, "r");
            for (FileEntry fileEntry : tar.readEntries().values()) {
                System.out.println("name: " + fileEntry.getEntryName() + " pos: " + fileEntry.getPos() + " length: " + fileEntry.getLength());
            }
            Object var12_17 = null;
            if (raFile == null) return;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (raFile == null) throw throwable;
            raFile.close();
            throw throwable;
        }
        raFile.close();
    }

    private static void verify(String dir, boolean fix) throws IOException {
        File[] list = new File(dir).listFiles();
        for (int i = 0; list != null && i < list.length; ++i) {
            boolean compressed;
            File f = list[i];
            String name = f.getName();
            if (!name.startsWith("data_") || !(compressed = name.endsWith(".tar.gz")) && !name.endsWith(".tar")) continue;
            TarFile file = new TarFile(f.getAbsolutePath(), 0, compressed, "r");
            System.out.println("Verifying file: " + name);
            TarUtils.list(file, compressed, true, fix);
        }
    }

    public static void deleteTarSet(String dir) throws IOException {
        File[] list = new File(dir).listFiles();
        for (int i = 0; list != null && i < list.length; ++i) {
            File f = list[i];
            String name = f.getName();
            if (!name.endsWith(".tar") && !name.endsWith(".tar.gz") && !name.endsWith(".new") && !name.endsWith(".merging")) continue;
            TarUtils.deleteFileWithRetry(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractAll(TarFile tar, String dir) throws IOException {
        new File(dir).mkdirs();
        HashMap<String, FileEntry> entries = tar.readEntries();
        ArrayList<FileEntry> list = new ArrayList<FileEntry>(entries.values());
        Collections.sort(list, new Comparator<FileEntry>(){

            @Override
            public int compare(FileEntry e1, FileEntry e2) {
                long p2;
                long p1 = e1.getPos();
                return p1 < (p2 = e2.getPos()) ? -1 : (p1 > p2 ? 1 : 0);
            }
        });
        byte[] buffer = new byte[4096];
        for (FileEntry entry : list) {
            Object var14_12;
            InputStream in = entry.getInputStream();
            String fileName = dir + "/" + entry.getEntryName();
            FileOutputStream out = new FileOutputStream(fileName);
            try {
                int len;
                for (long remaining = entry.getLength(); remaining > 0L; remaining -= (long)len) {
                    len = (int)Math.min(remaining, 4096L);
                    if ((len = in.read(buffer, 0, len)) < 0) break;
                    out.write(buffer, 0, len);
                }
                var14_12 = null;
            }
            catch (Throwable throwable) {
                var14_12 = null;
                out.close();
                throw throwable;
            }
            out.close();
            {
            }
        }
    }

    private static void list(TarFile tar, boolean compressed, boolean verifyChecksum, boolean fixChecksum) throws IOException {
        Collection<FileEntry> entries = null;
        if (compressed) {
            final HashSet<FileEntry> indexEntries = new HashSet<FileEntry>();
            IndexEntryVisitor visitor = new IndexEntryVisitor(){

                public void visitEntry(TarFile file, IndexEntry entry) throws IOException {
                    String fileName = entry.getUUID().toString();
                    fileName = entry.getType() == 0 ? fileName + "(node)" : fileName + "(ref)";
                    FileEntry e = new FileEntry(file, fileName, entry.getPos(), entry.getLength());
                    indexEntries.add(e);
                }

                public void visitEndOfFile(TarFile file) {
                    FileEntry e = new FileEntry(file, "eof", Integer.MAX_VALUE, -1L);
                    indexEntries.add(e);
                }

                public void visitTransaction(TarFile file, String transactionName) {
                }

                public boolean getFailOnError() {
                    return true;
                }

                public boolean isStopped() {
                    return false;
                }
            };
            try {
                tar.scanIndex(0L, visitor, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            entries = indexEntries;
        } else {
            entries = tar.readEntries().values();
        }
        ArrayList<FileEntry> list = new ArrayList<FileEntry>(entries);
        Collections.sort(list, new Comparator<FileEntry>(){

            @Override
            public int compare(FileEntry e1, FileEntry e2) {
                long p2;
                long p1 = e1.getPos();
                return p1 < (p2 = e2.getPos()) ? -1 : (p1 > p2 ? 1 : 0);
            }
        });
        Adler32 adler = new Adler32();
        int bufferSize = 4096;
        byte[] buffer = new byte[bufferSize];
        for (FileEntry entry : list) {
            String fileName = entry.getEntryName();
            long length = entry.getLength();
            String entryText = fileName + " length: " + length + " pos: " + entry.getPos();
            int idx = fileName.indexOf(47);
            if (idx >= 0) {
                String transaction = fileName.substring(0, idx);
                try {
                    long time = Long.parseLong(transaction);
                    String date = new Timestamp(time).toString();
                    entryText = entryText + " " + date;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!verifyChecksum) {
                System.out.println(entryText);
                continue;
            }
            if (!fileName.endsWith("a")) continue;
            try {
                int l;
                adler.reset();
                InputStream in = entry.getInputStream();
                long sumBytes = 0L;
                for (long remaining = length -= 8L; remaining > 0L; remaining -= (long)l) {
                    l = (int)Math.min(remaining, (long)bufferSize);
                    l = in.read(buffer, 0, l);
                    for (int i = 0; i < l; ++i) {
                        sumBytes += (long)(buffer[i] & 0xFF);
                    }
                    adler.update(buffer, 0, l);
                }
                long real = adler.getValue();
                DataInputStream din = new DataInputStream(in);
                long check = din.readLong();
                entryText = entryText + " checksum: " + check + " sumBytes: " + sumBytes;
                System.out.println(entryText);
                if (check != real) {
                    System.out.println("ERROR: " + entryText + " checksum mismatch; expected: " + check + " got: " + real);
                    if (fixChecksum) {
                        RandomAccessFile f = new RandomAccessFile(tar.getFileName(), "r");
                        f.seek(entry.getPos() + 512L + length);
                        byte[] checksum = new byte[8];
                        f.read(checksum);
                        f.close();
                        ByteArrayInputStream bin = new ByteArrayInputStream(checksum);
                        DataInputStream din2 = new DataInputStream(bin);
                        long check2 = din2.readLong();
                        System.out.println("FIX  : " + entryText + " checksum mismatch; read: " + check2);
                        if (check == check2) {
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            DataOutputStream dout = new DataOutputStream(bout);
                            dout.writeLong(real);
                            checksum = bout.toByteArray();
                            f = new RandomAccessFile(tar.getFileName(), "rw");
                            f.seek(entry.getPos() + 512L + length);
                            f.write(checksum);
                            f.close();
                            System.out.println("OK    : " + entryText + " checksum fixed");
                        }
                    }
                }
                in.close();
            }
            catch (IOException e) {
                System.out.println("ERROR: " + entryText + " IOException: " + e);
                break;
            }
        }
    }

    public static void deleteFileWithRetry(File f) throws IOException {
        boolean ok;
        int i = 0;
        while (f.exists() && !(ok = f.delete())) {
            if (i > 16) {
                throw new IOException("Could not delete: " + f.getAbsolutePath());
            }
            try {
                Thread.sleep(i * i);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void renameWithRetry(File oldFile, File newFile) throws IOException {
        boolean ok;
        int i = 0;
        while (!(ok = oldFile.renameTo(newFile))) {
            if (i > 16) {
                throw new IOException("Could not rename: " + oldFile.getAbsolutePath() + " to " + newFile.getAbsolutePath());
            }
            try {
                Thread.sleep(i * i);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++i;
        }
    }

    public static File createDirectory(String name) throws IOException {
        File dir = new File(name);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("Could not create directory, or there is already a file with this name: " + name);
        }
        return dir;
    }

    public static File createFile(String name) throws IOException {
        File file = new File(name);
        if (!file.exists()) {
            file.createNewFile();
        }
        if (!file.exists() || !file.isFile()) {
            String msg = "Unable to create file: " + file;
            throw new IOException(msg);
        }
        return file;
    }

    public static Socket closeSilently(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static InputStream closeSilently(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static RandomAccessFile closeSilently(RandomAccessFile file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static OutputStream closeSilently(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ServerSocket closeSilently(ServerSocket listenerSocket) {
        if (listenerSocket != null) {
            try {
                listenerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static TarSet closeSilently(TarSetHandler set) {
        if (set != null) {
            try {
                set.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void check(boolean check, String message) {
        if (!check) {
            log.error("Assertion failed: " + message);
            AssertionError error = new AssertionError((Object)message);
            log.warn(message, (Throwable)((Object)error));
            throw error;
        }
    }

    public static String autoBackup(String pathName) throws IOException {
        File backup;
        File file = new File(pathName);
        String fileName = file.getName();
        File oldest = null;
        int i = 0;
        do {
            if (!(backup = new File(file.getParent(), "backup-" + i + "-" + fileName)).exists()) {
                oldest = null;
                break;
            }
            if (oldest != null && backup.lastModified() >= oldest.lastModified()) continue;
            oldest = backup;
        } while (++i < MAX_BACKUP_VERSIONS);
        if (oldest != null) {
            oldest.delete();
            backup = oldest;
        }
        TarUtils.copyFile(file, backup);
        return backup.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File source, File target) throws IOException {
        RandomAccessFile in = null;
        RandomAccessFile out = null;
        try {
            int len;
            in = new RandomAccessFile(source, "r");
            out = new RandomAccessFile(target, "rw");
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            TarUtils.closeSilently(in);
            TarUtils.closeSilently(out);
            throw throwable;
        }
        TarUtils.closeSilently(in);
        TarUtils.closeSilently(out);
    }

    public static synchronized String getFileSystemError() {
        if (fileSystemError == null) {
            try {
                fileSystemError = TarUtils.checkFileSystem();
            }
            catch (IOException e) {
                fileSystemError = "Error checking file system: " + e;
                if (log == null) {
                    System.err.println(TarUtils.class.getName() + " stopped");
                } else {
                    log.error(fileSystemError, (Throwable)e);
                }
            }
            catch (NullPointerException e) {
                if (log == null) {
                    System.err.println(TarUtils.class.getName() + " stopped");
                }
                log.error(fileSystemError, (Throwable)e);
            }
        }
        return fileSystemError;
    }

    private static String checkFileSystem() throws IOException {
        RandomAccessFile r;
        int i;
        int maxTime = 5000;
        long start = System.currentTimeMillis();
        File dir = File.createTempFile("ulimit-test", null);
        String message = "";
        if (!dir.exists()) {
            message = "Could not create the temp file " + dir.getAbsolutePath();
            log.warn(message);
            return message;
        }
        if (!dir.delete()) {
            message = "Could not delete the temp file " + dir.getAbsolutePath();
            log.warn(message);
            return message;
        }
        if (!dir.mkdirs()) {
            message = "Could not create the temp directory " + dir.getAbsolutePath();
            log.warn(message);
            return message;
        }
        long time = 0L;
        File[] files = new File[CHECK_OPEN_FILES];
        RandomAccessFile[] ra = new RandomAccessFile[CHECK_OPEN_FILES];
        for (i = 0; i < CHECK_OPEN_FILES; ++i) {
            try {
                File f;
                files[i] = f = new File(dir, "test" + i);
                ra[i] = r = new RandomAccessFile(f, "rw");
                time = System.currentTimeMillis() - start;
                if (time <= (long)maxTime) continue;
                message = "Slow file system, stopped after " + i + " files";
                log.warn(message);
            }
            catch (IOException e) {
                message = "Error after creating " + (i - 1) + " files: " + e;
                log.error(message, (Throwable)e);
                String x = e.toString().toLowerCase();
                if (x.indexOf("too many open files") < 0) break;
                TarUtils.panic();
            }
            break;
        }
        time = time == 0L ? 1L : time;
        log.info("File system status: created " + i + " files in " + time + " ms (" + (long)(i * 1000) / time + " ops/sec)");
        for (int j = 0; j < CHECK_OPEN_FILES && j <= i; ++j) {
            File f;
            r = ra[j];
            if (r != null) {
                r.close();
            }
            if ((f = files[j]) == null) continue;
            f.delete();
        }
        dir.delete();
        time = System.currentTimeMillis() - start;
        log.info("File system status calculated in " + time + " ms");
        return message;
    }

    private static void panic() {
        log.error("Blocking access to the repository because there are not enough file handles.");
        log.error("Please increase the ulimit by calling: ulimit -n 8192 and restart");
        BackupManager.getInstance().executeGuarded(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
    }

    public static int parseIntSetting(String s, int min, int max) throws NumberFormatException, IllegalArgumentException {
        int x = Integer.decode(s);
        if (x < min || x > max) {
            throw new IllegalArgumentException(x + " not in range 1 .. 1024");
        }
        return x;
    }

    public static long convertTransaction(String transaction) {
        if (transaction.indexOf(84) > 0) {
            transaction = transaction.replace('T', ' ');
            transaction = "" + Timestamp.valueOf(transaction).getTime();
        } else if (transaction.startsWith("-")) {
            long offset = Time.valueOf(transaction.substring(1)).getTime() - Time.valueOf("00:00:00").getTime();
            transaction = "" + (System.currentTimeMillis() - offset);
        }
        return Long.parseLong(transaction);
    }

    public static String getTransactionString(long transaction) {
        return new Timestamp(transaction).toString().replace(' ', 'T') + " (" + transaction + ")";
    }
}

