/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.persistence.tar.TarPersistenceManager;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexSet;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.core.stats.RepositoryStatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarSetStatistics {
    public static final String WS_SIZE_COUNTER = "WS_SIZE_COUNTER";
    public static final String WS_NODE_COUNTER = "WS_NODE_COUNTER";
    private static Logger logger = LoggerFactory.getLogger(TarPersistenceManager.class);
    private final TarSetHandler tarSet;
    private final AtomicLong workspaceNodeCounter;
    private final AtomicLong workspaceSizeCounter;

    public TarSetStatistics(TarSetHandler tarSet, String workspaceName, RepositoryStatisticsImpl repositoryStatistics) {
        this.tarSet = tarSet;
        this.workspaceSizeCounter = repositoryStatistics.getCounter("WS_SIZE_COUNTER_" + workspaceName, false);
        this.workspaceNodeCounter = repositoryStatistics.getCounter("WS_NODE_COUNTER_" + workspaceName, false);
    }

    public void update() {
        this.workspaceNodeCounter.set(this.getNodeCount());
        this.workspaceSizeCounter.set(this.getDataFilesSize());
    }

    private long getDataFilesSize() {
        List<TarFile> tarFiles = this.tarSet.getDataFiles();
        long totalFileLength = 0L;
        for (TarFile tarFile : tarFiles) {
            try {
                totalFileLength += tarFile.getFileLength();
            }
            catch (IOException e) {
                logger.warn("Could not get the tar file size", (Throwable)e);
            }
        }
        return totalFileLength;
    }

    private int getNodeCount() {
        try {
            IndexSet indexSet = this.tarSet.getIndex();
            return indexSet != null ? indexSet.size() : 0;
        }
        catch (IOException e) {
            logger.warn("Could not get the node count", (Throwable)e);
            return 0;
        }
    }
}

