/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.persistence.tar.ClusterOutOfSyncException;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexEntryVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarSetOutOfSyncRecovery {
    private static final Logger logger = LoggerFactory.getLogger(TarSetOutOfSyncRecovery.class);
    private static final String OUT_OF_SYNC_RECOVERY = "Out of sync recovery";
    private final TarSetHandler tarSetHandler;
    private final TransactionIdProcessor transactionIdProcessor = new TransactionIdProcessor();
    private Set<String> transactionsFromMaster;

    public TarSetOutOfSyncRecovery(TarSetHandler tarSetHandler) {
        this.tarSetHandler = tarSetHandler;
    }

    public void readAndSaveTransactionIds(DataInput in) {
        this.transactionsFromMaster = this.readTransactions(in);
    }

    public void writeTransactionIds(DataOutput out) {
        try {
            Set transactionsSet = this.transactionIdProcessor.getTransactionIds(this.tarSetHandler);
            String transactions = this.transactionIdProcessor.convertToString(transactionsSet);
            out.writeUTF(transactions);
        }
        catch (IOException e) {
            logger.warn("Out of sync recovery failed retrieving or writing transaction ids", (Throwable)e);
        }
    }

    public void handleOutOfSyncException(ClusterOutOfSyncException e, String workspaceName, String fileName) {
        logger.info("Out of sync recovery is trying to find the common transaction between master and slave in workspace: " + workspaceName + " and file: " + fileName);
        String lastCommonTransaction = this.findLastCommonTransaction(this.transactionsFromMaster);
        e.setLastCommonTransaction(lastCommonTransaction);
    }

    private Set<String> readTransactions(DataInput in) {
        try {
            return this.transactionIdProcessor.convertToSet(in.readUTF());
        }
        catch (IOException e) {
            logger.warn("Out of sync recovery failed reading transaction ids", (Throwable)e);
            return null;
        }
    }

    private String findLastCommonTransaction(Set<String> transactionsFromMaster) {
        if (transactionsFromMaster == null || transactionsFromMaster.isEmpty()) {
            return null;
        }
        String commonTransaction = null;
        try {
            Set transactions = this.transactionIdProcessor.getTransactionIds(this.tarSetHandler);
            String[] transactionsArray = transactions.toArray(new String[0]);
            for (int i = transactionsArray.length - 1; i >= 0; --i) {
                String current = transactionsArray[i];
                if (!transactionsFromMaster.contains(current)) continue;
                commonTransaction = current;
                break;
            }
        }
        catch (IOException e) {
            logger.warn("Out of sync recovery failed retrieving transaction ids for out of sync recovery", (Throwable)e);
        }
        if (commonTransaction == null) {
            logger.info("Out of sync recovery found no common transaction between master and slave");
        } else {
            logger.info("Out of sync recovery found a common transaction between master and slave: " + commonTransaction);
        }
        return commonTransaction;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransactionIdProcessor
    implements IndexEntryVisitor {
        private static final String DELIMETER = ":";
        private static final int NUMBER_OF_TAR_FILES_TO_PROCESS = 2;
        private Set<String> transactionIds;

        private TransactionIdProcessor() {
        }

        private Set<String> getTransactionIds(TarSetHandler tarSetHandler) throws IOException {
            this.transactionIds = new LinkedHashSet<String>();
            List<TarFile> tarFiles = tarSetHandler.getDataFiles();
            int size = tarFiles.size();
            if (size > 2) {
                tarFiles = tarFiles.subList(size - 2, size);
            }
            for (TarFile tarFile : tarFiles) {
                tarFile.scanIndex(0L, this, true);
            }
            return this.transactionIds;
        }

        private String convertToString(Set<String> transactionIds) {
            StringBuilder temp = new StringBuilder();
            for (String transactionId : transactionIds) {
                temp.append(transactionId);
                temp.append(DELIMETER);
            }
            return temp.toString();
        }

        private Set<String> convertToSet(String transactionIds) {
            if (transactionIds == null || transactionIds.length() == 0) {
                return null;
            }
            String[] temp = transactionIds.split(DELIMETER);
            return new LinkedHashSet<String>(Arrays.asList(temp));
        }

        @Override
        public void visitTransaction(TarFile file, String transactionName) {
            this.transactionIds.add(transactionName);
        }

        @Override
        public void visitEntry(TarFile file, IndexEntry entry) throws IOException {
        }

        @Override
        public void visitEndOfFile(TarFile file) throws IOException {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public boolean getFailOnError() {
            return false;
        }
    }
}

