/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.core.backup.LowDiskSpaceMonitor;
import com.day.crx.core.journal.Duration;
import com.day.crx.persistence.tar.Optimize;
import com.day.crx.persistence.tar.OptimizeFile;
import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.TarSetConfig;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.TarSetStatistics;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexEntryVisitor;
import com.day.crx.persistence.tar.index.IndexSet;
import com.day.crx.util.RepositoryLockMechanismFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Adler32;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.util.RepositoryLock;
import org.apache.jackrabbit.core.util.RepositoryLockMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarSet
implements IndexEntryVisitor,
TarSetHandler {
    public static final String INDEX_PREFIX = "index_";
    public static final String SUFFIX_NEW = ".new";
    public static final String SUFFIX_MERGING = ".merging";
    public static final String SUFFIX_TAR = ".tar";
    public static final String COMMIT_PREFIX = "commit-";
    public static final String ROLLBACK_PREFIX = "rollback-";
    public static final String END_OF_FILE = "eof";
    public static final String NODE_BUNDLE_SUFFIX = ".n";
    public static final String REFERENCES_SUFFIX = ".r";
    public static final String ADLER_CHECKSUM_SUFFIX = "a";
    public static final String COMMAND_SUFFIX = ".sh";
    public static final String INDEX_MERGED_TAR = "indexMerged.tar";
    public static final String INDEX_MERGING_TAR = "indexMerging.tar";
    static Logger log = LoggerFactory.getLogger(TarSet.class);
    static final long AUTO_COMMIT = 0L;
    static final String DATA_PREFIX = "data_";
    static final String SUFFIX_TAR_GZ = ".tar.gz";
    private static final int DEFAULT_MAX_FILE_SIZE = 256;
    private static final String STOPDELETE_TAR = "stopdelete.tar";
    private static final String DELETE_SUFFIX = ".delete";
    private static final int WAIT_BEFORE_TRY_AGAIN_LOCK = 500;
    private static final double DEFAULT_OPTIMIZE_SLEEP = 1.0;
    private static int nextId;
    protected IndexSet index;
    private OptimizeFile optimizeFile;
    private final SortedMap<Integer, TarFile> dataFiles = Collections.synchronizedSortedMap(new TreeMap());
    private final Adler32 adler = new Adler32();
    private TarFile lastDataFile;
    private String sharedPath;
    private String localPath;
    private long indexNotMerged;
    private long currentTransaction;
    private long lastTransaction;
    private long lastTouch;
    private int id;
    private boolean logEverything;
    private boolean failOnError;
    private String lockClass = RepositoryLock.class.getName();
    private int mergeIndexWhenClosing = 500;
    private TarSetConfig config = new TarSetConfig();
    private boolean optimizeWhenIdle;
    private boolean compressFiles;
    private int maxFileSize = 256;
    private RepositoryLockMechanism lockShared;
    private boolean lockSharedAcquired;
    private RepositoryLockMechanism lockLocal;
    private boolean cluster;
    private boolean optimize = true;
    private int lockTimeout;
    private boolean loadNewFiles;
    private int lockSharedCount;
    private String lastTransactionName;
    private String fileMode;
    private boolean autoSwitch = true;
    private int optimizeCount = 1;
    private double optimizeSleep = 1.0;
    private boolean useIndex = true;
    private boolean isClosed;
    private boolean isReadOnly;
    private int scanFileId;
    private long scanPos;
    private TarSetStatistics tarSetStatistics;

    public synchronized void open(String path) throws IOException {
        this.open(path, path, false, 0, "rw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(String sharedPath, String localPath, boolean cluster, int lockTimeout, String fileMode) throws IOException {
        this.id = nextId++;
        if (this.logEverything) {
            this.logDetail("open shared:" + sharedPath + " local:" + localPath + " cluster:" + cluster + " fileMode:" + fileMode + " maxFileSize:" + this.maxFileSize);
        }
        this.sharedPath = sharedPath;
        this.localPath = localPath;
        this.optimizeFile = new OptimizeFile(localPath, this);
        this.cluster = cluster;
        this.lockTimeout = lockTimeout;
        this.fileMode = fileMode;
        this.lastDataFile = null;
        this.index = null;
        this.isClosed = false;
        this.loadNewFiles = false;
        this.indexNotMerged = 0L;
        this.currentTransaction = 0L;
        this.lastTransaction = 0L;
        this.lastTransactionName = null;
        this.lockSharedCount = 0;
        this.lastTouch = 0L;
        this.isReadOnly = "r".equals(fileMode);
        TarUtils.createDirectory(localPath);
        this.deleteOldFiles(localPath);
        if (!sharedPath.equals(localPath)) {
            TarUtils.createDirectory(sharedPath);
            this.deleteOldFiles(sharedPath);
        }
        this.loadDataFiles();
        try {
            this.lockLocal = RepositoryLockMechanismFactory.createInstance(this.lockClass);
            this.lockLocal.init(localPath);
            this.lockLocal.acquire();
        }
        catch (RepositoryException e) {
            this.lockLocal = null;
            log.debug("tar set already locked", (Throwable)e);
            IOException io = new IOException("Tar set local area already in use at " + localPath + ": " + (Object)((Object)e));
            io.initCause(e);
            throw io;
        }
        boolean opened = false;
        try {
            if (this.useIndex) {
                this.index = new IndexSet(this, localPath);
                this.index.setMergeWhenClosing(this.mergeIndexWhenClosing);
                this.index.open();
            }
            boolean switchNeeded = true;
            if (this.lastDataFile != null && !this.lastDataFile.isReadOnly() && this.lastDataFile.getCompressed() == this.compressFiles) {
                switchNeeded = false;
            }
            this.scanIndex();
            if (switchNeeded && !this.isReadOnly && (this.lastDataFile == null || this.autoSwitch)) {
                this.switchDataFile(this.compressFiles);
            }
        }
        finally {
            if (!opened) {
                try {
                    this.lockLocal.release();
                }
                catch (RepositoryException e) {}
                this.lockLocal = null;
            }
        }
        if (this.optimize && !this.isReadOnly) {
            OptimizeThread.getInstance().addTarSet(this);
        }
    }

    public void deleteOldFiles(String dir) {
        for (File f : new File(dir).listFiles()) {
            if (!f.getName().endsWith(DELETE_SUFFIX)) continue;
            String path = f.getPath();
            f.delete();
            String name = path.substring(0, path.length() - DELETE_SUFFIX.length());
            f = new File(name);
            f.delete();
        }
    }

    @Override
    public synchronized void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanIndex() throws IOException {
        this.lockShared();
        try {
            int lastScanned = -1;
            while (true) {
                int fileId = 0;
                long pos = 0L;
                if (this.useIndex) {
                    fileId = this.index.getToFile();
                    pos = this.index.getToPos();
                    this.scanFileId = fileId;
                    this.scanPos = pos;
                } else if (this.lastDataFile != null && this.scanFileId == (fileId = this.lastDataFile.getId()) && this.lastDataFile.getFileLength() > this.scanPos) {
                    pos = this.scanPos;
                }
                for (int id : this.dataFiles.keySet()) {
                    if (id <= lastScanned || id < fileId) continue;
                    long p = id == fileId ? pos : 0L;
                    TarFile file = (TarFile)this.dataFiles.get(id);
                    if (file.getFileLength() > 0x2000000L) {
                        log.info("scanning index " + file);
                    } else {
                        log.debug("scanning index " + file);
                    }
                    file.scanIndex(p, this, true);
                    if (!this.loadNewFiles && file.getScannedEntriesCount() == 0 && p > 0L) {
                        String message = "Tar index newer than the data. Please remove the index*.tar file(s) and re-start. Scan position: " + p + " file: " + file;
                        log.error(message);
                        throw new IOException(message);
                    }
                    if (id <= lastScanned) continue;
                    lastScanned = id;
                }
                if (this.loadNewFiles) {
                    this.loadDataFiles();
                    this.loadNewFiles = false;
                    continue;
                }
                break;
            }
        }
        finally {
            this.unlockShared();
        }
    }

    @Override
    public synchronized void deleteDataFile(int fileId) throws IOException {
        this.logDetail("deleteDataFile " + fileId);
        TarFile file = this.getDataFile(fileId);
        if (file == null) {
            log.warn("Could not delete data file " + fileId + ": not found. Already deleted?");
            return;
        }
        if (this.dataFiles.size() <= 1) {
            throw new IOException("Can not remove last file");
        }
        Duration maxAge = this.config.getMaximumAge();
        if (maxAge != null) {
            Calendar earliestDelete = Calendar.getInstance();
            earliestDelete.setTimeInMillis(file.getLastModified());
            maxAge.addTo(earliestDelete);
            long earliest = earliestDelete.getTimeInMillis();
            if (earliest > Calendar.getInstance().getTimeInMillis()) {
                return;
            }
        }
        file.close();
        this.dataFiles.remove(fileId);
        file.deleteLater(false);
    }

    private void addDataFile(TarFile file) throws IOException {
        this.dataFiles.put(file.getId(), file);
        if (this.lastDataFile == null) {
            this.lastDataFile = file;
        } else if (file.getId() > this.lastDataFile.getId()) {
            this.lastDataFile.reopen("r");
            this.lastDataFile = file;
        }
        if (this.dataFiles.size() <= this.config.getCacheFiles()) {
            return;
        }
        if (!this.config.isCluster()) {
            return;
        }
        List<TarFile> files = this.getDataFiles();
        for (int i = 0; i < files.size() - this.config.getCacheFiles(); ++i) {
            TarFile oldFile = files.get(i);
            String sharedPath = this.config.getSharedPath();
            if (oldFile.getFileName().startsWith(sharedPath)) continue;
            int id = oldFile.getId();
            String name = oldFile.getFileName();
            File f = new File(name);
            name = sharedPath + "/" + f.getName();
            boolean compress = oldFile.getCompressed();
            file = new TarFile(name, id, compress, "r");
            this.dataFiles.put(file.getId(), file);
            oldFile.deleteLater(false);
        }
    }

    public synchronized void switchDataFile(int nextId, boolean compress) throws IOException {
        String number = nextId > 99999 ? Integer.toString(nextId) : Integer.toString(100000 + nextId).substring(1);
        String name = this.sharedPath + "/" + DATA_PREFIX + number;
        name = compress ? name + SUFFIX_TAR_GZ : name + SUFFIX_TAR;
        TarFile file = new TarFile(name, nextId, compress, this.fileMode);
        this.addDataFile(file);
    }

    @Override
    public synchronized void switchDataFile(boolean compress) throws IOException {
        int nextId;
        if (this.dataFiles.size() == 0) {
            nextId = 0;
        } else {
            TarFile file = (TarFile)this.dataFiles.get(this.dataFiles.lastKey());
            nextId = file.getId() + 1;
        }
        this.logDetail("switchDataFile nextId:" + nextId + " compress:" + compress);
        if (this.lastDataFile != null) {
            this.lastDataFile.append(END_OF_FILE, new byte[0], 0L);
        }
        this.switchDataFile(nextId, compress);
        if (this.dataFiles.size() > 2) {
            ArrayList<Integer> keys = new ArrayList<Integer>(this.dataFiles.keySet());
            Collections.sort(keys);
            int id = keys.get(keys.size() - 3);
            if (this.config.getMaximumAge() != null) {
                for (int x : keys) {
                    long size = this.dataFiles.size();
                    if (size != 1L) {
                        this.deleteIfUnused(this.getDataFile(x));
                        if ((long)this.dataFiles.size() != size) continue;
                    }
                    break;
                }
            } else if (this.config.isGenerationalGC()) {
                this.deleteIfUnused(this.getDataFile(id));
            }
        }
    }

    private void deleteIfUnused(TarFile tarFile) {
        try {
            IndexEntryVisitor visitor = new IndexEntryVisitor(){
                private boolean stopped;

                public boolean getFailOnError() {
                    return true;
                }

                public void visitEndOfFile(TarFile file) throws IOException {
                }

                public void visitEntry(TarFile file, IndexEntry entry) throws IOException {
                    IndexEntry live = TarSet.this.index.getEntry(entry.getUUID(), entry.getType(), false);
                    if (live != null && live.getFileId() == file.getId()) {
                        this.stopped = true;
                    }
                }

                public void visitTransaction(TarFile file, String transactionName) {
                }

                public boolean isStopped() {
                    return this.stopped;
                }
            };
            if (this.useIndex) {
                tarFile.scanIndex(0L, visitor, true);
            }
            if (!visitor.isStopped()) {
                log.info("Deleting " + tarFile.getFileName());
                this.deleteDataFile(tarFile.getId());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        this.close(!this.isReadOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean alwaysMergeIndex) throws IOException {
        this.setOptimizeNowEnd();
        OptimizeThread.getInstance().removeTarSet(this);
        TarSet tarSet = this;
        synchronized (tarSet) {
            if (this.isClosed) {
                return;
            }
            this.logDetail("close " + alwaysMergeIndex);
            if (this.index != null) {
                this.index.close(alwaysMergeIndex);
                this.index = null;
            }
            for (TarFile file : this.dataFiles.values()) {
                file.close();
            }
            this.dataFiles.clear();
            if (this.lastDataFile != null) {
                this.lastDataFile.close();
                this.lastDataFile = null;
            }
            if (this.lockLocal != null) {
                try {
                    this.lockLocal.release();
                }
                catch (RepositoryException e) {
                    log.warn("Could not unlock", (Throwable)e);
                }
                this.lockLocal = null;
            }
            this.isClosed = true;
        }
    }

    @Override
    public synchronized IndexEntry append(NodeId uuid, int type, byte[] data) throws IOException {
        return this.append(uuid, type, data, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendRawBytes(byte[] data, int off, int len) throws IOException {
        this.lockShared();
        try {
            long pos = this.lastDataFile.getAppendPos();
            this.lastDataFile.seek(pos);
            this.lastDataFile.write(data, off, len);
            this.lastDataFile.setAppendPos(pos + (long)len);
        }
        finally {
            this.unlockShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scanIndexAfterAppend() throws IOException {
        this.lockShared();
        try {
            int fileId = this.index.getToFile();
            long pos = this.index.getToPos();
            for (int id : this.dataFiles.keySet()) {
                if (id < fileId) continue;
                long p = id == fileId ? pos : 0L;
                TarFile file = (TarFile)this.dataFiles.get(id);
                file.scanIndex(p, this, true);
            }
        }
        finally {
            this.unlockShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IndexEntry append(NodeId uuid, int type, byte[] data, long time) throws IOException {
        this.lockShared();
        try {
            IndexEntry entry;
            byte[] dataAndChecksum;
            boolean autoCommit = this.currentTransaction == 0L;
            StringBuffer buff = new StringBuffer();
            if (!autoCommit) {
                buff.append(this.currentTransaction);
                buff.append('/');
            }
            boolean adlerChecksum = data.length > 0;
            buff.append(uuid.toString());
            if (type == 0) {
                buff.append(NODE_BUNDLE_SUFFIX);
                if (adlerChecksum) {
                    buff.append(ADLER_CHECKSUM_SUFFIX);
                }
            } else if (type == 1) {
                buff.append(REFERENCES_SUFFIX);
                if (adlerChecksum) {
                    buff.append(ADLER_CHECKSUM_SUFFIX);
                }
            } else {
                throw new AssertionError((Object)("type:" + type));
            }
            long oldPos = this.lastDataFile.getAppendPos();
            String entryName = buff.toString();
            long entryLength = data.length;
            if (adlerChecksum) {
                this.adler.reset();
                this.adler.update(data);
                dataAndChecksum = new byte[data.length + 8];
                System.arraycopy(data, 0, dataAndChecksum, 0, data.length);
                long checksum = this.adler.getValue();
                TarSet.writeLong(dataAndChecksum, data.length, checksum);
            } else {
                dataAndChecksum = data;
            }
            long pos = this.lastDataFile.append(entryName, dataAndChecksum, time);
            if (this.useIndex) {
                entry = new IndexEntry(uuid, type);
                entry.setFileId(this.lastDataFile.getId());
                entry.setPos(pos);
                entry.setLength(entryLength);
                this.index.addOrUpdateEntry(autoCommit, entry);
            } else {
                entry = null;
            }
            if (this.logEverything) {
                this.logDetail("append " + uuid + " len:" + data.length + " fileId:" + this.lastDataFile.getId() + " pos:" + pos);
            }
            if (autoCommit) {
                this.switchFilesIfRequired(oldPos);
            }
            IndexEntry indexEntry = entry;
            return indexEntry;
        }
        finally {
            this.unlockShared();
        }
    }

    private static void writeLong(byte[] data, int pos, long x) {
        TarSet.writeInt(data, pos, (int)(x >>> 32));
        TarSet.writeInt(data, pos + 4, (int)x);
    }

    private static void writeInt(byte[] data, int pos, int x) {
        byte[] buff = data;
        buff[pos] = (byte)(x >> 24);
        buff[pos + 1] = (byte)(x >> 16);
        buff[pos + 2] = (byte)(x >> 8);
        buff[pos + 3] = (byte)x;
    }

    private void switchFilesIfRequired(long oldPos) throws IOException {
        long newPos = this.lastDataFile.getAppendPos();
        if (newPos > (long)this.maxFileSize * 1024L * 1024L) {
            this.switchDataFile(this.compressFiles);
        }
        if (this.useIndex) {
            this.indexNotMerged += newPos - oldPos;
            if (this.indexNotMerged > (long)this.config.getIndexMaxBuffer() * 1024L * 1024L) {
                this.index.mergeIndex();
            }
        }
    }

    public void indexMergeStarted() {
        this.indexNotMerged = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void appendCommit(long tx) throws IOException {
        this.logDetail("appendCommit");
        if (this.currentTransaction != tx && this.currentTransaction != 0L) {
            throw new IOException("Commit for transaction: " + tx + " but expected " + this.currentTransaction);
        }
        this.lockShared();
        try {
            String entryName = COMMIT_PREFIX + tx + COMMAND_SUFFIX;
            long oldPos = this.lastDataFile.getAppendPos();
            byte[] data = ("mv " + tx + "/* .").getBytes();
            this.lastDataFile.append(entryName, data, tx);
            if (this.useIndex) {
                this.index.commit();
            }
            this.switchFilesIfRequired(oldPos);
            this.currentTransaction = 0L;
        }
        finally {
            this.unlockShared();
        }
        if (this.logEverything) {
            this.logDetail(" new pos: " + this.lastDataFile.getFileLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void appendRollback(long tx) throws IOException {
        this.logDetail("appendRollback");
        if (this.currentTransaction != tx && this.currentTransaction != 0L) {
            throw new IOException("Rollback for transaction: " + tx + " but expected " + this.currentTransaction);
        }
        this.lockShared();
        try {
            String entryName = ROLLBACK_PREFIX + tx + COMMAND_SUFFIX;
            long oldPos = this.lastDataFile.getAppendPos();
            byte[] data = ("rm " + tx + "/*").getBytes();
            this.lastDataFile.append(entryName, data, tx);
            if (this.useIndex) {
                this.index.rollback();
            }
            this.switchFilesIfRequired(oldPos);
            this.currentTransaction = 0L;
        }
        finally {
            this.unlockShared();
        }
    }

    @Override
    public boolean exists(NodeId uuid, int type) throws IOException {
        IndexEntry entry;
        if (this.logEverything) {
            this.logDetail("exists " + uuid);
        }
        return (entry = this.index.getEntry(uuid, type, false)) != null && entry.getLength() != 0L;
    }

    @Override
    public IndexEntry getIndexEntry(NodeId uuid, int type) throws IOException {
        return this.index.getEntry(uuid, type, false);
    }

    synchronized byte[] readData(NodeId uuid, int type) throws IOException {
        IndexEntry entry = this.getIndexEntry(uuid, type);
        if (entry == null || entry.getLength() == 0L) {
            return null;
        }
        long l = entry.getLength();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Entry too large: " + uuid + " " + l);
        }
        InputStream in = this.getInputStream(entry);
        int len = (int)l;
        byte[] data = new byte[len];
        TarFile.readFully(in, data, len);
        return data;
    }

    @Override
    public InputStream getInputStream(NodeId uuid, int type) throws IOException {
        if (OptimizeThread.BUG_34668) {
            byte[] data = this.readData(uuid, type);
            return data == null ? null : new ByteArrayInputStream(data);
        }
        IndexEntry entry = this.getIndexEntry(uuid, type);
        if (entry == null || entry.getLength() == 0L) {
            return null;
        }
        return new BufferedInputStream(this.getInputStream(entry), 4096);
    }

    InputStream getInputStream(IndexEntry entry) throws IOException {
        int i = 0;
        int fileId;
        TarFile file;
        while ((file = this.getDataFile(fileId = entry.getFileId())) == null) {
            StringBuilder buff = new StringBuilder();
            buff.append("File not found: ").append(fileId).append(" for entry ").append(entry).append(" from ").append(this.localPath).append(" ").append(this.dataFiles.keySet()).append(".\n").append("\n").append("Index files: ").append(this.index.getIndexFiles());
            if (i > 0) {
                buff.append("The data*.tar files are now read-only for security reasons.\n").append("To continue, stop CRX, make the data*.tar files read-write, add the missing data*.tar file, ").append("or re-build this cluster node, ").append("or (not recommended) delete the index*.tar files.");
            }
            String msg = buff.toString();
            IOException e = new IOException(msg);
            if (i != 0) {
                log.error(msg, (Throwable)e);
                for (TarFile f : this.dataFiles.values()) {
                    f.setReadOnly();
                }
                this.close();
                LowDiskSpaceMonitor.getInstance().closeRepository("Missing file(s). The repository will be closed now.");
                throw e;
            }
            log.warn(msg, (Throwable)e);
            this.index.reopen();
            entry = this.getIndexEntry(entry.getUUID(), entry.getType());
            ++i;
        }
        return file.getInputStream(entry.getPos(), (int)entry.getLength());
    }

    @Override
    public List<TarFile> getDataFiles() {
        if (this.dataFiles == null) {
            return new ArrayList<TarFile>();
        }
        return new ArrayList<TarFile>(this.dataFiles.values());
    }

    public synchronized TarFile getDataFile(int fileId) {
        TarFile file = this.lastDataFile != null && fileId == this.lastDataFile.getId() ? this.lastDataFile : (TarFile)this.dataFiles.get(fileId);
        return file;
    }

    @Override
    public void visitEntry(TarFile file, IndexEntry entry) throws IOException {
        if (this.useIndex) {
            if (this.logEverything) {
                this.logDetail(" visit " + entry.getUUID() + " len: " + entry.getLength());
            }
            this.index.addOrUpdateEntry(true, entry);
        }
    }

    @Override
    public synchronized void visitEndOfFile(TarFile file) throws IOException {
        if (this.logEverything) {
            this.logDetail(" visit EOF");
        }
        this.loadNewFiles = true;
    }

    @Override
    public void visitTransaction(TarFile file, String transactionName) {
        if (this.logEverything) {
            this.logDetail(" visit transaction " + transactionName);
        }
        if (this.lastTransactionName == null || !this.lastTransactionName.equals(transactionName)) {
            this.lastTransactionName = transactionName;
            try {
                long t = Long.parseLong(transactionName);
                this.lastTransaction = Math.max(this.lastTransaction, t);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void loadDataFiles() throws IOException {
        this.loadDataFiles(this.sharedPath);
        if (this.config.getCacheFiles() < Integer.MAX_VALUE && this.config.isCluster() && !this.sharedPath.equals(this.config.getSharedPath())) {
            this.loadDataFiles(this.config.getSharedPath());
        }
    }

    private void loadDataFiles(String path) throws IOException {
        for (File f : new File(path).listFiles()) {
            String suffix;
            boolean compressed;
            String name;
            if (!f.canRead() || f.isDirectory() || !f.isFile() || !(name = f.getName().toLowerCase()).startsWith(DATA_PREFIX)) continue;
            if (name.endsWith(SUFFIX_TAR_GZ)) {
                compressed = true;
                suffix = SUFFIX_TAR_GZ;
            } else {
                if (!name.endsWith(SUFFIX_TAR)) continue;
                compressed = false;
                suffix = SUFFIX_TAR;
            }
            String idName = name.substring(DATA_PREFIX.length(), name.indexOf(suffix));
            try {
                int id = Integer.parseInt(idName);
                if (id < 0 || this.getDataFile(id) != null) continue;
                TarFile file = new TarFile(f.getAbsolutePath(), id, compressed, this.fileMode);
                this.addDataFile(file);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    @Override
    public long getLastTransaction() {
        return this.lastTransaction;
    }

    @Override
    public synchronized void startTransaction(long tx) throws IOException {
        if (this.currentTransaction != 0L) {
            throw new IOException("Last transaction not committed or rolled back");
        }
        this.currentTransaction = this.lastTransaction = tx;
    }

    @Override
    public synchronized void setTransaction(long tx) {
        this.currentTransaction = this.lastTransaction = tx;
    }

    @Override
    public synchronized long getTransaction() {
        return this.currentTransaction;
    }

    public String toString() {
        return "TarSet: " + this.sharedPath + " " + this.localPath + " id: " + this.id + " readOnly: " + this.isReadOnly + (this.isClosed ? " closed" : "");
    }

    @Override
    public void touch() {
        this.lastTouch = System.currentTimeMillis();
    }

    @Override
    public long getLastTouch() {
        return this.lastTouch;
    }

    @Override
    public IndexSet getIndex() {
        return this.index;
    }

    @Override
    public boolean getOptimizeWhenIdle() {
        return this.optimizeWhenIdle;
    }

    @Override
    public void setOptimizeWhenIdle(boolean optimizeWhenIdle) {
        this.optimizeWhenIdle = optimizeWhenIdle;
    }

    boolean needOptimize() {
        for (TarFile file : this.getDataFiles()) {
            if (!file.getNeedToOptimize()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDelete() {
        String stopDeleteFileName = this.sharedPath + "/" + STOPDELETE_TAR;
        return !new File(stopDeleteFileName).exists();
    }

    @Override
    public boolean getCompressFiles() {
        return this.compressFiles;
    }

    @Override
    public void setCompressFiles(boolean compressFiles) {
        this.compressFiles = compressFiles;
    }

    @Override
    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    @Override
    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = Math.min(1024, maxFileSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void readExternalChanges() throws IOException {
        this.lockShared();
        try {
            if (this.lastDataFile == null) {
                return;
            }
            long fileLength = this.lastDataFile.getFileLength();
            if (this.logEverything) {
                this.logDetail("readExternalChanges " + fileLength);
            }
            if (fileLength != this.lastDataFile.getFileLengthCached()) {
                this.scanIndex();
            }
            this.logDetail("readExternalChanges done");
        }
        finally {
            this.unlockShared();
        }
    }

    @Override
    public synchronized void lockShared() throws IOException {
        if (!this.cluster) {
            return;
        }
        if (!OptimizeThread.LOCK_SHARED) {
            return;
        }
        if (this.lockSharedCount > 0) {
            if (this.lockSharedCount > 10) {
                throw new IOException("Internal error: shared lock count=" + this.lockSharedCount);
            }
            ++this.lockSharedCount;
            return;
        }
        if (this.lockShared == null) {
            try {
                this.lockShared = RepositoryLockMechanismFactory.createInstance(this.lockClass);
                this.lockShared.init(this.sharedPath);
            }
            catch (RepositoryException e) {
                IOException e2 = new IOException("Unable to lock " + this.sharedPath + " message: " + e.toString());
                e2.initCause(e);
                throw e2;
            }
        }
        long start = System.currentTimeMillis();
        while (true) {
            try {
                this.logDetail("lockShared.acquire");
                this.lockShared.acquire();
                this.lockSharedAcquired = true;
                this.logDetail("lockShared.acquire done");
            }
            catch (RepositoryException e) {
                long time;
                if (this.logEverything) {
                    this.logDetail("Can not lock: " + e.toString());
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (this.lockTimeout <= 0 || (time = System.currentTimeMillis() - start) <= (long)this.lockTimeout) continue;
                throw new IOException("Lock timeout trying to lock " + this.sharedPath);
            }
            break;
        }
        ++this.lockSharedCount;
    }

    @Override
    public void lockShared(boolean write) throws IOException {
        this.lockShared();
    }

    @Override
    public synchronized void unlockShared() {
        if (!this.cluster) {
            return;
        }
        if (!OptimizeThread.LOCK_SHARED) {
            return;
        }
        if (--this.lockSharedCount < 1) {
            TarUtils.check(this.lockSharedCount == 0, "Shared data lock=" + this.lockSharedCount);
            if (this.lockSharedAcquired) {
                this.logDetail("lockShared.release");
                try {
                    this.lockShared.release();
                }
                catch (RepositoryException e) {
                    log.warn("Could not unlock", (Throwable)e);
                }
                this.lockSharedAcquired = false;
            }
            this.logDetail("lockShared.release done");
        }
    }

    @Override
    public synchronized void kill() {
        if (this.lastDataFile != null) {
            this.lastDataFile.close();
        }
        if (this.index != null) {
            this.index.kill();
            this.index = null;
        }
        this.unlockShared();
        if (this.lockLocal != null) {
            try {
                this.lockLocal.release();
            }
            catch (RepositoryException e) {
                log.warn("Could not unlock", (Throwable)e);
            }
            this.lockLocal = null;
        }
        OptimizeThread.getInstance().removeTarSet(this);
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDetail(String s) {
        if (this.logEverything) {
            TarSet tarSet = this;
            synchronized (tarSet) {
                log.error("#" + this.id + ": " + s);
            }
        }
    }

    @Override
    public void setLogEverything(boolean logEverything) {
        this.logEverything = logEverything;
    }

    @Override
    public boolean getLogEverything() {
        return this.logEverything;
    }

    @Override
    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    @Override
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Override
    public boolean isStopped() {
        return false;
    }

    @Override
    public synchronized TarFile getLastDataFile() {
        return this.lastDataFile;
    }

    @Override
    public Optimize createOptimizer() {
        return new Optimize(this, this);
    }

    void setAutoSwitch(boolean autoSwitch) {
        this.autoSwitch = autoSwitch;
    }

    boolean getAutoSwitch() {
        return this.autoSwitch;
    }

    @Override
    public String getLocalPath() {
        return this.localPath;
    }

    @Override
    public int getOptimizeCount() {
        return this.optimizeCount;
    }

    @Override
    public void setOptimizeCount(int optimizeCount) {
        this.optimizeCount = optimizeCount;
    }

    @Override
    public double getOptimizeSleep() {
        return this.optimizeSleep;
    }

    @Override
    public void setOptimizeSleep(double optimizeSleep) {
        this.optimizeSleep = optimizeSleep;
    }

    @Override
    public void setUseIndex(boolean useIndex) {
        this.useIndex = useIndex;
    }

    @Override
    public String getLockClass() {
        return this.lockClass;
    }

    @Override
    public void setLockClass(String lockClass) {
        this.lockClass = lockClass;
    }

    @Override
    public int getMergeIndexWhenClosing() {
        return this.mergeIndexWhenClosing;
    }

    @Override
    public void setMergeIndexWhenClosing(int mergeIndexWhenClosing) {
        this.mergeIndexWhenClosing = mergeIndexWhenClosing;
    }

    @Override
    public void setConfig(TarSetConfig config) {
        this.config = config;
    }

    @Override
    public TarSetConfig getConfig() {
        return this.config;
    }

    public int getScanFileId() {
        return this.scanFileId;
    }

    public long getScanPos() {
        return this.scanPos;
    }

    @Override
    public void setScanFileId(int scanFileId) {
        this.scanFileId = scanFileId;
    }

    @Override
    public void setScanPos(long scanPos) {
        this.scanPos = scanPos;
    }

    @Override
    public boolean isMaster() {
        return true;
    }

    public static String formatList(List<TarFile> list) {
        StringBuilder buff = new StringBuilder("(\n");
        for (TarFile f : list) {
            buff.append("  ").append(f.toString()).append('\n');
        }
        buff.append(")");
        return buff.toString();
    }

    @Override
    public boolean sync(boolean force) {
        return true;
    }

    @Override
    public boolean getOptimizeNow() {
        if (this.optimizeFile == null) {
            return false;
        }
        return this.optimizeFile.getOptimizeNow();
    }

    @Override
    public void setOptimizeNowEnd() {
        if (this.optimizeFile != null) {
            this.optimizeFile.setOptimizeNowEnd();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public TarSetStatistics getTarSetStatistics() {
        return this.tarSetStatistics;
    }

    @Override
    public void setTarSetStatistics(TarSetStatistics value) {
        this.tarSetStatistics = value;
    }

    public void readIndex() {
        if (!Boolean.parseBoolean(System.getProperty("com.day.crx.persistence.tar.OptimizeReadIndex", "true"))) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.index != null) {
            try {
                this.index.readFiles();
            }
            catch (IOException e) {
                log.warn("Could not read index files", (Throwable)e);
            }
        }
        if ((time = System.currentTimeMillis() - time) > 1000L) {
            log.info("Reading indexes took {} ms", (Object)time);
        }
    }

    @Override
    public long[] findTransactionStart(long transaction, boolean previous) throws IOException {
        ArrayList<TarFile> files = new ArrayList<TarFile>(this.dataFiles.values());
        Collections.reverse(files);
        final String tx = Long.toString(transaction);
        final long[] prev = new long[2];
        final long[] start = new long[2];
        final AtomicBoolean found = new AtomicBoolean();
        for (TarFile file : files) {
            final AtomicBoolean scanMore = new AtomicBoolean();
            TarFile f = new TarFile(file.getFileName(), file.getId(), file.getCompressed(), "r");
            f.scanIndex(0L, new IndexEntryVisitor(){
                boolean stopped;
                boolean match;
                boolean first = true;

                public boolean getFailOnError() {
                    return false;
                }

                public boolean isStopped() {
                    return this.stopped;
                }

                public void visitEndOfFile(TarFile file) throws IOException {
                }

                public void visitEntry(TarFile file, IndexEntry entry) throws IOException {
                    if (this.stopped) {
                        return;
                    }
                    if (this.match) {
                        start[0] = entry.getFileId();
                        start[1] = entry.getPos();
                        this.stopped = true;
                        found.set(true);
                    } else {
                        prev[0] = entry.getFileId();
                        prev[1] = entry.getPos();
                    }
                }

                public void visitTransaction(TarFile file, String transactionName) {
                    if (!this.match) {
                        if (transactionName.compareTo(tx) > 0) {
                            this.match = true;
                            if (this.first) {
                                scanMore.set(true);
                            }
                        }
                        if (this.first) {
                            try {
                                long t = Long.parseLong(transactionName);
                                String d = new Timestamp(t).toString().replace(' ', 'T');
                                log.info("First transaction for " + file.getFileName() + " is " + transactionName + " / " + d);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.first = false;
                        }
                    }
                }
            }, true);
            f.close();
            if (scanMore.get()) continue;
            break;
        }
        if (found.get()) {
            return previous ? prev : start;
        }
        return null;
    }

    @Override
    public void truncate(int fileId, long pos) throws IOException {
        ArrayList<String> toBeDeleted = new ArrayList<String>();
        for (TarFile f : this.dataFiles.values()) {
            if (f.getId() > fileId) {
                log.info("Truncating to transaction: delete " + f.toString());
                toBeDeleted.add(f.getFileName());
                continue;
            }
            if (f.getId() == fileId) {
                log.info("Truncating to transaction: truncating " + f.toString() + " to " + pos);
                f.truncate(pos);
                continue;
            }
            log.info("Truncating to transaction: keeping " + f.toString());
        }
        this.index.truncate(fileId, pos);
        this.close();
        for (String delete : toBeDeleted) {
            log.info("Truncating to transaction: deleting " + delete);
            TarUtils.deleteFileWithRetry(new File(delete));
        }
        this.open(this.sharedPath, this.localPath, this.cluster, this.lockTimeout, this.fileMode);
    }
}

