/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.persistence.tar.TarPersistence;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.util.StringIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarPersistenceStringIndex
implements StringIndex {
    public static final NodeId MAGIC_NAME_INDEX_ID = new NodeId(-4548986510476657986L, -3819410105351357762L);
    public static final NodeId MAGIC_NS_INDEX_ID = new NodeId(54288243828375774L, -3819410105351357762L);
    private static Logger log = LoggerFactory.getLogger(TarPersistenceStringIndex.class);
    private final TarPersistence persistence;
    private final NodeId magic;
    private final HashMap<String, Integer> stringToIndex = new HashMap();
    private final HashMap<Integer, String> indexToString = new HashMap();
    private final Properties stringToIndexProps = new Properties();

    TarPersistenceStringIndex(TarPersistence persistence, NodeId magic) {
        this.persistence = persistence;
        this.magic = magic;
    }

    public static StringIndex getIndex(TarPersistence persistence, FileSystem fs, String resource, NodeId magic, StringIndex old) {
        try {
            if (old != null) {
                return old;
            }
            FileSystemResource res = new FileSystemResource(fs, resource);
            if (res.exists()) {
                log.debug("Using file based index: " + res.getFileSystem() + "/" + resource);
                return null;
            }
            log.debug("Using tar index because file not found: " + res.getFileSystem().toString() + "/" + resource);
            return new TarPersistenceStringIndex(persistence, magic);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create string index: " + resource + " " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        try {
            this.persistence.refresh();
            this.stringToIndexProps.clear();
            this.stringToIndex.clear();
            this.indexToString.clear();
            InputStream in = null;
            TarPersistence tarPersistence = this.persistence;
            synchronized (tarPersistence) {
                in = this.persistence.getInputStream(this.magic, 0);
            }
            if (in != null) {
                this.stringToIndexProps.load(in);
                in.close();
                for (Map.Entry<Object, Object> entry : this.stringToIndexProps.entrySet()) {
                    String string = entry.getKey().toString();
                    String prop = entry.getValue().toString();
                    Integer idx = Integer.valueOf(prop);
                    this.stringToIndex.put(string, idx);
                    this.indexToString.put(idx, string);
                }
            }
        }
        catch (Exception e) {
            log.error("Unable to load lookup table", (Throwable)e);
            throw new IllegalStateException("Unable to load lookup table: " + e, e);
        }
    }

    private void save() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.stringToIndexProps.size() * 10);
        try {
            this.stringToIndexProps.store(out, "string index");
        }
        catch (IOException e) {
            log.error("Unable to save lookup table", (Throwable)e);
            throw new IllegalStateException("Unable to save lookup table: " + e, e);
        }
        byte[] data = out.toByteArray();
        Exception lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.trySave(data);
                return;
            }
            catch (Exception e) {
                log.warn("Unable to save lookup table: ", (Throwable)e);
                lastException = e;
                continue;
            }
        }
        throw new IllegalStateException("Unable to save lookup table: " + lastException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySave(byte[] data) throws IOException, ItemStateException {
        TarPersistence tarPersistence = this.persistence;
        synchronized (tarPersistence) {
            this.persistence.refresh();
            this.persistence.lockExclusive();
            try {
                this.persistence.append(this.magic, 0, data);
                Object var4_3 = null;
                this.persistence.unlockExclusive();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.persistence.unlockExclusive();
                throw throwable;
            }
        }
    }

    public String indexToString(int i) {
        String s = this.indexToString.get(i);
        if (s == null) {
            this.load();
            s = this.indexToString.get(i);
        }
        return s;
    }

    public int stringToIndex(String string) {
        Integer idx = this.stringToIndex.get(string);
        if (idx == null) {
            this.load();
            idx = this.stringToIndex.get(string);
            if (idx == null) {
                idx = this.indexToString.size();
                this.stringToIndex.put(string, idx);
                this.indexToString.put(idx, string);
                this.stringToIndexProps.put(string, idx.toString());
                this.save();
            }
        }
        return idx;
    }
}

