/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.cluster.ClusterRole;
import com.day.crx.core.journal.CRXFileRevision;
import com.day.crx.core.journal.Duration;
import com.day.crx.persistence.CRXPMContext;
import com.day.crx.persistence.tar.ClusterTarSet;
import com.day.crx.persistence.tar.TarJournalPersistence;
import com.day.crx.persistence.tar.TarPersistenceManager;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexEntryVisitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AbstractRecord;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.stats.RepositoryStatisticsImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarJournal
extends AbstractJournal
implements ClusterRole {
    protected static final NodeId JOURNAL = new NodeId("cafebabe-7a10-face-babe-cafebabecafe");
    static final String TAR_JOURNAL = "tarJournal";
    private static final Duration DEFAULT_MAX_AGE = new Duration("P30D");
    private static final int TAR_FILE_ID_SHIFT = 40;
    private static Logger log = LoggerFactory.getLogger(TarJournal.class);
    TarJournalPersistence persistence;
    private String sharedPath;
    private boolean sharedNothing = true;
    private String repositoryHome;
    private boolean preferredMaster;
    private Duration maximumAge;
    private String portList;
    private String bindAddress;
    private String sharedHome;
    private String maxFileSize;
    private boolean closed;
    private boolean revisionZeroProcessed;
    private boolean becomeMasterOnTimeout;
    private long lastTransaction;
    private boolean outOfSyncRecoveryEnabled;
    private AtomicBoolean isLocked = new AtomicBoolean();
    private Map<Integer, TarFile> readOnlyTarFiles = new HashMap<Integer, TarFile>();

    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
        try {
            this.repositoryHome = this.getRepositoryHome().getCanonicalPath();
        }
        catch (IOException e) {
            throw new JournalException("Could not get the canonical path for " + this.getRepositoryHome().getAbsolutePath(), (Throwable)e);
        }
        TarJournal.debug("init " + this.repositoryHome);
        this.persistence = TarJournalPersistence.getInstance(this.repositoryHome);
        this.persistence.journal = this;
        if (this.maximumAge == null) {
            this.maximumAge = DEFAULT_MAX_AGE;
        }
        this.persistence.setMaximumAge(this.maximumAge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTarJournal() throws Exception {
        this.persistence = TarJournalPersistence.getInstance(this.repositoryHome);
        this.persistence.lock();
        try {
            LocalFileSystem fs = new LocalFileSystem();
            CRXPMContext context2 = new CRXPMContext(new File(this.repositoryHome, TAR_JOURNAL), (FileSystem)fs, new NodeId(0L, 0L), null, null, null, new RepositoryStatisticsImpl(), this.sharedHome, false, false, this.sharedNothing);
            TarPersistenceManager pm = new TarPersistenceManager();
            pm.setJournal(true);
            pm.setOutOfSyncRecoveryEnabled(this.outOfSyncRecoveryEnabled);
            pm.setPortList(this.portList);
            pm.setBindAddress(this.bindAddress);
            pm.setCluster(true);
            pm.setLocalPath(this.repositoryHome + "/" + TAR_JOURNAL);
            pm.setSharedPath(this.sharedPath + "/" + TAR_JOURNAL);
            pm.setMaximumAge(this.persistence.getMaximumAge());
            pm.setMaxFileSize(this.maxFileSize);
            pm.setIndexMaxBuffer("1");
            pm.init(context2);
            this.persistence.setTar(pm);
            this.persistence.removeWorkspace(TAR_JOURNAL);
            Object var5_4 = null;
            this.persistence.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.persistence.unlock();
            throw throwable;
        }
    }

    TarPersistenceManager getTar() throws JournalException {
        return this.getPersistence().getTar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TarJournalPersistence getPersistence() throws JournalException {
        TarJournalPersistence tarJournalPersistence = this.persistence;
        synchronized (tarJournalPersistence) {
            TarJournalPersistence p = this.persistence;
            if (p.getTar() != null) {
                return p;
            }
            try {
                this.initTarJournal();
            }
            catch (Exception e) {
                throw new JournalException("Init failed", (Throwable)e);
            }
            return this.persistence;
        }
    }

    private static void debug(String msg) {
        log.debug(msg);
    }

    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        this.lockTar();
        long tx = 0L;
        boolean needRollback = false;
        TarJournalPersistence p = this.getPersistence();
        try {
            try {
                IndexEntry entry;
                int l;
                String producer = record.getProducerId();
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DataOutputStream d = new DataOutputStream(bytes);
                d.writeUTF(this.getId());
                d.writeUTF(producer);
                d.flush();
                int blockSize = 4096;
                byte[] buff = new byte[blockSize];
                while (length > 0 && (l = in.read(buff, 0, Math.min(blockSize, length))) >= 0) {
                    bytes.write(buff, 0, l);
                    length -= l;
                }
                byte[] data = bytes.toByteArray();
                if (TarJournalPersistence.JOURNAL_TRANSACTIONS) {
                    tx = p.getCurrentTransaction(this.lastTransaction);
                    TarSetHandler tar = p.getTar().getTarSet();
                    tar.startTransaction(tx);
                    entry = p.getTar().append(JOURNAL, 0, data);
                    needRollback = true;
                    tar.appendCommit(tx);
                    p.endTransaction();
                    this.lastTransaction = tx;
                    needRollback = false;
                } else {
                    entry = this.getTar().append(JOURNAL, 0, data);
                }
                long revision = TarJournal.getRevision(entry.getFileId(), entry.getPos());
                record.setRevision(revision);
                TarJournal.debug("append " + revision + " len: " + data.length);
            }
            catch (Exception e) {
                if (needRollback) {
                    try {
                        p.getTar().getTarSet().appendRollback(tx);
                    }
                    catch (Exception e2) {
                        TarJournal.logAndConvert("Can not rollback", e2);
                    }
                }
                throw TarJournal.logAndConvert("Can not append", e);
            }
            Object var18_19 = null;
            this.unlockTar();
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            this.unlockTar();
            throw throwable;
        }
    }

    void lockTar() throws JournalException {
        IOException lastException = null;
        this.persistence.lock();
        for (int i = 0; i < 3; ++i) {
            try {
                this.getTar().lockExclusive();
                return;
            }
            catch (IOException e) {
                log.info("Lock failed: " + e.getMessage());
                log.debug("lockTar", (Throwable)e);
                this.getTar().reopenTarSet();
                lastException = e;
                continue;
            }
        }
        this.persistence.unlock();
        throw TarJournal.logAndConvert("Can not lock", lastException);
    }

    void unlockTar() {
        try {
            try {
                this.getTar().unlockExclusive();
            }
            catch (JournalException e) {
                log.warn("Can not unlock", (Throwable)e);
                throw new RuntimeException(e);
            }
            Object var3_1 = null;
            this.persistence.unlock();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.persistence.unlock();
            throw throwable;
        }
    }

    protected void doLock() throws JournalException {
        this.isLocked.set(true);
        this.lockTar();
    }

    protected void doUnlock(boolean successful) {
        this.isLocked.set(false);
        this.unlockTar();
    }

    protected boolean syncAgainOnNewRecords() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isLocked.get()) {
            log.info("Still locked while closing the journal, waiting");
            for (int i = 0; this.isLocked.get() && i < TarJournalPersistence.DELAY_JOURNAL_CLOSE_MAX_SECONDS; ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.isLocked.get()) {
                try {
                    log.warn("Forced journal persistence unlock");
                    this.persistence.unlockForce();
                    log.warn("Forced journal unlock");
                    ((ClusterTarSet)this.getTar().getTarSet()).unlock(true);
                }
                catch (Exception e) {
                    log.warn("Forced unlock failed", (Throwable)e);
                }
                log.info("Forced unlock complete");
            }
        }
        this.closed = true;
        TarJournal.debug("close");
        Map<Integer, TarFile> map = this.readOnlyTarFiles;
        synchronized (map) {
            for (TarFile tarFile : this.readOnlyTarFiles.values()) {
                tarFile.close();
            }
            this.readOnlyTarFiles.clear();
        }
        this.persistence.journal = null;
        this.persistence.close();
    }

    public InstanceRevision getInstanceRevision() throws JournalException {
        TarJournal.debug("getInstanceRevision");
        return new CRXFileRevision(new File(this.getRevision()), false, this.sharedNothing);
    }

    public RecordIterator getRecords() throws JournalException {
        return this.getRecords(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordIterator getRecords(long startRevision) throws JournalException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        TarJournal.debug("getRecords " + startRevision);
        this.persistence.lock();
        try {
            Iterator<TarFile> tarFileIterator;
            TarSetHandler set = this.getTar().getTarSet();
            set.sync(true);
            try {
                tarFileIterator = this.getDataFilesForReading(set);
            }
            catch (IOException e) {
                throw new JournalException("Unable to get list of tar files", (Throwable)e);
            }
            TarRecordIterator iter = new TarRecordIterator(tarFileIterator, TarJournal.getTarFileId(startRevision), TarJournal.getTarPosition(startRevision));
            if (startRevision != 0L || this.revisionZeroProcessed) {
                iter.fetchNext();
            }
            if (startRevision == 0L && iter.hasNext()) {
                this.revisionZeroProcessed = true;
            }
            TarRecordIterator tarRecordIterator = iter;
            Object var8_7 = null;
            this.persistence.unlock();
            return tarRecordIterator;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.persistence.unlock();
            throw throwable;
        }
    }

    public void setSharedPath(String sharedPath) {
        this.sharedPath = sharedPath;
    }

    public String getSharedPath() {
        return this.sharedPath;
    }

    public void setPreferredMaster(boolean preferredMaster) {
        this.preferredMaster = preferredMaster;
    }

    @Override
    public boolean isPreferredMaster() {
        return this.preferredMaster;
    }

    protected static JournalException logAndConvert(String message, Exception e) {
        log.error(message, (Throwable)e);
        return new JournalException(message, (Throwable)e);
    }

    protected static long getRevision(int tarFileId, long tarPosition) {
        if (tarFileId < 0 || (long)tarFileId >= 0x1000000L) {
            throw new IllegalArgumentException("tarFileId: " + tarFileId);
        }
        if (tarPosition < 0L || tarPosition >= 0x10000000000L) {
            throw new IllegalArgumentException("tarPosition: " + tarPosition);
        }
        return (long)tarFileId << 40 | tarPosition;
    }

    private static int getTarFileId(long revision) {
        return (int)(revision >>> 40);
    }

    private static int getTarPosition(long revision) {
        return (int)(revision & 0xFFFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<TarFile> getDataFilesForReading(TarSetHandler tarSet) throws IOException {
        ArrayList<TarFile> tarFilesToReturn = new ArrayList<TarFile>();
        try {
            List<TarFile> tarFiles = tarSet.getDataFiles();
            HashSet<Integer> tarFileIds = new HashSet<Integer>();
            for (TarFile tarFile : tarFiles) {
                int fileId = tarFile.getId();
                tarFileIds.add(fileId);
                if (!new File(tarFile.getFileName()).exists()) continue;
                Map<Integer, TarFile> map = this.readOnlyTarFiles;
                synchronized (map) {
                    TarFile readOnly;
                    if (this.readOnlyTarFiles.containsKey(fileId)) {
                        readOnly = this.readOnlyTarFiles.get(fileId);
                    } else {
                        readOnly = new TarFile(tarFile.getFileName(), tarFile.getId(), tarFile.getCompressed(), "r");
                        this.readOnlyTarFiles.put(fileId, readOnly);
                    }
                    tarFilesToReturn.add(readOnly);
                }
            }
            this.removeDeletedReadOnlyTarFiles(tarFileIds);
            return tarFilesToReturn.iterator();
        }
        catch (IOException e) {
            for (TarFile tarFile : tarFilesToReturn) {
                tarFile.close();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeletedReadOnlyTarFiles(Set<Integer> tarFileIds) {
        if (tarFileIds.isEmpty()) {
            return;
        }
        Map<Integer, TarFile> map = this.readOnlyTarFiles;
        synchronized (map) {
            Iterator<Map.Entry<Integer, TarFile>> iterator = this.readOnlyTarFiles.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, TarFile> entry = iterator.next();
                if (tarFileIds.contains(entry.getKey())) continue;
                entry.getValue().close();
                iterator.remove();
            }
        }
    }

    @Override
    public boolean isMaster() {
        try {
            return this.getTar().isMaster();
        }
        catch (JournalException e) {
            log.error("isMaster failed", (Throwable)e);
            return false;
        }
    }

    public void setMaximumAge(String maximumAge) {
        this.maximumAge = new Duration(maximumAge);
    }

    public String getPortList() {
        return this.portList;
    }

    public void setPortList(String portList) {
        this.portList = portList;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public String getSharedHome() {
        return this.sharedHome;
    }

    public void setSharedHome(String sharedHome) {
        this.sharedHome = sharedHome;
    }

    public void setSharedNothing(boolean sharedNothing) {
        this.sharedNothing = sharedNothing;
    }

    public boolean isSharedNothing() {
        return this.sharedNothing;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        if (maxFileSize != null) {
            TarUtils.parseIntSetting(maxFileSize, 1, 1024);
        }
        this.maxFileSize = maxFileSize;
    }

    public void setBecomeMasterOnTimeout(boolean becomeMasterOnTimeout) {
        this.becomeMasterOnTimeout = becomeMasterOnTimeout;
    }

    public boolean getBecomeMasterOnTimeout() {
        return this.becomeMasterOnTimeout;
    }

    public void setOutOfSyncRecoveryEnabled(boolean value) {
        this.outOfSyncRecoveryEnabled = value;
    }

    class TarJournalRecord
    extends AbstractRecord {
        private final TarFile file;
        private final long position;
        private final int length;
        private DataInputStream in;
        private String journalId;
        private String producerId;

        public TarJournalRecord(TarFile file, long position, int length) throws JournalException {
            super(TarJournal.this.getResolver(), TarJournal.this.getNamePathResolver());
            this.file = file;
            this.position = position;
            this.length = length;
            this.initRead();
        }

        public void cancelUpdate() {
        }

        public String getJournalId() {
            return this.journalId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initRead() throws JournalException {
            TarJournal.this.lockTar();
            try {
                this.initReadLocked();
                Object var2_1 = null;
                TarJournal.this.unlockTar();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                TarJournal.this.unlockTar();
                throw throwable;
            }
        }

        private void initReadLocked() throws JournalException {
            if (this.in != null) {
                return;
            }
            try {
                InputStream x = this.file.getInputStream(this.position, this.length);
                byte[] buff = new byte[this.length];
                TarFile.readFully(x, buff, this.length);
                this.in = new DataInputStream(new ByteArrayInputStream(buff));
                this.journalId = this.in.readUTF();
                this.producerId = this.in.readUTF();
            }
            catch (IOException e) {
                throw this.logAndConvert(e);
            }
        }

        private JournalException logAndConvert(IOException e) {
            return TarJournal.logAndConvert("Error reading entry " + this.file + " " + this.position, e);
        }

        public String getProducerId() {
            return this.producerId;
        }

        public long getRevision() {
            return TarJournal.getRevision(this.file.getId(), this.position);
        }

        public boolean readBoolean() throws JournalException {
            try {
                return this.in.readBoolean();
            }
            catch (IOException e) {
                throw this.logAndConvert(e);
            }
        }

        public byte readByte() throws JournalException {
            try {
                return this.in.readByte();
            }
            catch (IOException e) {
                throw this.logAndConvert(e);
            }
        }

        public char readChar() throws JournalException {
            try {
                return this.in.readChar();
            }
            catch (IOException e) {
                throw this.logAndConvert(e);
            }
        }

        public void readFully(byte[] b) throws JournalException {
            try {
                this.in.readFully(b);
            }
            catch (IOException e) {
                throw this.logAndConvert(e);
            }
        }

        public int readInt() throws JournalException {
            try {
                return this.in.readInt();
            }
            catch (IOException e) {
                throw this.logAndConvert(e);
            }
        }

        public long readLong() throws JournalException {
            try {
                return this.in.readLong();
            }
            catch (IOException e) {
                throw this.logAndConvert(e);
            }
        }

        public String readString() throws JournalException {
            try {
                boolean isNull = this.in.readBoolean();
                if (isNull) {
                    return null;
                }
                return this.in.readUTF();
            }
            catch (IOException e) {
                throw this.logAndConvert(e);
            }
        }

        public long update() throws JournalException {
            throw this.unsupported();
        }

        public void write(byte[] b) throws JournalException {
            throw this.unsupported();
        }

        public void writeBoolean(boolean b) throws JournalException {
            throw this.unsupported();
        }

        public void writeByte(int n) throws JournalException {
            throw this.unsupported();
        }

        public void writeChar(char c) throws JournalException {
            throw this.unsupported();
        }

        public void writeInt(int n) throws JournalException {
            throw this.unsupported();
        }

        public void writeLong(long n) throws JournalException {
            throw this.unsupported();
        }

        public void writeString(String s) throws JournalException {
            throw this.unsupported();
        }

        private JournalException unsupported() {
            String msg = "Writing to a read-only record is not supported.";
            return new JournalException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TarRecordIterator
    implements RecordIterator {
        long currentPosition;
        private int tarFile;
        private TarFile currentFile;
        private long currentLength;
        private Iterator<TarFile> fileIterator;
        private Iterator<Long> posLenIterator;

        public TarRecordIterator(Iterator<TarFile> fileIterator, int tarFile, int tarPosition) throws JournalException {
            this.fileIterator = fileIterator;
            this.tarFile = tarFile;
            this.currentPosition = tarPosition;
            this.fetchNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fetchNext() throws JournalException {
            TarJournal.this.persistence.lock();
            try {
                this.fetchNextLocked();
                Object var2_1 = null;
                TarJournal.this.persistence.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                TarJournal.this.persistence.unlock();
                throw throwable;
            }
        }

        private void fetchNextLocked() throws JournalException {
            while (true) {
                if (this.posLenIterator != null && this.posLenIterator.hasNext()) {
                    this.currentPosition = this.posLenIterator.next();
                    this.currentLength = this.posLenIterator.next();
                    break;
                }
                this.posLenIterator = null;
                this.currentFile = null;
                while (this.fileIterator.hasNext()) {
                    this.currentFile = this.fileIterator.next();
                    int id = this.currentFile.getId();
                    if (id < this.tarFile) {
                        this.currentFile = null;
                        continue;
                    }
                    if (id <= this.tarFile) break;
                    this.tarFile = id;
                    this.currentPosition = 0L;
                    break;
                }
                if (this.currentFile == null) break;
                final ArrayList list = new ArrayList();
                String fileName = this.currentFile.getFileName();
                try {
                    this.currentFile.scanIndex(this.currentPosition, new IndexEntryVisitor(){

                        public boolean getFailOnError() {
                            return false;
                        }

                        public boolean isStopped() {
                            return false;
                        }

                        public void visitEndOfFile(TarFile file) throws IOException {
                        }

                        public void visitEntry(TarFile file, IndexEntry entry) throws IOException {
                            TarRecordIterator.this.currentPosition = entry.getPos();
                            if (!entry.getUUID().equals((Object)JOURNAL)) {
                                return;
                            }
                            list.add(entry.getPos());
                            list.add(entry.getLength());
                        }

                        public void visitTransaction(TarFile file, String transactionName) {
                        }
                    }, true);
                }
                catch (IOException e) {
                    throw TarJournal.logAndConvert("Can not read file " + fileName, e);
                }
                if (list.size() == 0) {
                    this.currentFile = null;
                    continue;
                }
                this.posLenIterator = list.iterator();
            }
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.currentFile != null;
        }

        public Record nextRecord() throws NoSuchElementException, JournalException {
            TarJournalRecord rec = new TarJournalRecord(this.currentFile, this.currentPosition, (int)this.currentLength);
            this.fetchNext();
            return rec;
        }
    }
}

