/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.persistence.tar.TarPersistence;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManagerUtils {
    private static Logger log = LoggerFactory.getLogger(PersistenceManagerUtils.class);

    protected static void checkBundle(BundleBinding binding, InputStream in) throws ItemStateException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            try {
                binding.readBundle((InputStream)new TeeInputStream(in, (OutputStream)buffer), NodeId.randomId());
            }
            catch (IOException e) {
                throw new ItemStateException("Invalid bundle serialization: " + Arrays.toString(buffer.toByteArray()), (Throwable)e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            PersistenceManagerUtils.closeStream(in);
            throw throwable;
        }
        PersistenceManagerUtils.closeStream(in);
    }

    protected static void closeStream(InputStream ins) {
        if (ins != null) {
            try {
                ins.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static NodeReferences deserializeNodeReferences(NodeId id, InputStream in) throws NoSuchItemStateException, ItemStateException {
        NodeReferences nodeReferences;
        NodeReferences refs = new NodeReferences(id);
        try {
            try {
                Serializer.deserialize((NodeReferences)refs, (InputStream)in);
                nodeReferences = refs;
                Object var6_6 = null;
            }
            catch (NoSuchItemStateException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Failed to read node references: " + id + ": " + e;
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            PersistenceManagerUtils.closeStream(in);
            throw throwable;
        }
        PersistenceManagerUtils.closeStream(in);
        return nodeReferences;
    }

    public static NodePropBundle deserializeBundle(BundleBinding binding, NodeId id, InputStream in) throws ItemStateException {
        NodePropBundle nodePropBundle;
        try {
            CountingInputStream cin = new CountingInputStream(in);
            NodePropBundle bundle = binding.readBundle((InputStream)cin, id);
            bundle.setSize(cin.getByteCount());
            nodePropBundle = bundle;
            Object var7_8 = null;
        }
        catch (Exception e) {
            try {
                String msg = "Failed to read bundle: " + id + ": " + e;
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                PersistenceManagerUtils.closeStream(in);
                throw throwable;
            }
        }
        PersistenceManagerUtils.closeStream(in);
        return nodePropBundle;
    }

    protected static byte[] serializeBundle(BundleBinding binding, NodePropBundle bundle) throws ItemStateException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            binding.writeBundle((OutputStream)out, bundle);
            return out.toByteArray();
        }
        catch (Exception e) {
            String msg = "Failed to store bundle: " + bundle.getId() + ": " + e;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    public static void checkFixConsistency(TarPersistence pm, String workspaceDir, boolean check, boolean fix, String uuidList) {
        Set<String> set;
        if (check) {
            String[] uuids;
            boolean recursive = false;
            if (uuidList == null || uuidList.trim().length() == 0) {
                uuids = null;
            } else {
                if (uuidList.startsWith("recursive,")) {
                    recursive = true;
                    uuidList = uuidList.substring("recursive,".length());
                }
                uuids = uuidList.split(",");
            }
            pm.checkConsistency(uuids, recursive, fix);
        } else if (fix && (set = PersistenceManagerUtils.loadInconsistentBundleIds(workspaceDir)).size() > 0) {
            String[] uuids = set.toArray(new String[set.size()]);
            pm.checkConsistency(uuids, false, fix);
        }
    }

    public static void checkConsistency(TarPersistence pm, int total, String[] uuids, boolean recursive, boolean fix, boolean fixSystem) {
        int count = 0;
        ArrayList<NodePropBundle> modifications = new ArrayList<NodePropBundle>();
        if (uuids == null) {
            log.info("Checking workspace consistency of {}...", (Object)pm.toString());
            try {
                for (NodeId id : pm.getAllNodeIds(null, 0)) {
                    PersistenceManagerUtils.checkBundleConsistency(pm, id, fix, fixSystem, modifications);
                    if (++count % 1000 != 0) continue;
                    log.info(pm + ": Checked " + count + "/" + total + " bundles...");
                }
            }
            catch (Exception e) {
                log.error("Could not get the list of all nodes", (Throwable)e);
            }
        } else {
            ArrayList<NodeId> idList = new ArrayList<NodeId>(uuids.length);
            for (String uuid : uuids) {
                try {
                    idList.add(new NodeId(uuid.trim()));
                }
                catch (IllegalArgumentException e) {
                    log.error("Invalid uuid for consistency check, skipping: '" + uuid + "': " + e);
                }
            }
            total = idList.size();
            for (int i = 0; i < total; ++i) {
                NodeId id = (NodeId)idList.get(i);
                NodePropBundle bundle = PersistenceManagerUtils.checkBundleConsistency(pm, id, fix, fixSystem, modifications);
                if (recursive && bundle != null) {
                    for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                        idList.add(entry.getId());
                    }
                }
                if (++count % 1000 != 0) continue;
                log.info(pm + ": Checked " + count + "/" + total + " bundles...");
            }
        }
        log.info(pm + ": Checked " + count + "/" + total + " bundles.");
        if (fix) {
            PersistenceManagerUtils.fixConsistency(pm, modifications);
            PersistenceManagerUtils.storeInconsistentBundleIds(pm.getWorkspaceDir(), null);
        } else {
            String dir = pm.getWorkspaceDir();
            Set<String> map = PersistenceManagerUtils.loadInconsistentBundleIds(dir);
            for (NodePropBundle bundle : modifications) {
                map.add(bundle.getId().toString());
            }
            PersistenceManagerUtils.storeInconsistentBundleIds(dir, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeInconsistentBundleIds(String dir, Set<String> map) {
        File f = new File(dir, "inconsistentBundleIds.txt");
        if (map == null || map.size() == 0) {
            f.delete();
            return;
        }
        try {
            PrintWriter w = null;
            try {
                w = new PrintWriter(f);
                for (String s : new TreeSet<String>(map)) {
                    w.println(s);
                }
                Object var7_7 = null;
                w.close();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                w.close();
                throw throwable;
            }
        }
        catch (IOException e) {
            log.warn("Could not load " + f.getAbsolutePath(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> loadInconsistentBundleIds(String dir) {
        HashSet<String> mod = new HashSet<String>();
        File f = new File(dir, "inconsistentBundleIds.txt");
        try {
            if (!f.exists()) return mod;
            LineNumberReader r = null;
            try {
                String s;
                r = new LineNumberReader(new FileReader(f));
                while ((s = r.readLine()) != null) {
                    mod.add(s.trim());
                }
                Object var6_6 = null;
                if (r == null) return mod;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (r == null) throw throwable;
                r.close();
                throw throwable;
            }
            r.close();
            return mod;
        }
        catch (IOException e) {
            log.warn("Could not load " + f.getAbsolutePath(), (Throwable)e);
        }
        return mod;
    }

    public static NodePropBundle loadBundle(TarPersistence pm, NodeId id, boolean checkBeforeLoading) throws ItemStateException {
        InputStream in = pm.getInputStream(id, 0);
        if (in == null) {
            return null;
        }
        if (checkBeforeLoading) {
            PersistenceManagerUtils.checkBundle(pm.getBinding(), in);
            return PersistenceManagerUtils.loadBundle(pm, id, false);
        }
        return PersistenceManagerUtils.deserializeBundle(pm.getBinding(), id, in);
    }

    private static NodePropBundle checkBundleConsistency(TarPersistence pm, NodeId id, boolean fix, boolean fixSystem, Collection<NodePropBundle> modifications) {
        NodePropBundle bundle;
        try {
            bundle = PersistenceManagerUtils.loadBundle(pm, id, true);
            if (bundle == null) {
                log.error("No bundle found for id '" + id + "'");
                return null;
            }
        }
        catch (Exception e) {
            log.error("Error loading bundle " + id, (Throwable)e);
            return null;
        }
        ArrayList<NodePropBundle.ChildNodeEntry> missingChildren = new ArrayList<NodePropBundle.ChildNodeEntry>();
        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
            if (entry.getId().toString().toLowerCase().endsWith("babecafebabe")) continue;
            boolean isSystemNode = false;
            if (id.toString().toLowerCase().endsWith("babecafebabe")) {
                isSystemNode = true;
            }
            try {
                NodePropBundle child = PersistenceManagerUtils.loadBundle(pm, entry.getId(), true);
                if (child == null) {
                    log.error("NodeState " + id + " references inexistent child " + entry.getName() + " with id " + entry.getId());
                    if (isSystemNode) {
                        if (fixSystem) {
                            log.info("Automatically fixing system node " + id);
                            missingChildren.add(entry);
                            continue;
                        }
                        log.warn("The system node " + id + " is not fixed automatically. " + "Please fix manually, or enable consistencyFixSystem.");
                        continue;
                    }
                    missingChildren.add(entry);
                    continue;
                }
                if (isSystemNode) continue;
                NodeId cp = child.getParentId();
                if (cp == null) {
                    log.error("Child node " + child.getId() + " has invalid parent id: null (id: " + id + ")");
                    continue;
                }
                if (cp.equals((Object)id)) continue;
                log.error("Child node " + child.getId() + " has invalid parent id: " + cp + " (instead of " + id + ")");
            }
            catch (ItemStateException e) {}
        }
        if (!missingChildren.isEmpty()) {
            if (fix) {
                for (NodePropBundle.ChildNodeEntry entry : missingChildren) {
                    bundle.getChildNodeEntries().remove(entry);
                }
            }
            modifications.add(bundle);
        }
        NodeId parentId = bundle.getParentId();
        try {
            if (parentId != null && !id.toString().endsWith("babecafebabe") && !pm.exists(parentId)) {
                log.warn("NodeState '" + id + "' references inexistent parent id '" + parentId + "' (may be orphaned)");
                modifications.add(bundle);
            }
        }
        catch (ItemStateException e) {
            log.error("Error reading node '" + parentId + "' (parent of '" + id + "'): " + (Object)((Object)e));
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixConsistency(TarPersistence pm, Collection<NodePropBundle> modifications) {
        boolean locked = false;
        try {
            try {
                pm.lockExclusive();
                locked = true;
                PersistenceManagerUtils.doFixConsistency(pm, modifications);
            }
            catch (IOException e) {
                log.error("Failed to fix consistency", (Throwable)e);
                Object var5_4 = null;
                if (locked) {
                    pm.unlockExclusive();
                }
            }
            Object var5_3 = null;
            if (locked) {
                pm.unlockExclusive();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (locked) {
                pm.unlockExclusive();
            }
            throw throwable;
        }
    }

    private static void doFixConsistency(TarPersistence pm, Collection<NodePropBundle> modifications) {
        if (!modifications.isEmpty()) {
            log.info(pm + ": Fixing " + modifications.size() + " inconsistent bundle(s)...");
            for (NodePropBundle bundle : modifications) {
                pm.waitForBackup();
                try {
                    log.info(pm + ": Fixing bundle '" + bundle.getId() + "'");
                    bundle.markOld();
                    pm.storeBundle(bundle);
                    pm.evictBundle(bundle.getId());
                }
                catch (ItemStateException e) {
                    log.error(pm + ": Error storing fixed bundle: " + (Object)((Object)e));
                }
            }
        }
    }
}

