/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.file.TarFile;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizeFile {
    private static Logger log = LoggerFactory.getLogger(OptimizeFile.class);
    public static final String OPTIMIZE_TAR = "optimize.tar";
    public static final String OPTIMIZE_NOW_TAR = "optimizeNow.tar";
    private String directory;
    private long optimizeLastCheck;
    private boolean optimizeLastResult;
    private final TarSet tarset;

    OptimizeFile(String directory, TarSet tarset) {
        this.directory = directory;
        this.tarset = tarset;
    }

    public boolean getOptimizeNow() {
        long now = System.currentTimeMillis();
        if (now < this.optimizeLastCheck + 1000L) {
            this.optimizeLastResult = this.optimizeLastResult && this.tarset.needOptimize();
        } else {
            this.optimizeLastResult = this.getOptimizeNowUncached();
            this.optimizeLastCheck = now;
        }
        return this.optimizeLastResult;
    }

    private boolean getOptimizeNowUncached() {
        File optimize;
        File optimizeNow = new File(this.directory + "/" + OPTIMIZE_NOW_TAR);
        if (optimizeNow.exists()) {
            if (this.tarset.needOptimize()) {
                return true;
            }
            this.logIfNotJournal("Deleting " + optimizeNow.getAbsolutePath());
            optimizeNow.delete();
        }
        if ((optimize = new File(this.directory + "/" + OPTIMIZE_TAR)).exists()) {
            try {
                this.logIfNotJournal("Renaming " + optimize.getAbsolutePath() + " to " + optimizeNow.getAbsolutePath());
                TarUtils.renameWithRetry(optimize, optimizeNow);
            }
            catch (IOException e) {
                log.warn("Could not rename " + optimize.getAbsolutePath() + " to " + optimizeNow.getAbsolutePath());
            }
            this.tarset.readIndex();
            for (TarFile file : this.tarset.getDataFiles()) {
                file.setNeedToOptimize(true);
            }
            return true;
        }
        return false;
    }

    public void setOptimizeNowEnd() {
        File file = new File(this.directory + "/" + OPTIMIZE_TAR);
        file.delete();
        file = new File(this.directory + "/" + OPTIMIZE_NOW_TAR);
        file.delete();
    }

    private void logIfNotJournal(String message) {
        if (!this.tarset.getConfig().isJournal()) {
            log.info(message);
        }
    }
}

