/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexEntryVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Optimize
implements IndexEntryVisitor {
    private static Logger log = LoggerFactory.getLogger(Optimize.class);
    private final TarSet read;
    private final TarSetHandler write;

    Optimize(TarSet read, TarSetHandler write) {
        this.read = read;
        this.write = write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long optimizeBlocks(int count) throws IOException {
        long l;
        this.write.lockShared();
        try {
            TarSetHandler tarSetHandler = this.write;
            synchronized (tarSetHandler) {
                if (this.write.getTransaction() != 0L) {
                    long l2 = -1L;
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 15] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.write.unlockShared();
                    return l2;
                }
            }
        }
        catch (Throwable throwable) {
            this.write.unlockShared();
            throw throwable;
        }
        {
            this.write.readExternalChanges();
            List<TarFile> list = this.write.getDataFiles();
            if (list.size() == 1) {
                int minSize = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.OptimizeOneMinSize", 0);
                if (list.get(0).getFileLength() > (long)(minSize * 1024)) {
                    this.write.switchDataFile(this.write.getCompressFiles());
                }
                list = this.write.getDataFiles();
            }
            if (list.size() == 1) {
                long minSize = -1L;
                // MONITOREXIT @DISABLED, blocks:[6, 11] lbl23 : MonitorExitStatement: MONITOREXIT : var2_2
                this.write.unlockShared();
                return minSize;
            }
            TarFile file = this.findTarFileToOptimize(list);
            if (file == null) {
                long l3 = -1L;
                // MONITOREXIT @DISABLED, blocks:[6, 10] lbl29 : MonitorExitStatement: MONITOREXIT : var2_2
                this.write.unlockShared();
                return l3;
            }
            long optimizationStartTime = System.currentTimeMillis();
            long optimizedBytes = 0L;
            long nextPos = file.getOptimizePos();
            for (int i = 0; nextPos >= 0L && i < count; ++i) {
                long currentPos = nextPos;
                if ((nextPos = file.scanIndex(nextPos, this, false)) < 0L) {
                    optimizedBytes += file.getFileLength() - currentPos;
                    continue;
                }
                optimizedBytes += nextPos - currentPos;
            }
            if (nextPos < 0L) {
                if (this.write.canDelete()) {
                    file.setNeedToOptimize(false);
                    this.write.deleteDataFile(file.getId());
                }
            } else {
                file.setOptimizePos(nextPos);
            }
            long optimizationDuration = System.currentTimeMillis() - optimizationStartTime;
            this.logOptimizationStatistics(optimizedBytes, optimizationDuration);
            l = optimizedBytes;
        }
        this.write.unlockShared();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeAllFiles(boolean compress, int maxCount) throws IOException {
        long optimizationStartTime = System.currentTimeMillis();
        long optimizedBytes = 0L;
        List<TarFile> list = this.write.getDataFiles();
        this.write.lockShared();
        try {
            this.write.switchDataFile(compress);
            int len = Math.min(maxCount, list.size() - 1);
            for (int i = 0; i < len; ++i) {
                TarFile file = list.get(i);
                optimizedBytes += file.getFileLength();
                log.debug("Scanning: " + file.toString() + " " + i + " of " + len);
                file.scanIndex(0L, this, true);
                file.setNeedToOptimize(false);
                this.write.deleteDataFile(file.getId());
            }
            long optimizationDuration = System.currentTimeMillis() - optimizationStartTime;
            this.logOptimizationStatistics(optimizedBytes, optimizationDuration);
        }
        finally {
            this.write.unlockShared();
        }
    }

    private void logOptimizationStatistics(long optimizedBytes, long optimizationDuration) {
        if (optimizedBytes < 1000L || optimizationDuration < 50L) {
            return;
        }
        float blockTime = (float)(optimizationDuration * 1024L * 1024L) / (float)optimizedBytes;
        String message = "Optimize of " + optimizedBytes + " bytes took " + optimizationDuration + " msec." + " -> " + blockTime + " msec / MB";
        if (blockTime < 100.0f) {
            log.debug(message);
        } else if (blockTime < 1000.0f) {
            log.info(message);
        } else {
            log.warn(message);
        }
    }

    @Override
    public void visitEntry(TarFile file, IndexEntry entry) throws IOException {
        if (entry.getLength() == 0L) {
            return;
        }
        IndexEntry last = this.read.getIndexEntry(entry.getUUID(), entry.getType());
        if (last != null && last.getFileId() == file.getId()) {
            if (OptimizeThread.BUG_34668) {
                byte[] data = this.read.readData(entry.getUUID(), entry.getType());
                if (data != null) {
                    this.write.append(entry.getUUID(), entry.getType(), data);
                }
            } else {
                int len = (int)last.getLength();
                InputStream in = this.read.getInputStream(last);
                byte[] data = new byte[len];
                TarFile.readFully(in, data, len);
                this.write.append(entry.getUUID(), entry.getType(), data);
            }
        }
    }

    @Override
    public void visitEndOfFile(TarFile file) throws IOException {
    }

    @Override
    public void visitTransaction(TarFile file, String transactionName) {
    }

    @Override
    public boolean getFailOnError() {
        return false;
    }

    @Override
    public boolean isStopped() {
        return false;
    }

    void close() throws IOException {
        log.info("Writing index...");
        this.write.unlockShared();
        this.write.close();
        Optimize.waitUntilDeleted();
        this.read.close();
    }

    static void waitUntilDeleted() {
        log.info("Waiting until old files are deleted...");
        try {
            Thread.sleep((OptimizeThread.getInstance().getDeleteDelay() + 10) * 2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private TarFile findTarFileToOptimize(List<TarFile> list) throws IOException {
        for (int i = 0; i < list.size() - 1; ++i) {
            TarFile f = list.get(i);
            if (f.getFileLength() != 0L && !f.getNeedToOptimize()) continue;
            return f;
        }
        return null;
    }
}

