/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.core.backup.LowDiskSpaceMonitor;
import com.day.crx.core.cluster.ClusterController;
import com.day.crx.core.cluster.ClusterLifecycleListener;
import com.day.crx.core.cluster.ClusterNodeInfo;
import com.day.crx.core.cluster.ClusterSkeleton;
import com.day.crx.core.cluster.IncomingCall;
import com.day.crx.core.cluster.OutgoingCall;
import com.day.crx.core.journal.Duration;
import com.day.crx.persistence.tar.AppendEvent;
import com.day.crx.persistence.tar.AppendEventBuffer;
import com.day.crx.persistence.tar.ClusterOutOfSyncException;
import com.day.crx.persistence.tar.Optimize;
import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.ReentrantLockWithInfo;
import com.day.crx.persistence.tar.TarJournalPersistence;
import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.TarSetConfig;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.TarSetOutOfSyncRecovery;
import com.day.crx.persistence.tar.TarSetStatistics;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexSet;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.util.RepositoryLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterTarSet
implements TarSetHandler,
ClusterSkeleton,
ClusterLifecycleListener,
Closeable {
    static Logger log = LoggerFactory.getLogger(ClusterTarSet.class);
    private static final int WAIT_FOR_MASTER = Integer.getInteger("com.day.crx.persistence.tar.WaitForMaster", 60000);
    private static final boolean BROADCAST = Boolean.parseBoolean(System.getProperty("com.day.crx.persistence.tar.BroadcastChanges", "false"));
    private static final boolean USE_EVENTS = Boolean.parseBoolean(System.getProperty("com.day.crx.persistence.tar.UseEvents", "false"));
    private static final boolean USE_TAR_SCAN = Boolean.parseBoolean(System.getProperty("com.day.crx.persistence.tar.UseTarScan", "true"));
    private static final int OP_LOCK = 1;
    private static final int OP_UNLOCK = 2;
    private static final int OP_APPEND = 3;
    private static final int OP_APPEND_COMMIT = 4;
    private static final int OP_APPEND_ROLLBACK = 5;
    private static final int OP_VERIFY = 6;
    private static final int OP_VERSION_CHECK = 7;
    private static final int OP_READ_FILE = 8;
    private static final int OP_CLOSING_TIME = 9;
    private static final int OP_CLOSED = 10;
    private static final int VERSION_MAJOR = 1;
    private static final int VERSION_MINOR = 1;
    private static final int MAX_SEGMENT_LENGTH = 131072;
    private long lastTransaction;
    private long currentTransaction;
    private boolean compressFiles;
    private boolean logEverything;
    private long startTime;
    private int maxFileSize;
    private int optimizeCount = 1;
    private double optimizeSleep;
    private int mergeIndexWhenClosing = 500;
    private TarSetConfig config = new TarSetConfig();
    private long syncNext;
    private String lockClass = RepositoryLock.class.getName();
    private final String repositoryHome;
    private final String workspaceName;
    private ClusterController controller;
    private String fileMode;
    private TarSet copy = new TarSet();
    private int lockTimeout;
    private String localPath;
    private TarSetStatistics tarSetStatistics;
    private final ReentrantLockWithInfo lock = new ReentrantLockWithInfo();
    private AtomicInteger lockSharedCount = new AtomicInteger();
    private final Object lockSync = new Object();
    private final Object openSync = new Object();
    private String lockedBySlave;
    private volatile boolean isMaster;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private ClusterTarSet journalTarSet;
    private final TarJournalPersistence tarJournalPersistence;
    private AppendEventBuffer eventBuffer = new AppendEventBuffer();
    private volatile boolean opening;
    private int minVersionMajor = 1;
    private int minVersionMinor = 1;
    private Set<String> synchronizedSlaves = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean delayWritesFlag = new AtomicBoolean(false);
    private TarSetOutOfSyncRecovery outOfSyncRecovery;
    private final boolean journal;

    public ClusterTarSet(String repositoryHome, String workspaceName, boolean journal) {
        this.repositoryHome = repositoryHome;
        this.tarJournalPersistence = TarJournalPersistence.getInstance(repositoryHome);
        this.workspaceName = workspaceName;
        this.lock.setName(workspaceName);
        this.journal = journal;
        int rank = journal ? 20 : 10;
        LowDiskSpaceMonitor.getInstance().register(this, rank);
    }

    public String toString() {
        return this.repositoryHome + " " + this.workspaceName;
    }

    @Override
    public IndexEntry append(NodeId id, int type, byte[] data) throws IOException {
        return this.append(id, type, data, System.currentTimeMillis());
    }

    @Override
    public IndexEntry append(NodeId id, int type, byte[] data, long time) throws IOException {
        return this.append(id, type, data, time, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexEntry append(NodeId id, int type, byte[] data, long time, String exclude) throws IOException {
        this.checkLockShared();
        this.lock();
        try {
            if (this.send(exclude)) {
                this.appendSend(this.currentTransaction, id, type, data, time, exclude);
            }
            IndexEntry e = this.copy.append(id, type, data, time);
            if (USE_EVENTS) {
                AppendEvent.Pos pos = new AppendEvent.Pos(e.getFileId(), e.getPos());
                AppendEvent event = AppendEvent.append(pos, this.currentTransaction, id, type, data, time);
                this.eventBuffer.append(event);
            }
            IndexEntry indexEntry = e;
            Object var11_9 = null;
            this.unlock();
            return indexEntry;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.unlock();
            throw throwable;
        }
    }

    private boolean send(String exclude) {
        return this.isMaster && BROADCAST || !this.isMaster && exclude == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendSend(long tx, NodeId id, int type, byte[] data, long time, String exclude) throws IOException {
        this.debug("appendSend");
        OutgoingCall call = this.callOrBroadcast(3, exclude);
        try {
            DataOutput out = call.getOutput();
            this.sendAppendPos(out);
            out.writeLong(tx);
            out.writeUTF(id.toString());
            out.writeInt(type);
            out.writeLong(time);
            out.writeLong(data.length);
            out.write(data);
            call.execute();
            Object var12_9 = null;
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            call.release();
            throw throwable;
        }
        call.release();
    }

    private void sendAppendPos(DataOutput out) throws IOException {
        TarFile last = this.copy.getLastDataFile();
        out.writeInt(last.getId());
        out.writeLong(last.getAppendPos());
    }

    private boolean matchAppendPos(DataInput in) throws IOException {
        int id = in.readInt();
        long pos = in.readLong();
        TarFile last = this.copy.getLastDataFile();
        long lastId = last.getId();
        long lastPos = last.getAppendPos();
        if (lastId == (long)id && lastPos == pos) {
            return true;
        }
        if (this.isMaster) {
            throw new IOException("Position mismatch, my position " + lastId + "/" + lastPos + " <> slave " + id + "/" + pos);
        }
        return false;
    }

    private void appendProcess(IncomingCall call) throws IOException {
        this.debug("appendProcess");
        DataInput in = call.getInput();
        if (this.lockCheck(call)) {
            boolean match = this.matchAppendPos(in);
            long tx = in.readLong();
            String uuid = in.readUTF();
            int type = in.readInt();
            long time = in.readLong();
            long length = in.readLong();
            byte[] data = new byte[(int)length];
            in.readFully(data);
            if (match) {
                this.setTransaction(tx);
                this.append(new NodeId(uuid), type, data, time, call.getCallerId());
            }
            this.unlockSlave();
        }
        call.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockCheck(IncomingCall call) throws IOException {
        if (this.isMaster) {
            String caller = call.getCallerId();
            Object object = this.lockSync;
            synchronized (object) {
                if (!caller.equals(this.lockedBySlave)) {
                    throw new IOException("Locked by " + this.lockedBySlave + " and not " + caller);
                }
            }
            return true;
        }
        return this.lock.tryLock();
    }

    private void unlockSlave() {
        if (!this.isMaster) {
            this.lock.unlock();
        }
    }

    @Override
    public void appendCommit(long tx) throws IOException {
        this.appendCommit(tx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendCommit(long tx, String exclude) throws IOException {
        this.checkLockShared();
        this.lock();
        try {
            if (this.send(exclude)) {
                this.appendCommitSend(tx, exclude);
            }
            TarFile f = this.copy.getLastDataFile();
            if (USE_EVENTS) {
                AppendEvent.Pos pos = new AppendEvent.Pos(f.getId(), f.getAppendPos());
                AppendEvent event = AppendEvent.commit(pos, tx);
                event.apply(this.copy);
                this.eventBuffer.append(event);
            } else {
                this.copy.appendCommit(tx);
            }
            this.currentTransaction = 0L;
            Object var8_6 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendCommitSend(long tx, String exclude) throws IOException {
        this.debug("appendCommitSend");
        OutgoingCall call = this.callOrBroadcast(4, exclude);
        try {
            DataOutput out = call.getOutput();
            this.sendAppendPos(out);
            out.writeLong(tx);
            call.execute();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            call.release();
            throw throwable;
        }
        call.release();
    }

    private void appendCommitProcess(IncomingCall call) throws IOException {
        this.debug("appendCommitProcess");
        DataInput in = call.getInput();
        if (this.lockCheck(call)) {
            boolean match = this.matchAppendPos(in);
            long tx = in.readLong();
            if (match) {
                this.appendCommit(tx, call.getCallerId());
            }
            this.unlockSlave();
        }
        call.ok();
    }

    @Override
    public void appendRollback(long tx) throws IOException {
        this.appendRollback(tx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendRollback(long tx, String exclude) throws IOException {
        this.checkLockShared();
        this.lock();
        try {
            if (this.send(exclude)) {
                this.appendRollbackSend(tx, exclude);
            }
            TarFile f = this.copy.getLastDataFile();
            if (USE_EVENTS) {
                AppendEvent.Pos pos = new AppendEvent.Pos(f.getId(), f.getAppendPos());
                AppendEvent event = AppendEvent.rollback(pos, tx);
                event.apply(this.copy);
                this.eventBuffer.append(event);
            } else {
                this.copy.appendRollback(tx);
            }
            this.currentTransaction = 0L;
            Object var8_6 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendRollbackSend(long tx, String exclude) throws IOException {
        this.debug("appendRollbackSend " + tx);
        OutgoingCall call = this.callOrBroadcast(5, exclude);
        try {
            DataOutput out = call.getOutput();
            this.sendAppendPos(out);
            out.writeLong(tx);
            call.execute();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            call.release();
            throw throwable;
        }
        call.release();
    }

    private void appendRollbackProcess(IncomingCall call) throws IOException {
        this.debug("appendRollbackProcess");
        DataInput in = call.getInput();
        if (this.lockCheck(call)) {
            boolean match = this.matchAppendPos(in);
            long tx = in.readLong();
            if (match) {
                this.appendRollback(tx, call.getCallerId());
            }
            this.unlockSlave();
        }
        call.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void versionCheckSend() throws IOException {
        int minor;
        int major;
        block9: {
            OutgoingCall call;
            this.debug("versionCheckSend");
            long start = System.currentTimeMillis();
            while (true) {
                Object var10_7;
                call = null;
                try {
                    try {
                        call = this.call(7);
                        DataOutput out = call.getOutput();
                        out.writeInt(1);
                        out.writeInt(1);
                        DataInput in = call.getInput();
                        major = in.readInt();
                        minor = in.readInt();
                        var10_7 = null;
                        if (call != null) {
                            break;
                        }
                        break block9;
                    }
                    catch (IOException e) {
                        long time = System.currentTimeMillis() - start;
                        if (time > (long)WAIT_FOR_MASTER) {
                            throw e;
                        }
                        var10_7 = null;
                        if (call == null) continue;
                        call.release();
                    }
                }
                catch (Throwable throwable) {
                    var10_7 = null;
                    if (call != null) {
                        call.release();
                    }
                    throw throwable;
                }
            }
            call.release();
        }
        if (major > 1) {
            throw new IOException("Version mismatch - got " + major + "." + minor + " expected " + 1 + "." + 1);
        }
    }

    private void versionCheckProcess(IncomingCall call) throws IOException {
        this.debug("versionCheckProcess");
        DataInput in = call.getInput();
        int major = in.readInt();
        int minor = in.readInt();
        DataOutput out = call.getOutput();
        out.writeInt(1);
        out.writeInt(1);
        if (major > 1) {
            String msg = "Version mismatch - got " + major + "." + minor + " expected " + 1 + "." + 1;
            throw new IOException(msg);
        }
        if (major <= this.minVersionMajor) {
            this.minVersionMajor = Math.min(this.minVersionMajor, major);
            this.minVersionMinor = Math.min(this.minVersionMinor, minor);
        }
    }

    @Override
    public boolean canDelete() {
        TarUtils.check(this.isMaster, "Only the master may delete");
        boolean result = this.copy.canDelete();
        log.debug("canDelete: " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        log.info("close " + this.repositoryHome + " " + this.workspaceName);
        if (this.isMaster) {
            this.setOptimizeNowEnd();
        }
        OptimizeThread.getInstance().removeTarSet(this);
        if (this.isMaster) {
            this.waitForSlavesToSynchronize();
        }
        this.lock();
        try {
            if (this.controller != null) {
                this.controller.unregister(this.workspaceName);
                this.controller = null;
            }
            if (!this.closed.getAndSet(true)) {
                this.copy = TarUtils.closeSilently(this.copy);
                this.lockTimeout = 1;
            }
            Object var2_1 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
        LowDiskSpaceMonitor.getInstance().unregister(this);
    }

    private void waitForSlavesToSynchronize() throws IOException {
        Set<String> remaining = this.getConnectedSlaves();
        if (remaining.size() == 0) {
            return;
        }
        int numSlaves = remaining.size();
        long time = System.currentTimeMillis();
        this.synchronizedSlaves.clear();
        long waitAtMost = this.minVersionMinor > 0 ? 600L : 50L;
        log.info("Closing; waiting for slaves to sync for at most " + waitAtMost * 100L + " ms");
        int i = 0;
        while ((long)i < waitAtMost) {
            if (this.minVersionMinor > 0) {
                OutgoingCall call = this.callOrBroadcast(9, null);
                call.execute();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            remaining = this.getConnectedSlaves();
            remaining.removeAll(this.synchronizedSlaves);
            if (remaining.size() == 0) break;
            if (i > 20 && i % 100 == 0) {
                log.info("Waiting for slaves: " + remaining);
            }
            ++i;
        }
        if (remaining.size() != 0) {
            log.warn("The following slaves didn't synchronize; stopping anyway: " + remaining);
            Map<Thread, StackTraceElement[]> m = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> e : m.entrySet()) {
                log.info(e.getKey().toString());
                for (StackTraceElement s : e.getValue()) {
                    log.info("  " + s);
                }
            }
        } else {
            time = System.currentTimeMillis() - time;
            StringBuilder msg = new StringBuilder();
            msg.append(numSlaves).append(" ");
            if (numSlaves > 1) {
                msg.append("slaves");
            } else {
                msg.append("slave");
            }
            msg.append(" synchronized in ");
            msg.append(String.format("%.1f", (double)time / 1000.0));
            msg.append(" seconds.");
            log.info(msg.toString());
        }
    }

    private Set<String> getConnectedSlaves() {
        HashSet<String> slaves = new HashSet<String>();
        for (ClusterNodeInfo s : this.controller.getSlaveInfos()) {
            if (s.getId().equals(this.controller.getClusterNodeId())) continue;
            slaves.add(s.getId());
        }
        return slaves;
    }

    @Override
    public void deleteDataFile(int id) throws IOException {
        TarUtils.check(this.isMaster, "Only the master may delete data files");
        log.debug("deleteDataFile: " + id);
        if (this.isMaster) {
            this.copy.deleteDataFile(id);
        }
    }

    @Override
    public Optimize createOptimizer() {
        if (!this.isMaster) {
            return null;
        }
        return new Optimize(this.copy, this);
    }

    @Override
    public void setOptimizeNowEnd() {
        log.debug("setOptimizeNowEnd");
        this.copy.setOptimizeNowEnd();
    }

    @Override
    public List<TarFile> getDataFiles() {
        if (this.copy == null) {
            return Collections.emptyList();
        }
        return this.copy.getDataFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(NodeId id, int type) throws IOException {
        this.lock();
        try {
            boolean bl = this.copy.exists(id, type);
            Object var5_4 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean getCompressFiles() {
        return this.compressFiles;
    }

    @Override
    public void setConfig(TarSetConfig config) {
        this.config = config;
        this.copy.setConfig(config);
        if (config.isOutOfSyncRecoveryEnabled() && this.outOfSyncRecovery == null) {
            this.outOfSyncRecovery = new TarSetOutOfSyncRecovery(this);
        }
    }

    @Override
    public TarSetConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexSet getIndex() throws IOException {
        this.lock();
        try {
            IndexSet indexSet = this.copy != null ? this.copy.getIndex() : null;
            Object var3_2 = null;
            this.unlock();
            return indexSet;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexEntry getIndexEntry(NodeId id, int type) throws IOException {
        this.lock();
        try {
            IndexEntry indexEntry = this.copy.getIndexEntry(id, type);
            Object var5_4 = null;
            this.unlock();
            return indexEntry;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(NodeId id, int type) throws IOException {
        this.lock();
        try {
            InputStream inputStream = this.copy != null ? this.copy.getInputStream(id, type) : null;
            Object var5_4 = null;
            this.unlock();
            return inputStream;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean getLogEverything() {
        return this.logEverything;
    }

    @Override
    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    @Override
    public boolean getOptimizeWhenIdle() {
        return false;
    }

    @Override
    public TarFile getLastDataFile() {
        return this.copy.getLastDataFile();
    }

    @Override
    public long getLastTouch() {
        if (this.copy == null) {
            return 0L;
        }
        return this.copy.getLastTouch();
    }

    @Override
    public long getLastTransaction() {
        if (this.isMaster) {
            return this.copy.getLastTransaction();
        }
        return Math.max(this.lastTransaction, this.copy.getLastTransaction());
    }

    @Override
    public String getLocalPath() {
        return this.localPath;
    }

    @Override
    public int getOptimizeCount() {
        return this.optimizeCount;
    }

    @Override
    public void setOptimizeCount(int optimizeCount) {
        this.optimizeCount = optimizeCount;
    }

    @Override
    public double getOptimizeSleep() {
        return this.optimizeSleep;
    }

    @Override
    public void setOptimizeSleep(double optimizeSleep) {
        this.optimizeSleep = optimizeSleep;
    }

    @Override
    public String getLockClass() {
        return this.lockClass;
    }

    @Override
    public void setLockClass(String lockClass) {
        this.lockClass = lockClass;
        this.copy.setLockClass(lockClass);
    }

    @Override
    public int getMergeIndexWhenClosing() {
        return this.mergeIndexWhenClosing;
    }

    @Override
    public void setMergeIndexWhenClosing(int mergeIndexWhenClosing) {
        this.mergeIndexWhenClosing = mergeIndexWhenClosing;
        this.copy.setMergeIndexWhenClosing(mergeIndexWhenClosing);
    }

    @Override
    public boolean getOptimizeNow() {
        if (this.isMaster && this.copy != null) {
            return this.copy.getOptimizeNow();
        }
        return false;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    @Override
    public TarSetStatistics getTarSetStatistics() {
        return this.tarSetStatistics;
    }

    @Override
    public void setTarSetStatistics(TarSetStatistics value) {
        this.tarSetStatistics = value;
    }

    @Override
    public void kill() {
        if (!this.closed.getAndSet(true)) {
            OptimizeThread.getInstance().removeTarSet(this);
            if (this.controller != null) {
                this.controller.unregister(this.workspaceName);
                this.controller = null;
            }
            this.isMaster = false;
            this.copy.kill();
            this.copy = null;
            this.lockTimeout = 1;
        }
    }

    private ClusterTarSet getJournalTarSet() throws IOException {
        ClusterTarSet j;
        if (this.journal) {
            return null;
        }
        if (this.journalTarSet == null && this.tarJournalPersistence.journal != null) {
            try {
                this.journalTarSet = (ClusterTarSet)this.tarJournalPersistence.journal.getTar().getTarSet();
            }
            catch (JournalException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        if ((j = this.journalTarSet) != null && (j == this || j.isClosed())) {
            j = null;
            this.journalTarSet = null;
        }
        return j;
    }

    @Override
    public void lockShared() throws IOException {
        this.lockShared(true);
    }

    @Override
    public void lockShared(boolean write) throws IOException {
        this.lockShared(write, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockShared(boolean write, boolean verify) throws IOException {
        ClusterTarSet journalTarSet = this.getJournalTarSet();
        if (journalTarSet != null) {
            journalTarSet.lockShared(write);
        }
        if (write && this.journal && !this.lock.isHeldByCurrentThread()) {
            this.delayWritesIfNecessary();
        }
        this.lock();
        boolean success = false;
        try {
            if (!this.closed.get()) {
                if (this.lockSharedCount.get() > 0) {
                    if (this.lockSharedCount.get() > 20) {
                        throw new IOException("Internal error: shared lock count=" + this.lockSharedCount);
                    }
                } else if (!this.isMaster) {
                    this.lastTransaction = this.lockSend(verify);
                }
                this.lockSharedCount.incrementAndGet();
                success = true;
            }
            Object var6_5 = null;
            if (!success) {
                this.unlock();
                if (journalTarSet != null) {
                    journalTarSet.unlockShared();
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!success) {
                this.unlock();
                if (journalTarSet != null) {
                    journalTarSet.unlockShared();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(String sharedPath, String localPath, boolean cluster, int lockTimeout, String fileMode) throws IOException {
        this.localPath = localPath;
        this.lockTimeout = lockTimeout;
        this.fileMode = fileMode;
        IOException lastException = null;
        this.controller = ClusterController.getInstance(new File(this.repositoryHome));
        if (!this.controller.isStarted()) {
            this.controller.start();
        }
        Object object = this.openSync;
        synchronized (object) {
            log.debug("register controller {}", (Object)this.workspaceName);
            this.controller.register(this.workspaceName, this);
            for (int i = 0; i < 3; ++i) {
                lastException = null;
                try {
                    this.copy.setOptimize(false);
                    this.isMaster = this.controller.isMaster();
                    if (this.isMaster) {
                        this.reopenCopy();
                        this.closed.set(false);
                        break;
                    }
                    this.opening = true;
                    try {
                        this.versionCheckSend();
                        this.copy.setAutoSwitch(false);
                        this.reopenCopy();
                        this.closed.set(false);
                        this.lockShared(false, true);
                        this.unlockShared();
                        Object var10_11 = null;
                        this.opening = false;
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        this.opening = false;
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    log.warn("Could not open", (Throwable)e);
                    this.copy.close(false);
                    this.closed.set(true);
                    lastException = e;
                    continue;
                }
            }
        }
        if (lastException != null) {
            this.close();
            throw lastException;
        }
        OptimizeThread.getInstance().addTarSet(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternalChanges() throws IOException {
        if (!this.isMaster) {
            this.lock();
            try {
                try {
                    this.lastTransaction = this.lockSend(false);
                    this.unlockSend();
                }
                catch (Exception e) {
                    log.info("Reading external changes failed: " + e.getMessage());
                    log.debug("readExternalChanges", (Throwable)e);
                    Object var3_2 = null;
                    this.unlock();
                }
                Object var3_1 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.unlock();
                throw throwable;
            }
        }
    }

    private void debug(String s) {
        if (log.isDebugEnabled()) {
            log.debug(this.workspaceName + " " + (this.isMaster ? "(master)" : "(slave)") + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long lockSend(boolean verify) throws IOException {
        int first;
        long lastDataFileLength;
        int lastDataFileId;
        block25: {
            this.debug("lockSend");
            TarFile lastDataFile = this.copy.getLastDataFile();
            if (lastDataFile == null) {
                String msg = "Last data file not available, closed? " + this.copy.toString();
                IOException e = new IOException(msg);
                log.warn(msg, (Throwable)e);
                throw e;
            }
            lastDataFileId = lastDataFile.getId();
            lastDataFileLength = lastDataFile.getFileLength();
            first = 0;
            OutgoingCall call = this.call(1);
            ArrayList<FileSegment> fileSegments = new ArrayList<FileSegment>();
            try {
                DataOutput out = call.getOutput();
                out.writeInt(lastDataFileId);
                out.writeLong(lastDataFileLength);
                out.writeLong(lastDataFile.getAppendPos());
                this.debug(" fileId: " + lastDataFile.getId() + " pos: " + lastDataFile.getAppendPos());
                DataInput in = call.getInput();
                while (true) {
                    String name;
                    if ((name = in.readUTF()).length() == 0) {
                        first = in.readInt();
                        this.debug("  first: " + first);
                        long lastTransaction = in.readLong();
                        this.debug("  last transaction: " + lastTransaction);
                        Object var16_18 = null;
                        break;
                    }
                    if ("event".equals(name)) {
                        AppendEvent event = AppendEvent.read(in);
                        event.apply(this.copy);
                        this.eventBuffer.append(event);
                        continue;
                    }
                    FileSegment segment = new FileSegment();
                    segment.fileName = name;
                    segment.fileId = in.readInt();
                    segment.pos = in.readLong();
                    segment.length = in.readLong();
                    this.debug("  write file: " + name + " pos: " + segment.pos + " length: " + segment.length);
                    if (segment.length < 0L) continue;
                    fileSegments.add(segment);
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                call.release();
                throw throwable;
            }
            call.release();
            if (fileSegments.size() > 0) {
                block24: {
                    if (!USE_TAR_SCAN) {
                        this.copy.close(false);
                    }
                    try {
                        while (fileSegments.size() > 0) {
                            FileSegment segment = (FileSegment)fileSegments.get(0);
                            if (USE_TAR_SCAN) {
                                this.readFileSegmentSendWhileOpen(segment);
                            } else {
                                this.readFileSegmentSend(segment);
                            }
                            fileSegments.remove(0);
                        }
                        Object var18_22 = null;
                        if (!USE_TAR_SCAN) break block24;
                    }
                    catch (Throwable throwable) {
                        Object var18_23 = null;
                        if (USE_TAR_SCAN) {
                            this.copy.scanIndexAfterAppend();
                            throw throwable;
                        }
                        this.reopenCopy();
                        throw throwable;
                    }
                    this.copy.scanIndexAfterAppend();
                    break block25;
                }
                this.reopenCopy();
            }
        }
        if (verify) {
            try {
                this.verifySend(lastDataFileId, lastDataFileLength);
            }
            catch (IOException e) {
                this.unlockSend();
                throw e;
            }
        }
        List<TarFile> list = this.copy.getDataFiles();
        Iterator<TarFile> i$ = list.iterator();
        while (true) {
            boolean delete;
            if (!i$.hasNext()) {
                if (first <= lastDataFileId) return this.lastTransaction;
                log.info("All tar file are new: re-creating index*.tar files");
                String dir = this.copy.getIndex().getDirectory();
                this.copy.close(true);
                IndexSet.deleteAll(dir);
                this.reopenCopy();
                return this.lastTransaction;
            }
            TarFile file = i$.next();
            if (file.getId() >= first || !this.copy.canDelete()) continue;
            Calendar earliestDelete = Calendar.getInstance();
            earliestDelete.setTimeInMillis(file.getLastModified());
            Duration maxAge = this.copy.getConfig().getMaximumAge();
            if (maxAge == null) {
                delete = true;
            } else {
                maxAge.addTo(earliestDelete);
                long earliest = earliestDelete.getTimeInMillis();
                if (earliest > Calendar.getInstance().getTimeInMillis()) {
                    this.debug("  don't delete yet: " + (Calendar.getInstance().getTimeInMillis() - earliest) + " " + file.getFileName());
                    delete = false;
                } else {
                    delete = true;
                }
            }
            if (!delete) continue;
            this.copy.deleteDataFile(file.getId());
        }
    }

    private boolean lockProcess(IncomingCall call) throws IOException {
        DataOutput out;
        this.debug("lockProcess");
        this.lockShared();
        DataInput in = call.getInput();
        int fileId = in.readInt();
        long fileLength = in.readLong();
        long appendPos = in.readLong();
        AppendEvent.Pos pos = new AppendEvent.Pos(fileId, appendPos);
        Iterator<AppendEvent> it = this.eventBuffer.getEvents(pos);
        if (it != null) {
            out = call.getOutput();
            while (it.hasNext()) {
                out.writeUTF("event");
                it.next().write(out);
            }
            out.writeUTF("");
        } else {
            ArrayList<TarFile> files = new ArrayList<TarFile>();
            this.debug(" fileId: " + fileId + " fileLength: " + fileLength + " appendPos: " + appendPos);
            TarFile last = this.copy.getLastDataFile();
            if (last.getId() == fileId) {
                files.add(last);
            } else {
                List<TarFile> all = this.copy.getDataFiles();
                for (TarFile f : all) {
                    if (f.getId() < fileId) continue;
                    files.add(f);
                }
                if (files.size() == 0 && all.size() > 0) {
                    this.unlockShared();
                    call.error("This cluster node and the master are out of sync. Operation stopped.\nCluster node data is newer than the master.\nPlease ensure the repository is configured correctly.\nTo continue anyway, please delete the index and data tar files on this cluster node and restart.\nPlease note the Lucene index may still be out of sync unless it is also deleted.\nRepository home: " + this.repositoryHome + ", workspace: " + this.workspaceName + ",\n" + "last file on master: " + last.toString() + ",\n" + "last data file in this cluster node: " + fileId + " (length: " + fileLength + ", append position: " + appendPos + "),\n" + "file list: " + TarSet.formatList(all));
                    return false;
                }
            }
            out = call.getOutput();
            for (TarFile f : files) {
                long p = 0L;
                long length = f.getFileLength();
                if (f.getId() < fileId) continue;
                if (f.getId() == fileId) {
                    if (length == fileLength) continue;
                    p = appendPos;
                }
                String name = new File(f.getFileName()).getName();
                out.writeUTF(name);
                out.writeInt(f.getId());
                out.writeLong(p);
                out.writeLong(length - p);
                this.debug("  lock process " + name + " " + p + " " + (length - p));
            }
        }
        int first = this.copy.getLastDataFile().getId();
        List<TarFile> list = this.copy.getDataFiles();
        for (TarFile file : list) {
            if (file.getId() >= first) continue;
            first = file.getId();
        }
        out.writeUTF("");
        this.debug("  send first: " + first);
        out.writeInt(first);
        this.debug("  send last transaction: " + this.copy.getLastTransaction());
        out.writeLong(this.copy.getLastTransaction());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileSegmentSend(FileSegment segment) throws IOException {
        RandomAccessFile ra = this.openCopyFile(segment.fileName, "rw");
        try {
            long pos = segment.pos;
            long totalRemaining = segment.length;
            while (totalRemaining > 0L) {
                Object var15_12;
                this.debug("readFileSend");
                ra.seek(pos);
                OutgoingCall call = this.call(8);
                byte[] buffer = new byte[4096];
                try {
                    DataOutput out = call.getOutput();
                    int len = (int)Math.min(131072L, totalRemaining);
                    this.debug("  read file: " + segment.fileName + " pos: " + pos + " length: " + len + " remaining: " + totalRemaining);
                    out.writeInt(segment.fileId);
                    out.writeLong(pos);
                    out.writeLong(len);
                    DataInput in = call.getInput();
                    if (in.readBoolean()) {
                        int l;
                        for (int remaining = len; remaining > 0; remaining -= l) {
                            l = Math.min(remaining, buffer.length);
                            in.readFully(buffer, 0, l);
                            ra.write(buffer, 0, l);
                        }
                        pos += (long)len;
                        totalRemaining -= (long)len;
                    }
                    var15_12 = null;
                }
                catch (Throwable throwable) {
                    var15_12 = null;
                    call.release();
                    throw throwable;
                }
                call.release();
                {
                }
            }
            Object var17_14 = null;
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            ra.close();
            throw throwable;
        }
        ra.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileSegmentSendWhileOpen(FileSegment segment) throws IOException {
        TarFile f = this.copy.getLastDataFile();
        while (segment.fileId > f.getId()) {
            this.copy.scanIndexAfterAppend();
            this.copy.switchDataFile(f.getId() + 1, f.getCompressed());
            f = this.copy.getLastDataFile();
        }
        long pos = segment.pos;
        long totalRemaining = segment.length;
        while (totalRemaining > 0L) {
            Object var15_12;
            this.debug("readFileSend");
            if (f.getAppendPos() != pos) {
                throw new IOException("Position does not match: " + f.getAppendPos() + " " + pos);
            }
            OutgoingCall call = this.call(8);
            byte[] buffer = new byte[32768];
            try {
                DataOutput out = call.getOutput();
                int len = (int)Math.min(131072L, totalRemaining);
                this.debug("  read file: " + segment.fileName + " pos: " + pos + " length: " + len + " remaining: " + totalRemaining);
                out.writeInt(segment.fileId);
                out.writeLong(pos);
                out.writeLong(len);
                DataInput in = call.getInput();
                if (in.readBoolean()) {
                    int l;
                    for (int remaining = len; remaining > 0; remaining -= l) {
                        l = Math.min(remaining, buffer.length);
                        in.readFully(buffer, 0, l);
                        this.copy.appendRawBytes(buffer, 0, l);
                    }
                    pos += (long)len;
                    totalRemaining -= (long)len;
                }
                var15_12 = null;
            }
            catch (Throwable throwable) {
                var15_12 = null;
                call.release();
                throw throwable;
            }
            call.release();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileSegmentProcess(IncomingCall call) throws IOException {
        this.debug("readFileProcess");
        DataInput in = call.getInput();
        int fileId = in.readInt();
        long pos = in.readLong();
        long length = in.readLong();
        this.debug(" fileId: " + fileId + " pos: " + pos + " length: " + length);
        TarFile file = this.copy.getDataFile(fileId);
        String fileName = file.getFileName();
        DataOutput out = call.getOutput();
        if (!new File(fileName).exists()) {
            out.writeBoolean(false);
        }
        out.writeBoolean(true);
        RandomAccessFile ra = new RandomAccessFile(fileName, "r");
        try {
            ra.seek(pos);
            long end = pos + length;
            byte[] buffer = new byte[4096];
            while (pos < end) {
                int l = (int)Math.min(end - pos, (long)buffer.length);
                ra.readFully(buffer, 0, l);
                out.write(buffer, 0, l);
                pos += (long)l;
            }
            Object var17_13 = null;
        }
        catch (Throwable throwable) {
            Object var17_14 = null;
            ra.close();
            throw throwable;
        }
        ra.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySend(int fileId, long fileLength) throws IOException {
        this.debug("verifySend");
        OutgoingCall call = this.call(6);
        try {
            String name;
            DataOutput out = call.getOutput();
            out.writeInt(fileId);
            out.writeLong(fileLength);
            this.debug(" fileId: " + fileId + " length: " + fileLength);
            DataInput in = call.getInput();
            ClusterOutOfSyncException e = null;
            byte[] buffer = new byte[4096];
            while (!(name = in.readUTF()).equals("")) {
                long pos = in.readLong();
                long length = in.readLong();
                if (this.outOfSyncRecovery != null) {
                    this.outOfSyncRecovery.readAndSaveTransactionIds(in);
                }
                this.debug("  verify data file: " + name + " pos: " + pos + " length: " + length);
                byte[] compareBuffer = new byte[buffer.length];
                RandomAccessFile ra = this.openCopyFile(name, "r");
                ra.seek(pos);
                while (length > 0L) {
                    int l = (int)Math.min(length, (long)buffer.length);
                    in.readFully(buffer, 0, l);
                    ra.readFully(compareBuffer, 0, l);
                    for (int i = 0; i < l; ++i) {
                        if (buffer[i] == compareBuffer[i]) continue;
                        e = new ClusterOutOfSyncException("This cluster node and the master are out of sync. Operation stopped.\nPlease ensure the repository is configured correctly.\nTo continue anyway, please delete the index and data tar files on this cluster node and restart.\nPlease note the Lucene index may still be out of sync unless it is also deleted.\nRepository home: " + this.repositoryHome + ", workspace: " + this.workspaceName + ",\n" + "file name: " + name + ", position:" + ((long)i + pos) + ", expected: " + buffer[i] + ", got: " + compareBuffer[i] + ",\n" + "last data file in cluster node: " + fileId);
                        e.setJournal(this.journal);
                        if (this.outOfSyncRecovery == null) break;
                        this.outOfSyncRecovery.handleOutOfSyncException(e, this.workspaceName, name);
                        break;
                    }
                    length -= (long)l;
                    pos += (long)l;
                }
                ra.close();
            }
            if (e != null) {
                throw e;
            }
            Object var19_15 = null;
        }
        catch (Throwable throwable) {
            Object var19_16 = null;
            call.release();
            throw throwable;
        }
        call.release();
    }

    private void verifyProcess(IncomingCall call) throws IOException {
        this.debug("verifyProcess");
        DataInput in = call.getInput();
        int fileId = in.readInt();
        long fileLength = in.readLong();
        this.debug(" fileId: " + fileId + " fileLength: " + fileLength);
        int maxClusterVerify = OptimizeThread.MAX_CLUSTER_VERIFY;
        DataOutput out = call.getOutput();
        if (maxClusterVerify != 0) {
            List<TarFile> files = this.copy.getDataFiles();
            byte[] buffer = new byte[4096];
            for (TarFile f : files) {
                if (f.getId() != fileId) continue;
                String name = new File(f.getFileName()).getName();
                RandomAccessFile ra = new RandomAccessFile(f.getFileName(), "r");
                long end = Math.min(ra.length(), fileLength);
                long pos = Math.max(0L, end - (long)maxClusterVerify);
                long length = end - pos;
                this.debug("  send write " + name + " " + pos + " " + length);
                out.writeUTF(name);
                out.writeLong(pos);
                out.writeLong(length);
                if (this.outOfSyncRecovery != null) {
                    this.outOfSyncRecovery.writeTransactionIds(out);
                }
                ra.seek(pos);
                while (pos < end) {
                    int l = (int)Math.min(end - pos, (long)buffer.length);
                    ra.readFully(buffer, 0, l);
                    out.write(buffer, 0, l);
                    pos += (long)l;
                }
                ra.close();
            }
        }
        out.writeUTF("");
    }

    private RandomAccessFile openCopyFile(String name, String mode) throws FileNotFoundException {
        File f = new File(this.localPath);
        f.mkdirs();
        return new RandomAccessFile(new File(f, name), mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockSend() throws IOException {
        this.debug("unlockSend");
        OutgoingCall call = this.call(2);
        try {
            call.getOutput().writeInt(0);
            call.execute();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            call.release();
            throw throwable;
        }
        call.release();
    }

    private void unlockProcess(IncomingCall call) throws IOException {
        this.debug("unlockProcess");
        int x = call.getInput().readInt();
        this.debug(" x=" + x);
        this.lockCheck(call);
        this.unlockShared();
        call.ok();
    }

    private OutgoingCall call(int op) throws IOException {
        return this.controller.newCall(this.workspaceName, op);
    }

    private void executeBroadcast(int op) {
        try {
            OutgoingCall call = this.controller.broadcast(this.workspaceName, op);
            call.execute();
        }
        catch (IOException e) {
            log.warn("Cannot broadcast " + op, (Throwable)e);
        }
    }

    private OutgoingCall callOrBroadcast(int op, String exclude) throws IOException {
        if (this.isMaster) {
            if (exclude == null) {
                return this.controller.broadcast(this.workspaceName, op);
            }
            Set<String> ex = Collections.singleton(exclude);
            return this.controller.broadcast(this.workspaceName, op, ex);
        }
        return this.controller.newCall(this.workspaceName, op);
    }

    @Override
    public void setCompressFiles(boolean compressFiles) {
        this.compressFiles = compressFiles;
        this.copy.setCompressFiles(compressFiles);
    }

    @Override
    public void setFailOnError(boolean failOnError) {
        this.copy.setFailOnError(failOnError);
    }

    @Override
    public void setLogEverything(boolean logEverything) {
        this.logEverything = logEverything;
        this.copy.setLogEverything(logEverything);
    }

    @Override
    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        this.copy.setMaxFileSize(maxFileSize);
    }

    @Override
    public void setOptimize(boolean b) {
    }

    @Override
    public void setScanFileId(int scanFileId) {
    }

    @Override
    public void setScanPos(long scanPos) {
    }

    @Override
    public void setUseIndex(boolean b) {
    }

    @Override
    public void setOptimizeWhenIdle(boolean optimizeWhenIdle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransaction(long tx) throws IOException {
        this.lock();
        try {
            this.copy.setTransaction(tx);
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public void startTransaction(long tx) throws IOException {
        this.currentTransaction = tx;
        this.copy.startTransaction(tx);
    }

    @Override
    public long getTransaction() {
        return this.copy.getTransaction();
    }

    private void reopenCopy() throws IOException {
        this.startTime();
        TarSet newCopy = new TarSet();
        newCopy.setCompressFiles(this.copy.getCompressFiles());
        newCopy.setOptimizeWhenIdle(this.copy.getOptimizeWhenIdle());
        newCopy.setLogEverything(this.copy.getLogEverything());
        newCopy.setFailOnError(this.copy.getFailOnError());
        newCopy.setMaxFileSize(this.copy.getMaxFileSize());
        newCopy.setOptimizeSleep(this.copy.getOptimizeSleep());
        newCopy.setAutoSwitch(this.copy.getAutoSwitch());
        newCopy.setLockClass(this.copy.getLockClass());
        newCopy.setConfig(this.config);
        newCopy.setOptimize(false);
        newCopy.setMergeIndexWhenClosing(this.copy.getMergeIndexWhenClosing());
        newCopy.open(this.localPath, this.localPath, false, this.lockTimeout, this.fileMode);
        this.copy = newCopy;
        this.eventBuffer.clear();
        this.stopTime("reopenCopy");
    }

    private void startTime() {
        this.startTime = System.currentTimeMillis();
    }

    private void stopTime(String task) {
        long time = System.currentTimeMillis() - this.startTime;
        log.debug("time:" + task + " " + time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchDataFile(boolean compress) throws IOException {
        TarUtils.check(this.isMaster, "Only the master may switch data files");
        this.lock();
        try {
            if (this.isMaster) {
                this.copy.switchDataFile(compress);
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sync(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now < this.syncNext) {
            return false;
        }
        this.syncNext = now + (long)OptimizeThread.getInstance().getSyncDelay();
        try {
            ClusterTarSet journalTarSet = this.getJournalTarSet();
            ReentrantLockWithInfo journalLock = null;
            if (journalTarSet != null && !(journalLock = journalTarSet.lock).tryLock(1000L)) {
                return false;
            }
            try {
                if (this.lock.tryLock(1000L)) {
                    try {
                        if (!this.closed.get() && !this.isMaster) {
                            this.lockShared(false);
                            this.unlockShared();
                        }
                        Object var7_9 = null;
                        this.lock.unlock();
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        this.lock.unlock();
                        throw throwable;
                    }
                }
                Object var9_12 = null;
                if (journalLock != null) {
                    journalLock.unlock();
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (journalLock != null) {
                    journalLock.unlock();
                }
                throw throwable;
            }
            return true;
        }
        catch (IllegalMonitorStateException e) {
            log.warn("sync failed", (Throwable)e);
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touch() {
        try {
            this.lock();
            try {
                Object object = this.lockSync;
                synchronized (object) {
                    if (!this.closed.get() && this.copy != null) {
                        this.copy.touch();
                    }
                }
                Object var4_4 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.unlock();
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void unlockShared() {
        this.unlockShared(false);
    }

    private void unlockShared(boolean force) {
        if (!this.lock.isHeldByCurrentThread() && !force) {
            log.warn("Lock not held by current thread", (Throwable)new Exception());
            return;
        }
        if (this.lockSharedCount.decrementAndGet() < 1) {
            if (this.lockSharedCount.get() < 0) {
                log.warn("Lock count: " + this.lockSharedCount);
                this.lockSharedCount.set(0);
            }
            if (!this.isMaster) {
                try {
                    if (this.controller != null) {
                        this.unlockSend();
                    }
                }
                catch (Exception e) {
                    log.warn("Could not unlock", (Throwable)e);
                }
            }
        }
        if (force) {
            this.lockSharedCount.set(0);
        }
        this.unlock(force);
        if (this.journalTarSet != null) {
            this.journalTarSet.unlockShared(force);
        }
    }

    private void lock() throws IOException {
        try {
            if (this.lockTimeout == 0) {
                this.lock.lock();
            } else if (!this.lock.tryLock(this.lockTimeout)) {
                throw new IOException("Lock timeout");
            }
        }
        catch (InterruptedException e) {
            IOException e2 = new IOException("Lock timeout");
            e2.initCause(e);
            throw e2;
        }
    }

    private void unlock() {
        this.unlock(false);
    }

    void unlock(boolean force) {
        if (force) {
            this.lock.unlockForce();
        } else {
            try {
                this.lock.unlock();
            }
            catch (IllegalMonitorStateException e) {
                log.warn("Not locked by this thread", (Throwable)e);
            }
        }
    }

    private void checkLockShared() {
        if (!this.isMaster && BROADCAST) {
            return;
        }
        TarUtils.check(this.lockSharedCount.get() > 0, "Shared data not locked: " + this.lockSharedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(IncomingCall call) throws IOException {
        if (this.opening) {
            String msg = "Still opening, rejecting request";
            IOException e = new IOException();
            log.error(msg, (Throwable)e);
            throw e;
        }
        Object msg = this.openSync;
        synchronized (msg) {
            if (this.closed.get()) {
                this.unlockIfRequired();
                String msg2 = "Already closed";
                IOException e = new IOException(msg2);
                log.error(msg2, (Throwable)e);
                throw e;
            }
        }
        if (call.getOperation() == 9) {
            this.delayWrites();
            return;
        }
        if (call.getOperation() == 10) {
            this.undelayWrites();
            return;
        }
        if (!this.isMaster && !BROADCAST) {
            msg = "Not master";
            IOException e = new IOException((String)msg);
            log.error((String)msg, (Throwable)e);
            throw e;
        }
        try {
            switch (call.getOperation()) {
                case 6: {
                    this.verifyProcess(call);
                    break;
                }
                case 1: {
                    boolean success = this.lockProcess(call);
                    if (success) {
                        Object e = this.lockSync;
                        synchronized (e) {
                            if (this.lockedBySlave != null) {
                                if (this.lockedBySlave.equals(call.getCallerId())) {
                                    this.unlockShared();
                                } else {
                                    throw new IOException("Locked by two slaves: " + this.lockedBySlave + " + " + call.getCallerId() + " " + this.repositoryHome);
                                }
                            }
                            this.lockedBySlave = call.getCallerId();
                            this.synchronizedSlaves.add(this.lockedBySlave);
                        }
                    }
                    break;
                }
                case 2: {
                    Object e = this.lockSync;
                    synchronized (e) {
                        this.unlockProcess(call);
                        this.lockedBySlave = null;
                        break;
                    }
                }
                case 3: {
                    this.synchronizedSlaves.clear();
                    this.appendProcess(call);
                    break;
                }
                case 4: {
                    this.synchronizedSlaves.clear();
                    this.appendCommitProcess(call);
                    break;
                }
                case 5: {
                    this.synchronizedSlaves.clear();
                    this.appendRollbackProcess(call);
                    break;
                }
                case 7: {
                    this.versionCheckProcess(call);
                    break;
                }
                case 8: {
                    this.readFileSegmentProcess(call);
                    break;
                }
                default: {
                    IOException e = new IOException("Unsupported operation: " + call.getOperation());
                    log.warn("Unexpected error", (Throwable)e);
                    throw e;
                }
            }
        }
        catch (Exception e) {
            String msg3 = "Unexpected exception " + e.getMessage();
            log.warn(msg3);
            IOException io = new IOException(msg3);
            io.initCause(e);
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockIfRequired() {
        Object object = this.lockSync;
        synchronized (object) {
            if (this.lockedBySlave != null) {
                this.unlockShared();
                this.lockedBySlave = null;
            }
        }
    }

    @Override
    public void activate() {
        this.isMaster = true;
        log.info("activate " + this.repositoryHome + " " + this.workspaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        Object object = this.lockSync;
        synchronized (object) {
            this.unlockIfRequired();
            log.info("deactivate while " + (this.isMaster ? "master" : "slave") + " " + this.repositoryHome + " " + this.workspaceName);
            if (this.isMaster) {
                this.executeBroadcast(10);
            }
            this.isMaster = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void slaveDisconnected(String slaveId) {
        Object object = this.lockSync;
        synchronized (object) {
            if (slaveId.equals(this.lockedBySlave)) {
                this.unlockShared(true);
                this.lockedBySlave = null;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public long[] findTransactionStart(long transaction, boolean previous) throws IOException {
        return this.copy.findTransactionStart(transaction, previous);
    }

    @Override
    public void truncate(int fileId, long pos) throws IOException {
        this.copy.truncate(fileId, pos);
        this.copy.close();
        this.reopenCopy();
    }

    private void delayWritesIfNecessary() throws IOException {
        this.tarJournalPersistence.delayWritesIfNecessary(this);
    }

    private void delayWrites() {
        int i = 0;
        while (true) {
            log.info("Try to synchronize " + this);
            if (this.sync(true)) break;
            log.warn("Could not synchronize");
            if (i > 10) {
                log.warn("Could not synchronize 10 times");
                break;
            }
            ++i;
        }
        if (!this.delayWritesFlag.getAndSet(true)) {
            this.tarJournalPersistence.delayWritesBegin(this);
        }
    }

    private void undelayWrites() {
        if (this.delayWritesFlag.getAndSet(false)) {
            this.tarJournalPersistence.delayWritesEnd(this);
        }
    }

    static class FileSegment {
        String fileName;
        int fileId;
        long pos;
        long length;

        FileSegment() {
        }
    }
}

