/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.jdbc;

import com.day.crx.persistence.bundle.BundleDbPersistenceManager;
import com.day.io.RegionFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDbPersistenceManager
extends com.day.crx.persistence.bundle.BundleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(BundleDbPersistenceManager.class);
    private int blobFSBlockSize = 0;

    public String getBlobFSBlockSize() {
        return String.valueOf(this.blobFSBlockSize);
    }

    public void setBlobFSBlockSize(String size) {
        this.blobFSBlockSize = Integer.decode(size);
        if (this.blobFSBlockSize > 0) {
            log.error("CQFS support is no longer available since CRX 2.0: blobFSBlockSize " + size + " > 0");
        }
    }

    public String getBlobFSInitialCacheSize() {
        return "N/A";
    }

    public void setBlobFSInitialCacheSize(String size) {
        log.error("CQFS support is no longer available since CRX 2.0: blobFSInitialCacheSize " + size);
    }

    public String getBlobFSMaximumCacheSize() {
        return "N/A";
    }

    public void setBlobFSMaximumCacheSize(String size) {
        log.error("CQFS support is no longer available since CRX 2.0: blobFSMaximumCacheSize " + size);
    }

    public boolean isBlobFSLogIOCalls() {
        return false;
    }

    public void setBlobFSLogIOCalls(String blobFSLogIOCalls) {
        log.error("CQFS support is no longer available since CRX 2.0: blobFSLogIOCalls " + blobFSLogIOCalls);
    }

    public boolean isBlobFSLogSYSCalls() {
        return false;
    }

    public void setBlobFSLogSYSCalls(String blobFSLogSYSCalls) {
        log.error("CQFS support is no longer available since CRX 2.0: blobFSLogSYSCalls " + blobFSLogSYSCalls);
    }

    public boolean isBlobFSLogBufferCache() {
        return false;
    }

    public void setBlobFSLogBufferCache(String blobFSLogBufferCache) {
        log.error("CQFS support is no longer available since CRX 2.0: blobFSLogBufferCache " + blobFSLogBufferCache);
    }

    protected BundleDbPersistenceManager.CloseableBLOBStore createBlobStore() throws Exception {
        if (this.blobFSBlockSize >= 0) {
            return this.createLocalFSBlobStore(this.context);
        }
        return this.createDBBlobStore(this.context);
    }

    protected BundleDbPersistenceManager.CloseableBLOBStore createLocalFSBlobStore(PMContext context) throws Exception {
        CRXLocalFileSystem blobFS = new CRXLocalFileSystem();
        blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
        blobFS.init();
        return new BundleDbPersistenceManager.FSBlobStore((FileSystem)blobFS);
    }

    private static class CRXLocalFileSystem
    extends LocalFileSystem {
        private File root;

        private CRXLocalFileSystem() {
        }

        public void setRoot(File root) {
            super.setRoot(root);
            this.root = root;
        }

        public void close() throws FileSystemException {
            super.close();
            this.root = null;
        }

        private String osPath(String genericPath) {
            if (File.separator.equals("/")) {
                return genericPath;
            }
            return genericPath.replace('/', File.separatorChar);
        }

        public InputStream getInputStream(String filePath) throws FileSystemException {
            File f = new File(this.root, this.osPath(filePath));
            try {
                return new RegionFileInputStream(f);
            }
            catch (IOException fnfe) {
                String msg = f.getPath() + " does not denote an existing file";
                log.debug(msg);
                throw new FileSystemException(msg, (Throwable)fnfe);
            }
        }
    }
}

