/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence;

import com.day.crx.persistence.NativePersistenceManager;
import com.day.crx.persistence.bundle.DbNameIndex;
import com.day.crx.persistence.bundle.NGKDbNameIndex;
import com.day.crx.persistence.jdbc.BundleDbPersistenceManager;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OraclePersistenceManager
extends BundleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(NativePersistenceManager.class);
    public static final String TABLE_SPACE_VARIABLE = "${tableSpace}";
    protected String tableSpace;

    public OraclePersistenceManager() {
        this.setBlobFSBlockSize("-1");
        this.setExternalBLOBs(false);
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace != null ? tableSpace.trim() : null;
    }

    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("oracle.jdbc.OracleDriver");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:oracle:thin:@localhost:1521:xe");
        }
        if (this.getUser() == null) {
            this.setUser("crx");
        }
        if (this.getPassword() == null) {
            this.setPassword("crx");
        }
        if (this.getSchema() == null) {
            this.setSchema("oracle");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix(context.getHomeDir().getName() + "_");
        }
        super.init(context);
        try {
            DatabaseMetaData metaData = this.connectionManager.getConnection().getMetaData();
            if (metaData.getDriverMajorVersion() < 10) {
                log.warn("Unsupported driver version detected: " + metaData.getDriverName() + " v" + metaData.getDriverVersion());
            }
        }
        catch (SQLException e) {
            log.warn("Can not retrieve driver version", (Throwable)e);
        }
    }

    protected DbNameIndex createDbNameIndex() throws SQLException {
        return new NGKDbNameIndex(this.connectionManager, this.schemaObjectPrefix);
    }

    protected boolean checkTablesWithUser() {
        return true;
    }

    protected String createSchemaSQL(String sql) {
        sql = Text.replace((String)sql, (String)"${schemaObjectPrefix}", (String)this.schemaObjectPrefix).trim();
        String tspace = this.tableSpace == null || "".equals(this.tableSpace) ? "" : "tablespace " + this.tableSpace;
        return Text.replace((String)sql, (String)TABLE_SPACE_VARIABLE, (String)tspace).trim();
    }

    protected void prepareSchemaObjectPrefix() throws Exception {
        DatabaseMetaData metaData = this.connectionManager.getConnection().getMetaData();
        String legalChars = metaData.getExtraNameCharacters();
        legalChars = legalChars + "ABCDEFGHIJKLMNOPQRSTUVWXZY0123456789_";
        String prefix = this.schemaObjectPrefix.toUpperCase();
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (legalChars.indexOf(c) == -1) {
                escaped.append('_');
                continue;
            }
            escaped.append(c);
        }
        this.schemaObjectPrefix = escaped.toString();
    }
}

