/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence;

import com.day.crx.persistence.OraclePersistenceManager;
import com.day.crx.persistence.bundle.BundleDbPersistenceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleLegacyPersistenceManager
extends OraclePersistenceManager {
    private static Logger log = LoggerFactory.getLogger(OracleLegacyPersistenceManager.class);
    private Class blobClass;
    private Integer durationSessionConstant;
    private Integer modeReadWriteConstant;

    public void init(PMContext context) throws Exception {
        super.init(context);
        this.blobClass = this.connectionManager.getConnection().getClass().getClassLoader().loadClass("oracle.sql.BLOB");
        this.durationSessionConstant = new Integer(this.blobClass.getField("DURATION_SESSION").getInt(null));
        this.modeReadWriteConstant = new Integer(this.blobClass.getField("MODE_READWRITE").getInt(null));
    }

    protected BundleDbPersistenceManager.CloseableBLOBStore createDBBlobStore(PMContext context) throws Exception {
        return new OracleBLOBStore();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void storeBundle(NodePropBundle bundle) throws ItemStateException {
        String sql = null;
        Blob blob = null;
        try {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                this.binding.writeBundle((OutputStream)out, bundle);
                sql = bundle.isNew() ? this.bundleInsertSQL : this.bundleUpdateSQL;
                blob = this.createTemporaryBlob(new ByteArrayInputStream(out.toByteArray()));
                this.connectionManager.executeStmt(sql, new Object[]{blob, bundle.getId().getRawBytes()});
            }
            catch (Exception e) {
                String msg = "failed to write bundle: " + bundle.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, (Throwable)e);
            }
            Object var7_6 = null;
            if (blob == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (blob == null) throw throwable;
            try {
                this.freeTemporaryBlob(blob);
                throw throwable;
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e1) {}
        this.freeTemporaryBlob(blob);
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        Blob blob = null;
        try {
            try {
                String sql = this.existsReferencesTo(refs.getTargetId()) ? this.nodeReferenceUpdateSQL : this.nodeReferenceInsertSQL;
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                Serializer.serialize((NodeReferences)refs, (OutputStream)out);
                blob = this.createTemporaryBlob(new ByteArrayInputStream(out.toByteArray()));
                this.connectionManager.executeStmt(sql, new Object[]{blob, refs.getTargetId().getRawBytes()});
            }
            catch (Exception e) {
                String msg = "failed to write " + refs;
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, (Throwable)e);
            }
            Object var7_6 = null;
            if (blob == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (blob == null) throw throwable;
            try {
                this.freeTemporaryBlob(blob);
                throw throwable;
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e1) {}
        this.freeTemporaryBlob(blob);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blob createTemporaryBlob(InputStream in) throws Exception {
        OutputStream out;
        Object blob;
        block6: {
            Method createTemporary = this.blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
            blob = createTemporary.invoke(null, this.connectionManager.getConnection(), Boolean.FALSE, this.durationSessionConstant);
            Method open = this.blobClass.getMethod("open", Integer.TYPE);
            open.invoke(blob, this.modeReadWriteConstant);
            Method getBinaryOutputStream = this.blobClass.getMethod("getBinaryOutputStream", new Class[0]);
            out = (OutputStream)getBinaryOutputStream.invoke(blob, new Object[0]);
            try {
                int read;
                byte[] buf = new byte[8192];
                while ((read = in.read(buf, 0, buf.length)) > -1) {
                    out.write(buf, 0, read);
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    out.flush();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                out.close();
                throw throwable;
            }
            try {
                out.flush();
                break block6;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            {
            }
        }
        out.close();
        Method close = this.blobClass.getMethod("close", new Class[0]);
        close.invoke(blob, new Object[0]);
        return (Blob)blob;
    }

    protected void freeTemporaryBlob(Object blob) throws Exception {
        Method freeTemporary = this.blobClass.getMethod("freeTemporary", new Class[0]);
        freeTemporary.invoke(blob, new Object[0]);
    }

    class OracleBLOBStore
    extends BundleDbPersistenceManager.DbBlobStore {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void put(String blobId, InputStream in, long size) throws Exception {
            Blob blob = null;
            try {
                PreparedStatement stmt = OracleLegacyPersistenceManager.this.connectionManager.executeStmt(this.blobSelectExistSQL, new Object[]{blobId});
                ResultSet rs = stmt.getResultSet();
                boolean exists = rs.next();
                OracleLegacyPersistenceManager.this.closeResultSet(rs);
                String sql = exists ? this.blobUpdateSQL : this.blobInsertSQL;
                blob = OracleLegacyPersistenceManager.this.createTemporaryBlob(in);
                OracleLegacyPersistenceManager.this.connectionManager.executeStmt(sql, new Object[]{blob, blobId});
                Object var11_9 = null;
                if (blob == null) return;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (blob == null) throw throwable;
                try {
                    OracleLegacyPersistenceManager.this.freeTemporaryBlob(blob);
                    throw throwable;
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                OracleLegacyPersistenceManager.this.freeTemporaryBlob(blob);
                return;
            }
            catch (Exception e1) {}
        }
    }
}

