/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.jndi.jcrprovider;

import com.day.crx.core.config.CRXRepositoryConfig;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;

class RepositoryContextLoader {
    public static final String PROP_REPOSITORY_CLASS = "com.day.crx.repository.class";
    public static final String PROP_HOMEDIR = "com.day.crx.repository.home";
    public static final String PROP_CONFIGFILE = "com.day.crx.repository.config";
    protected static final String PROPERTIES_FILE_EXT = ".properties";
    private final File contextRoot;
    private Map bindings = new HashMap(3, 0.75f);
    private Set unbound;

    RepositoryContextLoader(File contextRoot) throws NamingException {
        if (!contextRoot.exists() || !contextRoot.isDirectory()) {
            throw new NamingException(contextRoot + " must be an existing " + "directory");
        }
        this.contextRoot = contextRoot;
    }

    String getContextPath() throws NamingException {
        try {
            return this.contextRoot.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw RepositoryContextLoader.getNamingException("Cannot get name of " + this.contextRoot, ioe);
        }
    }

    Iterator getNames() {
        ArrayList<String> names = new ArrayList<String>();
        File[] listing = this.contextRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(RepositoryContextLoader.PROPERTIES_FILE_EXT) && pathname.getName().length() > RepositoryContextLoader.PROPERTIES_FILE_EXT.length();
            }
        });
        for (int i = 0; i < listing.length; ++i) {
            String name = listing[i].getName();
            int nameLength = name.length() - PROPERTIES_FILE_EXT.length();
            names.add(name.substring(0, nameLength));
        }
        return names.iterator();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object get(String name) throws NamingException {
        RepositoryConfig repoConfig;
        Properties props;
        block17: {
            Object v = this.bindings.get(name);
            if (v != null) {
                return v;
            }
            if (this.unbound != null && this.unbound.contains(name)) {
                throw new NameNotFoundException(name);
            }
            File propFile = this.getPropertiesFile(name);
            if (!propFile.exists()) {
                throw new NamingException("Cannot load " + name + ". Properties file does not exist: " + propFile.getPath());
            }
            props = new Properties();
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(propFile);
                    props.load(in);
                }
                catch (IOException ioe) {
                    throw RepositoryContextLoader.getNamingException("Cannot read configuration " + propFile, ioe);
                }
                Object var8_9 = null;
                if (in == null) break block17;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignore) {}
            in.close();
        }
        String className = props.getProperty(PROP_REPOSITORY_CLASS);
        String home = props.getProperty(PROP_HOMEDIR, System.getProperty("user.dir"));
        home = new File(home).getAbsolutePath();
        String config = props.getProperty(PROP_CONFIGFILE, home + "/repository.xml");
        config = new File(config).getAbsolutePath();
        try {
            repoConfig = CRXRepositoryConfig.create(config, home);
        }
        catch (ConfigurationException ce) {
            throw RepositoryContextLoader.getNamingException("Cannot create configuration from " + config + " in directory " + home, ce);
        }
        try {
            void var2_5;
            if (className != null && className.length() > 0) {
                Class<?> clazz = Class.forName(className);
                Method create = clazz.getMethod("create", repoConfig.getClass());
                Object object = create.invoke(null, repoConfig);
            } else {
                RepositoryImpl repositoryImpl = RepositoryImpl.create((RepositoryConfig)repoConfig);
            }
            if (var2_5 == null) {
                throw new NamingException("Cannot get repository " + name);
            }
            this.bindings.put(name, var2_5);
            return var2_5;
        }
        catch (Exception e) {
            throw RepositoryContextLoader.getNamingException("Cannot get repository " + name, e);
        }
    }

    void put(String name, Object obj, boolean rebind) throws NamingException {
        if (!rebind && (this.bindings.containsKey(name) || this.getPropertiesFile(name).exists())) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        this.bindings.put(name, obj);
        if (this.unbound != null) {
            this.unbound.remove(name);
        }
    }

    void rename(String oldnm, String newnm) throws NameAlreadyBoundException, NameNotFoundException {
        File oldnmProp = this.getPropertiesFile(oldnm);
        File newnmProp = this.getPropertiesFile(newnm);
        if (this.bindings.containsKey(newnm) || newnmProp.exists()) {
            throw new NameAlreadyBoundException(newnm);
        }
        Object oldBinding = this.bindings.remove(oldnm);
        if (oldBinding != null) {
            this.bindings.put(newnm, oldBinding);
        } else if (!oldnmProp.exists()) {
            throw new NameNotFoundException(oldnm);
        }
        if (this.unbound == null) {
            this.unbound = new HashSet(1, 0.75f);
        }
        this.unbound.add(oldnm);
        this.unbound.remove(newnm);
        this.getPropertiesFile(oldnm).renameTo(this.getPropertiesFile(newnm));
    }

    void remove(String name) {
        boolean known;
        boolean bl = known = this.bindings.remove(name) != null;
        if (known) {
            if (this.unbound == null) {
                this.unbound = new HashSet(1, 0.75f);
            }
            this.unbound.add(name);
        }
    }

    static NamingException getNamingException(String message, Throwable cause) {
        NamingException ne = new NamingException(message);
        ne.setRootCause(cause);
        return ne;
    }

    private File getPropertiesFile(String name) {
        return new File(this.contextRoot, name + PROPERTIES_FILE_EXT);
    }
}

