/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.io.durbo;

import com.day.crx.CRXSession;
import com.day.crx.core.util.NodeType2RepoMapping;
import com.day.crx.io.CRXImportHandler;
import com.day.crx.io.durbo.DurboExport;
import com.day.crx.io.durbo.NSResolverAdapter;
import com.day.durbo.DurboInput;
import com.day.durbo.DurboNamespaceResolver;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurboImport
implements CRXImportHandler {
    private static final Logger log = LoggerFactory.getLogger(DurboInput.class);
    public static final double VERSION_1_0 = 1.0;
    public static final double VERSION_1_1 = 1.1;
    public static final double VERSION_REQUIRED = 1.0;
    private final CRXSession session;
    private NamePathResolver resolver;
    private NodeType2RepoMapping ntMapping;
    private DurboInput din;
    private final NamespaceRegistry nsReg;
    private final ItemManager iMgr;
    private Properties properties = new Properties();
    private int intermediateHandling = 0;
    private Name intermediateNodeType = null;
    private int uuidBehavior = 1;
    private double version;

    public DurboImport(Session session) throws RepositoryException {
        this.session = (CRXSession)session;
        this.nsReg = session.getWorkspace().getNamespaceRegistry();
        this.iMgr = ((SessionImpl)this.session).getItemManager();
    }

    public boolean importCRX(String parentAbsPath, InputStream in) throws IOException, RepositoryException {
        if (this.importCRX(parentAbsPath, new DurboInput(in))) {
            in.close();
            return true;
        }
        return false;
    }

    public boolean importCRX(String parentAbsPath, DurboInput din) throws IOException, RepositoryException {
        Node importRoot = (Node)this.session.getItem(parentAbsPath);
        if (din.getContentType().equals("crx")) {
            this.din = din;
            NSResolverAdapter nr = new NSResolverAdapter((DurboNamespaceResolver)din, this.nsReg);
            this.resolver = new DefaultNamePathResolver((NamespaceResolver)nr);
            this.ntMapping = new NodeType2RepoMapping(this.session.getWorkspace().getNodeTypeManager());
            this.properties.clear();
            this.importCRXPackage((NodeImpl)importRoot);
            return true;
        }
        return false;
    }

    private Name resolveName(DurboInput.Element elem) throws RepositoryException {
        if (elem == null || elem.name() == null || elem.name().equals("")) {
            return null;
        }
        return this.resolver.getQName(elem.name());
    }

    private boolean importCRXPackage(NodeImpl parentNode) throws IOException, RepositoryException {
        DurboInput.Element elem = this.din.read();
        while (elem != null && !elem.isNodeEnd()) {
            if (elem.name().equals("Properties")) {
                this.readProperties();
                String versionStr = this.properties.getProperty("Version");
                try {
                    this.version = versionStr == null ? 0.0 : Double.valueOf(versionStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (this.version < 1.0) {
                    throw new IOException("Invalid version: " + this.version + ". At least " + 1.0 + " is needed.");
                }
            } else if (elem.name().equals("NodeTypes")) {
                this.readNodeTypes();
            } else if (elem.name().equals("Content")) {
                this.importNodes(parentNode);
            } else {
                throw new IOException("Unkown element: " + elem.name());
            }
            elem = this.din.read();
        }
        return true;
    }

    private void readProperties() throws IOException, RepositoryException {
        DurboInput.Element elem = this.din.read();
        while (!elem.isNodeEnd()) {
            if (!elem.isProperty()) {
                throw new IOException(elem + " not allowed here.");
            }
            this.properties.setProperty(elem.name(), ((DurboInput.Property)elem).getValues()[0].getString());
            elem = this.din.read();
        }
    }

    private void readNodeTypes() throws IOException, RepositoryException {
        NodeTypeManager ntReg = this.session.getWorkspace().getNodeTypeManager();
        DurboInput.Element elem = this.din.read();
        LinkedList<NodeTypeTemplate> nodeTypes = new LinkedList<NodeTypeTemplate>();
        while (!elem.isNodeEnd()) {
            if (!elem.isNodeStart()) {
                throw new IOException(elem + " not allowed here.");
            }
            String ntName = elem.name();
            if (ntReg.hasNodeType(ntName)) {
                this.din.skipNode();
            } else {
                Node tmpNode = this.importNode((NodeImpl)this.session.getRootNode(), this.resolver.getQName("__tmpNode"));
                NodeTypeTemplate def = this.ntMapping.createNodeTypeDef(tmpNode);
                nodeTypes.add(def);
                log.info("Registering new NodeType: {}", (Object)ntName);
                tmpNode.remove();
            }
            elem = this.din.read();
        }
        ntReg.registerNodeTypes((NodeTypeDefinition[])nodeTypes.toArray(new NodeTypeTemplate[nodeTypes.size()]), true);
    }

    private void importNodes(NodeImpl parentNode) throws IOException, RepositoryException {
        DurboInput.Element elem = this.din.read();
        while (!elem.isNodeEnd()) {
            if (!elem.isNodeStart()) {
                throw new IOException("NodeStart expected.");
            }
            this.importNode(parentNode, this.resolveName(elem));
            elem = this.din.read();
        }
    }

    private Node importNode(NodeImpl parentNode, Name nodeName) throws IOException, RepositoryException {
        if (parentNode.getQName().equals(NameConstants.JCR_SYSTEM)) {
            if (NameConstants.JCR_VERSIONSTORAGE.equals(nodeName)) {
                log.warn("Unable to import " + nodeName + ". Not Supported yet.");
                this.din.skipNode();
                return parentNode.getNode(nodeName);
            }
            if (NameConstants.JCR_NODETYPES.equals(nodeName)) {
                log.warn("Ignoring to import " + nodeName + ".");
                this.din.skipNode();
                return parentNode.getNode(nodeName);
            }
        }
        NodeImpl node = null;
        Name nodeType = null;
        Value[] mixinTypes = JcrUtils.NO_VALUES;
        NodeId id = null;
        boolean isReferenceable = false;
        int structuralType = 110;
        DurboInput.Element elem = this.din.read();
        Name name = this.resolveName(elem);
        LinkedList<Node> children = new LinkedList<Node>();
        while (elem != null) {
            block38: {
                if (elem.isProperty()) {
                    DurboInput.Property p = (DurboInput.Property)elem;
                    if (name.equals(NameConstants.JCR_PRIMARYTYPE)) {
                        nodeType = this.resolver.getQName(p.getValues()[0].getString());
                    } else if (name.equals(NameConstants.JCR_MIXINTYPES)) {
                        mixinTypes = p.getJcrValues(this.session.getValueFactory());
                    } else if (name.equals(NameConstants.JCR_UUID)) {
                        id = new NodeId(p.getValues()[0].getString());
                        isReferenceable = true;
                    } else if (name.equals(DurboExport.INTERNAL_PROPNAME_UUID)) {
                        id = new NodeId(p.getString());
                    } else if (name.equals(DurboExport.INTERNAL_PROPNAME_FLAGS)) {
                        structuralType = p.getString().charAt(0);
                    } else {
                        if (node == null) {
                            if (structuralType == 110) {
                                node = this.createNode(parentNode, nodeName, nodeType, id, mixinTypes, structuralType, isReferenceable);
                            } else {
                                log.warn("non-normal node has additional properties: ", (Object)elem.name());
                            }
                        }
                        try {
                            Value[] values = p.getJcrValues(this.session.getValueFactory());
                            if (p.getType() == 7 || p.getType() == 8) {
                                for (Value value : values) {
                                    InternalValue.create((Value)value, (NamePathResolver)this.resolver);
                                }
                            }
                            if (p.isMultiple()) {
                                node.setProperty(name, values, p.getType());
                                break block38;
                            }
                            node.setProperty(name, values[0]);
                        }
                        catch (RepositoryException e) {
                            log.warn("Error while adding property: {}. {}", (Object)elem.name(), (Object)e.toString());
                        }
                    }
                } else if (elem.isNodeStart()) {
                    if (node == null) {
                        node = this.createNode(parentNode, nodeName, nodeType, id, mixinTypes, structuralType, isReferenceable);
                    }
                    if (structuralType == 104) {
                        log.warn("hint node has children...ignore importing.", (Object)elem.name());
                        this.din.skipNode();
                    } else {
                        Node child = this.importNode(node, name);
                        if (child != null) {
                            children.add(child);
                        }
                    }
                } else {
                    if (elem.isNodeEnd()) {
                        if (node == null) {
                            if (structuralType == 105) {
                                log.warn("intermediate node as leaf...ignore creation.", (Object)nodeName);
                            } else {
                                node = this.createNode(parentNode, nodeName, nodeType, id, mixinTypes, structuralType, isReferenceable);
                            }
                        }
                        if (node != null && structuralType == 110) {
                            HashSet<NodeId> existing = new HashSet<NodeId>();
                            for (Node c : children) {
                                NodeImpl child = (NodeImpl)c;
                                if (node.getPrimaryNodeType().hasOrderableChildNodes()) {
                                    node.orderBefore(child.getName(), null);
                                }
                                existing.add(child.getNodeId());
                            }
                            NodeIterator niter = node.getNodes();
                            while (niter.hasNext()) {
                                NodeImpl child = (NodeImpl)niter.nextNode();
                                if (existing.contains(child.getNodeId())) continue;
                                child.remove();
                            }
                        }
                        return node;
                    }
                    throw new IOException("Unexpected elem type.");
                }
            }
            elem = this.din.read();
            name = this.resolveName(elem);
        }
        throw new EOFException("Unexpected end of input");
    }

    private NodeImpl createNode(NodeImpl parentNode, Name nodeName, Name nodeType, NodeId id, Value[] mixinTypes, int type, boolean isReferenceable) throws RepositoryException {
        int i;
        if (nodeName == null) {
            return parentNode;
        }
        NodeImpl node = null;
        if (id != null) {
            try {
                if (this.iMgr.itemExists((ItemId)id) && !(node = (NodeImpl)this.iMgr.getItem((ItemId)id)).getParent().isSame((Item)parentNode)) {
                    if (type == 110) {
                        if (isReferenceable) {
                            String parentPath = parentNode.getPath();
                            if (parentPath.equals("/")) {
                                parentPath = "";
                            }
                            this.session.move(node.getPath(), parentPath + "/" + this.resolver.getJCRName(nodeName));
                        } else {
                            node = null;
                            id = null;
                        }
                    } else {
                        if (type == 104) {
                            log.warn("hint node exists, but is not a child of the respective parent: {}", (Object)node.getPath());
                            return null;
                        }
                        if (type == 105) {
                            log.error("intermediate node exists, but is not a child of the respective parent: {}", (Object)node.getPath());
                            throw new RepositoryException("intermediate node exists, but is not a child of the respective parent");
                        }
                    }
                }
            }
            catch (NamespaceException e) {
                log.warn("Error while importing. will create new node.", (Throwable)e);
                node = null;
                id = null;
            }
        }
        if (node == null && !isReferenceable && parentNode.hasNode(nodeName) && !(node = parentNode.getNode(nodeName)).getDefinition().isAutoCreated() && parentNode.getDefinition().allowsSameNameSiblings()) {
            node = null;
        }
        if (type == 104) {
            return node;
        }
        if (nodeType == null) {
            throw new RepositoryException("jcr:primaryType expected.");
        }
        Name[] mixinNames = new Name[mixinTypes.length];
        for (i = 0; i < mixinTypes.length; ++i) {
            mixinNames[i] = this.resolver.getQName(mixinTypes[i].getString());
        }
        if (node == null) {
            if (type == 105) {
                if (this.intermediateHandling == 0) {
                    throw new RepositoryException("Intermediate node does not exist " + parentNode.getPath() + "/" + nodeName);
                }
                Name imNT = this.intermediateHandling == 2 ? nodeType : this.intermediateNodeType;
                try {
                    node = parentNode.addNode(nodeName, imNT, id);
                }
                catch (RepositoryException e) {
                    log.warn("Error while creating intermediate node with nodetype {}. creating normal.");
                    try {
                        node = parentNode.addNode(nodeName, null, id);
                    }
                    catch (RepositoryException e1) {
                        log.error("Unable to create intermediate node with unstructured. aborting.");
                        throw new RepositoryException((Throwable)e);
                    }
                }
                log.info("Created Intermediate Node {}", (Object)node.getPath());
            } else {
                node = parentNode.addNode(nodeName, nodeType, id);
                for (i = 0; i < mixinTypes.length; ++i) {
                    node.addMixin(mixinNames[i]);
                }
                log.info("Created Node {}", (Object)node.getPath());
            }
        } else if (type == 110) {
            this.setNodeType(node, nodeType, mixinNames);
        }
        return node;
    }

    private void setNodeType(NodeImpl node, Name nodeType, Name[] mixinTypes) throws RepositoryException {
        if (node.isNodeType(nodeType)) {
            NodeType[] mixins;
            HashSet<Name> names = new HashSet<Name>();
            for (Name mixinType : mixinTypes) {
                if (!node.isNodeType(mixinType)) {
                    node.addMixin(mixinType);
                }
                names.add(mixinType);
            }
            for (NodeType mixin : mixins = node.getMixinNodeTypes()) {
                Name name = ((NodeTypeImpl)mixin).getQName();
                if (names.contains(name)) continue;
                node.removeMixin(name);
            }
            return;
        }
        NodeImpl tmpNode = (NodeImpl)node.getSession().getRootNode().addNode(UUID.randomUUID().toString(), "nt:unstructured");
        this.copyProperties(node, tmpNode);
        this.moveChildNodes(node, tmpNode);
        Name nodeName = node.getQName();
        NodeId id = node.getNodeId();
        NodeImpl parentNode = (NodeImpl)node.getParent();
        node.remove();
        node = parentNode.addNode(nodeName, nodeType, id);
        for (Name mixinType : mixinTypes) {
            node.addMixin(mixinType);
        }
        this.copyProperties(tmpNode, node);
        this.moveChildNodes(tmpNode, node);
        tmpNode.remove();
    }

    private void copyProperties(NodeImpl src, NodeImpl dst) throws RepositoryException {
        PropertyIterator pIter = src.getProperties();
        while (pIter.hasNext()) {
            PropertyImpl p = (PropertyImpl)pIter.nextProperty();
            try {
                if (p.isMultiple()) {
                    dst.setProperty(p.getQName(), p.getValues(), p.getType());
                    continue;
                }
                dst.setProperty(p.getQName(), p.getValue());
            }
            catch (RepositoryException e) {
                log.warn("Unable to copy property: {}", (Object)e.getMessage());
            }
        }
    }

    private void moveChildNodes(NodeImpl src, NodeImpl dst) throws RepositoryException {
        try {
            NodeIterator nIter = src.getNodes();
            while (nIter.hasNext()) {
                NodeImpl n = (NodeImpl)nIter.nextNode();
                src.getSession().move(n.getPath(), dst.getPath() + "/" + n.getName());
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public int getUuidBehavior() {
        return this.uuidBehavior;
    }

    public void setUuidBehavior(int uuidBehavior) {
        this.uuidBehavior = uuidBehavior;
    }

    public int getIntermediateHandling() {
        return this.intermediateHandling;
    }

    public void setIntermediateHandling(int intermediateHandling) {
        this.intermediateHandling = intermediateHandling;
        if (intermediateHandling == 1) {
            this.intermediateNodeType = null;
        }
    }

    public String getIntermediateNodeType() throws NamespaceException {
        return this.resolver.getJCRName(this.intermediateNodeType);
    }

    public void setIntermediateNodeType(String intermediateNodeType) throws NamespaceException {
        try {
            this.intermediateNodeType = this.resolver.getQName(intermediateNodeType);
        }
        catch (IllegalNameException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

