/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.io.durbo;

import com.day.crx.CRXSession;
import com.day.crx.core.util.NodeType2RepoMapping;
import com.day.crx.io.CRXExportHandler;
import com.day.crx.io.durbo.NodeTypeSet;
import com.day.durbo.DurboNamespaceResolver;
import com.day.durbo.DurboOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public class DurboExport
implements CRXExportHandler {
    public static final String CONTENT_TYPE = "crx";
    public static final String NODENAME_NODETYPES = "NodeTypes";
    public static final String NODENAME_PROPERTIES = "Properties";
    public static final String NODENAME_CONTENT = "Content";
    public static final String PROPNAME_VERSION = "Version";
    public static final String PROPNAME_INCLUDE_NEIGHBORHOOD = "IncludeNeighborHood";
    public static final String PROPNAME_INCLUDE_UUIDS = "IncludeUUIDs";
    public static final String PROPNAME_EXCLUDE_NODETYPES = "ExcludeNodeTypes";
    public static final String NS_DURBO_URI = "http://www.day.com/crx/durbo/1.0";
    public static final double VERSION = 1.1;
    public static final Name INTERNAL_PROPNAME_FLAGS = NameFactoryImpl.getInstance().create("http://www.day.com/crx/durbo/1.0", "flags");
    public static final Name INTERNAL_PROPNAME_UUID = NameFactoryImpl.getInstance().create("http://www.day.com/crx/durbo/1.0", "uuid");
    public static final char INTERNAL_FLAG_ST_NORMAL = 'n';
    public static final char INTERNAL_FLAG_ST_INTERMEDIATE = 'i';
    public static final char INTERNAL_FLAG_ST_HINT = 'h';
    private DurboNamespaceResolver resolver;
    private DurboOutput out;
    private Properties properties = new Properties();
    private final CRXSession session;
    private boolean includeNeighborhood = false;
    private boolean excludeNodeTypes = false;
    private boolean includeUUIDs = true;
    private String propNameFlags;
    private String propNameUUID;
    private HashSet excludes = new HashSet();

    public DurboExport(Session session) {
        this.session = (CRXSession)session;
        this.properties.put(PROPNAME_VERSION, String.valueOf(1.1));
    }

    public synchronized void export(String absPath, OutputStream out) throws RepositoryException, IOException {
        this.initResolver((Session)this.session);
        this.out = new DurboOutput(out, this.resolver, CONTENT_TYPE, true);
        Node node = (Node)this.session.getItem(absPath);
        this.writeProperties();
        if (!this.excludeNodeTypes) {
            NodeTypeSet nodeTypes = new NodeTypeSet();
            nodeTypes.collect(node, this.includeNeighborhood);
            this.writeNodeTypes(nodeTypes, node.getSession());
        }
        this.out.openNode(NODENAME_CONTENT);
        if (this.includeNeighborhood) {
            this.writeHollow(node);
        } else {
            this.writeNode(node, true);
        }
        this.out.closeNode();
        this.out.close();
        this.out = null;
    }

    private void initResolver(final Session session) throws RepositoryException {
        String prefix = "db";
        int i = 0;
        try {
            while (session.getNamespaceURI(prefix) != null) {
                prefix = "db" + i++;
            }
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        this.propNameFlags = prefix + ":" + INTERNAL_PROPNAME_FLAGS.getLocalName();
        this.propNameUUID = prefix + ":" + INTERNAL_PROPNAME_UUID.getLocalName();
        final String nsDurboPrefix = prefix;
        this.resolver = new DurboNamespaceResolver(){

            public String getURI(String prefix) throws NamespaceException {
                if (prefix.equals(nsDurboPrefix)) {
                    return DurboExport.NS_DURBO_URI;
                }
                try {
                    return session.getNamespaceURI(prefix);
                }
                catch (RepositoryException e) {
                    throw new NamespaceException((Throwable)e);
                }
            }

            public String getPrefix(String uri) throws NamespaceException {
                if (uri.equals(DurboExport.NS_DURBO_URI)) {
                    return nsDurboPrefix;
                }
                try {
                    return session.getNamespacePrefix(uri);
                }
                catch (RepositoryException e) {
                    throw new NamespaceException((Throwable)e);
                }
            }
        };
    }

    public DurboNamespaceResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(DurboNamespaceResolver resolver) {
        this.resolver = resolver;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    private void writeHollow(Node node) throws RepositoryException, IOException {
        if (node.getDepth() > 0) {
            Node parent = node.getParent();
            this.openAncestor(parent);
            NodeIterator iter = parent.getNodes();
            while (iter.hasNext()) {
                Node sibling = iter.nextNode();
                if (sibling.isSame((Item)node)) {
                    this.writeNode(node, false);
                    continue;
                }
                this.writeHintNode(sibling);
            }
            this.closeAncestor(parent);
        } else {
            this.writeNode(node, false);
        }
    }

    private void openAncestor(Node node) throws RepositoryException, IOException {
        if (node.getDepth() > 0) {
            Node parent = node.getParent();
            this.openAncestor(parent);
            this.out.openNode(node.getName());
            this.out.writeProperty(this.propNameFlags, String.valueOf('i'));
            this.out.writeProperty(node.getProperty("jcr:primaryType"));
            if (node.hasProperty("jcr:mixinTypes")) {
                this.out.writeProperty(node.getProperty("jcr:mixinTypes"));
            }
            if (node.hasProperty("jcr:uuid")) {
                this.out.writeProperty(node.getProperty("jcr:uuid"));
            } else {
                this.out.writeProperty(this.propNameUUID, ((NodeImpl)node).getNodeId().toString());
            }
        }
    }

    private void closeAncestor(Node node) throws RepositoryException, IOException {
        if (node.getDepth() > 0) {
            Node parent = node.getParent();
            this.closeAncestor(parent);
            this.out.closeNode();
        }
    }

    private void writeHintNode(Node node) throws RepositoryException, IOException {
        if (this.excludes.contains(node.getPath())) {
            return;
        }
        this.out.openNode(node.getName());
        this.out.writeProperty(this.propNameFlags, String.valueOf('h'));
        if (node.hasProperty("jcr:uuid")) {
            this.out.writeProperty(node.getProperty("jcr:uuid"));
        } else if (this.includeUUIDs) {
            this.out.writeProperty(this.propNameUUID, ((NodeImpl)node).getNodeId().toString());
        }
        this.out.closeNode();
    }

    private void writeNode(Node node, boolean forceDeep) throws RepositoryException, IOException {
        if (this.excludes.contains(node.getPath())) {
            return;
        }
        this.out.openNode(node.getName());
        this.out.writeProperty(node.getProperty("jcr:primaryType"));
        if (node.hasProperty("jcr:mixinTypes")) {
            this.out.writeProperty(node.getProperty("jcr:mixinTypes"));
        }
        if (node.hasProperty("jcr:uuid")) {
            this.out.writeProperty(node.getProperty("jcr:uuid"));
        } else if (this.includeUUIDs) {
            this.out.writeProperty(this.propNameUUID, ((NodeImpl)node).getNodeId().toString());
        }
        PropertyIterator piter = node.getProperties();
        while (piter.hasNext()) {
            Property prop = piter.nextProperty();
            if (prop.getName().equals("jcr:primaryType") || prop.getName().equals("jcr:mixinTypes") || prop.getName().equals("jcr:uuid")) continue;
            this.out.writeProperty(prop);
        }
        NodeIterator niter = node.getNodes();
        while (niter.hasNext()) {
            Node child = niter.nextNode();
            if (forceDeep || child.getDefinition().getOnParentVersion() != 2) {
                this.writeNode(child, true);
                continue;
            }
            this.writeHintNode(child);
        }
        this.out.closeNode();
    }

    private void writeProperties() throws IOException {
        this.out.openNode(NODENAME_PROPERTIES);
        for (String string : this.properties.keySet()) {
            this.out.writeProperty(string, this.properties.getProperty(string));
        }
        this.out.closeNode();
    }

    private void writeNodeTypes(NodeTypeSet nodeTypes, Session session) throws RepositoryException, IOException {
        NodeTypeManager ntMgr = session.getWorkspace().getNodeTypeManager();
        this.out.openNode(NODENAME_NODETYPES);
        Iterator iter = nodeTypes.iterator();
        while (iter.hasNext()) {
            String nodeTypeName = (String)iter.next();
            NodeType nt = ntMgr.getNodeType(nodeTypeName);
            this.writeNodeType(session, nt);
        }
        this.out.closeNode();
    }

    private void writeNodeType(Session session, NodeType nt) throws RepositoryException, IOException {
        Node ntNode = NodeType2RepoMapping.mapNodeType(session.getRootNode(), nt);
        this.writeNode(ntNode, true);
        ntNode.remove();
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
        if (name.equals(PROPNAME_INCLUDE_NEIGHBORHOOD)) {
            this.includeNeighborhood = Boolean.valueOf(value);
        } else if (name.equals(PROPNAME_EXCLUDE_NODETYPES)) {
            this.excludeNodeTypes = Boolean.valueOf(value);
        } else if (name.equals(PROPNAME_INCLUDE_UUIDS)) {
            this.includeUUIDs = Boolean.valueOf(value);
        }
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public boolean getProperty(String name, boolean def) {
        return this.properties.getProperty(name) == null ? def : Boolean.valueOf(this.properties.getProperty(name));
    }

    public boolean isIncludeNeighborhood() {
        return this.includeNeighborhood;
    }

    public void setIncludeNeighborhood(boolean includeNeighborhood) {
        this.includeNeighborhood = includeNeighborhood;
        this.properties.setProperty(PROPNAME_INCLUDE_NEIGHBORHOOD, String.valueOf(includeNeighborhood));
    }

    public void setIncludeUUIDs(boolean includeUUIDs) {
        this.includeUUIDs = includeUUIDs;
        this.properties.setProperty(PROPNAME_INCLUDE_UUIDS, String.valueOf(includeUUIDs));
    }

    public boolean isExcludeNodeTypes() {
        return this.excludeNodeTypes;
    }

    public boolean isIncludeUUIDs() {
        return this.includeUUIDs;
    }

    public void setExcludeNodeTypes(boolean excludeNodeTypes) {
        this.excludeNodeTypes = excludeNodeTypes;
        this.properties.setProperty(PROPNAME_EXCLUDE_NODETYPES, String.valueOf(excludeNodeTypes));
    }

    public void addExcludedPath(String path) {
        this.excludes.add(path);
    }
}

