/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.util;

import com.day.crx.CRXModule;
import com.day.crx.CRXSession;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManagerModule
implements CRXModule {
    private static final Logger log = LoggerFactory.getLogger(CacheManagerModule.class);
    private long maxMemory = Long.getLong("org.apache.jackrabbit.maxCacheMemory", 0x1000000L);
    private long minMemoryPerCache = Long.getLong("org.apache.jackrabbit.minMemoryPerCache", 131072L);
    private long maxMemoryPerCache = Long.getLong("org.apache.jackrabbit.maxMemoryPerCache", 0x400000L);
    private long resizeInterval = Long.getLong("org.apache.jackrabbit.cacheResizeInterval", 1000L);

    public String getName() {
        return this.getClass().getName();
    }

    public void start(CRXSession session) throws RepositoryException {
        RepositoryImpl repository = (RepositoryImpl)session.getRepository();
        CacheManager manager = repository.getCacheManager();
        manager.setMaxMemory(this.maxMemory);
        manager.setMaxMemoryPerCache(this.maxMemoryPerCache);
        manager.setMinMemoryPerCache(this.minMemoryPerCache);
        manager.setMinResizeInterval(this.resizeInterval);
        log.info("Cache memory limits set to " + this.maxMemory + "/" + this.maxMemoryPerCache + "/" + this.minMemoryPerCache + "/" + this.resizeInterval);
    }

    public void stop() {
    }

    public String getMaxMemory() {
        return Long.toString(this.maxMemory);
    }

    public void setMaxMemory(String maxMemory) {
        try {
            this.maxMemory = Long.parseLong(maxMemory);
        }
        catch (NumberFormatException e) {
            log.warn("Ignoring invalid maxMemory: {}", (Object)maxMemory);
        }
    }

    public String getMinMemoryPerCache() {
        return Long.toString(this.minMemoryPerCache);
    }

    public void setMinMemoryPerCache(String minMemoryPerCache) {
        try {
            this.minMemoryPerCache = Long.parseLong(minMemoryPerCache);
        }
        catch (NumberFormatException e) {
            log.warn("Ignoring invalid minMemoryPerCacheSize: {}", (Object)minMemoryPerCache);
        }
    }

    public String getMaxMemoryPerCache() {
        return Long.toString(this.maxMemoryPerCache);
    }

    public void setMaxMemoryPerCache(String maxMemoryPerCache) {
        try {
            this.maxMemoryPerCache = Long.parseLong(maxMemoryPerCache);
        }
        catch (NumberFormatException e) {
            log.warn("Ignoring invalid maxMemoryPerCacheSize: {}", (Object)maxMemoryPerCache);
        }
    }

    public String getResizeInterval() {
        return Long.toString(this.resizeInterval);
    }

    public void setResizeInterval(String resizeInterval) {
        try {
            this.resizeInterval = Long.parseLong(resizeInterval);
        }
        catch (NumberFormatException e) {
            log.warn("Ignoring invalid resizeInterval: {}", (Object)resizeInterval);
        }
    }
}

