/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.query;

import com.day.crx.core.query.NodeIteratorImpl;
import com.day.crx.core.query.RowIteratorImpl;
import com.day.crx.core.query.ScoreNode;
import com.day.crx.core.query.ScoreNodeIterator;
import javax.jcr.NamespaceException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultImpl
implements QueryResult {
    private static final Logger log = LoggerFactory.getLogger(QueryResultImpl.class);
    private final SessionContext sessionContext;
    private final ScoreNode[] scoreNodes;
    private final Name[] selectProps;

    public QueryResultImpl(SessionContext sessionContext, NodeId[] ids, Float[] scores, Name[] selectProps) {
        this.sessionContext = sessionContext;
        this.scoreNodes = new ScoreNode[ids.length];
        this.selectProps = selectProps;
        for (int i = 0; i < ids.length; ++i) {
            this.scoreNodes[i] = new ScoreNode(ids[i], scores[i].floatValue());
        }
    }

    public String[] getSelectorNames() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("JCR-2201: Implement QueryResult.getSelectorNames()");
    }

    public String[] getColumnNames() throws RepositoryException {
        try {
            String[] propNames = new String[this.selectProps.length];
            for (int i = 0; i < this.selectProps.length; ++i) {
                propNames[i] = this.sessionContext.getJCRName(this.selectProps[i]);
            }
            return propNames;
        }
        catch (NamespaceException e) {
            String msg = "encountered invalid property name";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.getNodeIterator();
    }

    public RowIterator getRows() throws RepositoryException {
        return new RowIteratorImpl(this.getNodeIterator(), this.selectProps, (NamePathResolver)this.sessionContext);
    }

    private ScoreNodeIterator getNodeIterator() {
        return new NodeIteratorImpl(this.sessionContext.getItemManager(), this.scoreNodes);
    }
}

