/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.journal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotatingLogFile
implements Comparable<RotatingLogFile> {
    public static final String LOG_EXTENSION = "log";
    private static Logger log = LoggerFactory.getLogger(RotatingLogFile.class);
    private final File directory;
    private final String basename;
    private final File file;
    private int version;

    private RotatingLogFile(File directory, String basename, File file) throws IllegalArgumentException {
        this.directory = directory;
        this.basename = basename;
        this.file = file;
        this.parseName();
    }

    private void parseName() throws IllegalArgumentException {
        String name = this.file.getName();
        int sep1 = name.indexOf(46);
        if (sep1 == -1) {
            throw new IllegalArgumentException("no dot in filename.");
        }
        if (!this.basename.equals(name.substring(0, sep1))) {
            throw new IllegalArgumentException("name does not start with " + this.basename + ".");
        }
        int sep2 = name.indexOf(46, sep1 + 1);
        if (sep2 == -1) {
            sep2 = name.length();
        }
        if (!LOG_EXTENSION.equals(name.substring(sep1 + 1, sep2))) {
            throw new IllegalArgumentException("name does not contain log.");
        }
        if (sep2 < name.length()) {
            String versionS = name.substring(sep2 + 1);
            try {
                this.version = Integer.parseInt(versionS);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("extension is not a number: " + versionS);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getVersion() {
        return this.version;
    }

    public void rotate() throws IOException {
        String newName = this.basename + "." + LOG_EXTENSION + "." + String.valueOf(this.version + 1);
        File dest = new File(this.directory, newName);
        if (!this.file.renameTo(dest)) {
            String msg = "Unable to rename log file " + this.file.getName() + " to " + dest.getName();
            throw new IOException(msg);
        }
    }

    @Override
    public int compareTo(RotatingLogFile o) {
        return this.version - o.version;
    }

    public static RotatingLogFile[] listFiles(File directory, final String basename) {
        File[] files = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(basename + ".");
            }
        });
        ArrayList<RotatingLogFile> l = new ArrayList<RotatingLogFile>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                l.add(new RotatingLogFile(directory, basename, file));
                continue;
            }
            catch (IllegalArgumentException e) {
                log.warn("Bogusly named journal file, skipped: " + files[i] + ", reason: " + e.getMessage());
            }
        }
        RotatingLogFile[] logFiles = new RotatingLogFile[l.size()];
        l.toArray(logFiles);
        Arrays.sort(logFiles, new Comparator<RotatingLogFile>(){

            @Override
            public int compare(RotatingLogFile lf1, RotatingLogFile lf2) {
                return lf2.compareTo(lf1);
            }
        });
        return logFiles;
    }
}

