/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.journal;

import com.day.crx.cluster.IdentityLock;
import com.day.crx.core.journal.FileJournal;
import com.day.crx.core.journal.JournalImplBase;
import com.day.crx.core.journal.LogRotator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.journal.FileRecordLog;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JournalImpl
extends JournalImplBase {
    private static final String LOG_EXTENSION = "log";
    private static final String REVISION_NAME = "revision";
    private static final int LOCK_RETRIES = 3;
    private static Logger log = LoggerFactory.getLogger(JournalImpl.class);
    private FileRevision globalRevision;
    private IdentityLock lock;
    private FileJournal journal;
    private File rootDirectory;
    private File journalFile;
    private final LogRotator rotator;

    public JournalImpl(FileJournal journal, File rootDirectory, String instanceId, int operationTimeout, LogRotator rotator) {
        super(instanceId);
        this.journal = journal;
        this.rootDirectory = rootDirectory;
        this.lock = new IdentityLock(operationTimeout);
        this.rotator = rotator;
    }

    protected void doActivate() throws IOException {
        try {
            this.journalFile = new File(this.rootDirectory, this.journal.getBasename() + "." + LOG_EXTENSION);
            this.globalRevision = new FileRevision(new File(this.rootDirectory, REVISION_NAME), false);
        }
        catch (JournalException e) {
            IOException e2 = new IOException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        log.info("FileJournal initialized at path: " + this.journal.getDirectory());
    }

    public long getRevision() throws JournalException {
        return this.globalRevision.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws JournalException {
        String identity = this.getCallerIdentity();
        int retry = 0;
        try {
            while (true) {
                try {
                    this.lock.acquire(identity);
                }
                catch (InterruptedException e) {
                    if (++retry >= 3) {
                        String msg = "Interrupted while acquiring lock.";
                        throw new JournalException(msg, (Throwable)e);
                    }
                    log.warn(e.getMessage());
                    continue;
                }
                break;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.exitOperation("lock");
            throw throwable;
        }
        this.exitOperation("lock");
    }

    public long append(String producerId, InputStream in, int length) throws JournalException {
        long l;
        String identity = this.getCallerIdentity();
        try {
            this.lock.enterLock(identity);
        }
        catch (IllegalStateException e) {
            throw new JournalException(e.getMessage(), (Throwable)e);
        }
        try {
            FileRecordLog recordLog = new FileRecordLog(this.journalFile);
            if (recordLog.exceeds((long)this.journal.getMaximumSize())) {
                this.rotateLogs();
                recordLog = new FileRecordLog(this.journalFile);
            }
            if (recordLog.isNew()) {
                recordLog.init(this.globalRevision.get());
            }
            long revision = recordLog.append(identity, producerId, in, length);
            this.globalRevision.set(revision);
            l = revision;
            Object var11_11 = null;
            this.lock.exitLock(identity);
        }
        catch (IOException e) {
            try {
                String msg = "Unable to append new record to '" + this.journalFile + "'.";
                throw new JournalException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.lock.exitLock(identity);
                this.exitOperation("append");
                throw throwable;
            }
        }
        this.exitOperation("append");
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlock() {
        String identity = this.getCallerIdentity();
        try {
            try {
                this.lock.release(identity);
            }
            catch (IllegalStateException e) {
                String msg = "Unable to unlock: " + e.getMessage();
                log.warn(msg);
                Object var5_3 = null;
                this.exitOperation("unlock");
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.exitOperation("unlock");
            throw throwable;
        }
        this.exitOperation("unlock");
    }

    protected void doDeactivate() {
        if (this.globalRevision != null) {
            this.globalRevision.close();
        }
    }

    private void rotateLogs() throws IOException {
        this.rotator.rotate();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("{rootDirectory=" + this.rootDirectory);
        buf.append(",journalFile=" + this.journalFile + "}");
        return buf.toString();
    }
}

