/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.journal;

import java.util.Calendar;
import java.util.StringTokenizer;

public class Duration {
    private static final String[] NAMES = new String[17];
    private final int[] fields = new int[17];
    private boolean negative;
    private int hash;
    private boolean pDesignator;
    private boolean tDesignator;
    private final FieldSetter[] setters = new FieldSetter[]{new FieldSetter('-'){

        void set() {
            Duration.this.negative = true;
        }
    }, new FieldSetter('P'){

        void set() {
            Duration.this.pDesignator = true;
        }
    }, new FieldSetter('Y'){

        void set(int val) {
            Duration.this.setField(1, val);
        }
    }, new FieldSetter('M'){

        void set(int val) {
            Duration.this.setField(2, val);
        }
    }, new FieldSetter('D'){

        void set(int val) {
            Duration.this.setField(5, val);
        }
    }, new FieldSetter('T'){

        void set() {
            Duration.this.tDesignator = true;
        }
    }, new FieldSetter('H'){

        void set(int val) {
            if (!Duration.this.tDesignator) {
                String msg = "Missing T designator";
                throw new IllegalArgumentException(msg);
            }
            Duration.this.setField(10, val);
        }
    }, new FieldSetter('M'){

        void set(int val) {
            if (!Duration.this.tDesignator) {
                String msg = "Missing T designator";
                throw new IllegalArgumentException(msg);
            }
            Duration.this.setField(12, val);
        }
    }, new FieldSetter('S'){

        void set(int val) {
            if (!Duration.this.tDesignator) {
                String msg = "Missing T designator";
                throw new IllegalArgumentException(msg);
            }
            Duration.this.setField(13, val);
        }
    }};

    public Duration(String s) throws IllegalArgumentException {
        this.parse(s);
    }

    public int getYears() {
        return this.fields[1];
    }

    public int getMonths() {
        return this.fields[2];
    }

    public int getDays() {
        return this.fields[5];
    }

    public int getHours() {
        return this.fields[10];
    }

    public int getMinutes() {
        return this.fields[12];
    }

    public int getSeconds() {
        return this.fields[13];
    }

    private void setField(int field, int value) {
        if (value < 0) {
            String msg = "Value in " + NAMES[field] + " must be non-negative.";
            throw new IllegalArgumentException(msg);
        }
        this.fields[field] = value;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void addTo(Calendar cal) {
        if (this.negative) {
            this.subtractFrom(cal);
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == 0) continue;
            cal.add(i, this.fields[i]);
        }
    }

    public void subtractFrom(Calendar cal) {
        if (this.negative) {
            this.addTo(cal);
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == 0) continue;
            cal.add(i, -this.fields[i]);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Duration) {
            Duration other = (Duration)obj;
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] == other.fields[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            for (int i = 0; i < this.fields.length; ++i) {
                int val = this.fields[i];
                if (val == 0) continue;
                h = h * 37 + val;
            }
            if (this.negative) {
                h = -h;
            }
            this.hash = h;
        }
        return h;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.fields.length; ++i) {
            int val = this.fields[i];
            if (val == 0) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(val);
            buf.append(' ');
            buf.append(NAMES[i]);
            if (val == 1) continue;
            buf.append('s');
        }
        if (buf.length() == 0) {
            buf.append("no duration");
        }
        return buf.toString();
    }

    private void parse(String s) {
        if (s.startsWith("-") || s.startsWith("P")) {
            this.parseISO8601(s);
        } else {
            this.parsePlain(s);
        }
    }

    private void parseISO8601(String s) throws IllegalArgumentException {
        char[] ac = s.toCharArray();
        int coff = 0;
        int setteroff = 0;
        int val = -1;
        while (coff < ac.length && setteroff < this.setters.length) {
            char c;
            if ((c = ac[coff++]) >= '0' && c <= '9') {
                val = val == -1 ? 0 : (val *= 10);
                val += c - 48;
                continue;
            }
            setteroff = this.setField(setteroff, c, val);
            val = -1;
        }
        if (coff < ac.length) {
            String msg = "Trailing input at offset " + coff;
            throw new IllegalArgumentException(msg);
        }
        if (val != -1) {
            String msg = "Number without designator found: " + val;
            throw new IllegalArgumentException(msg);
        }
        if (!this.pDesignator) {
            String msg = "Missing P designator.";
            throw new IllegalArgumentException(msg);
        }
    }

    private void parsePlain(String s) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(s, ", ");
        int val = -1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (val == -1) {
                try {
                    val = Integer.parseInt(token);
                    continue;
                }
                catch (RuntimeException e) {
                    String msg = "Not a number: " + token;
                    throw new IllegalArgumentException(msg);
                }
            }
            this.setField(token, val);
            val = -1;
        }
        if (val != -1) {
            String msg = "Number without designator found: " + val;
            throw new IllegalArgumentException(msg);
        }
    }

    private void setField(String name, int val) {
        String n = name;
        if (n.endsWith("s")) {
            n = n.substring(0, name.length() - 1);
        }
        for (int i = 0; i < NAMES.length; ++i) {
            String field = NAMES[i];
            if (field == null || !field.equals(n)) continue;
            this.setField(i, val);
            return;
        }
        String msg = "Unknown designator: " + name;
        throw new IllegalArgumentException(msg);
    }

    private int setField(int setteroff, char c, int val) {
        while (setteroff < this.setters.length) {
            FieldSetter setter;
            if ((setter = this.setters[setteroff++]).designator != c) continue;
            if (val == -1) {
                setter.set();
            } else {
                setter.set(val);
            }
            return setteroff;
        }
        String msg = "Not a field designator: " + c;
        throw new IllegalArgumentException(msg);
    }

    static {
        Duration.NAMES[1] = "year";
        Duration.NAMES[2] = "month";
        Duration.NAMES[5] = "day";
        Duration.NAMES[10] = "hour";
        Duration.NAMES[12] = "minute";
        Duration.NAMES[13] = "second";
    }

    class FieldSetter {
        private final char designator;

        public FieldSetter(char designator) {
            this.designator = designator;
        }

        void set() throws IllegalArgumentException {
            String msg = "Field " + this.designator + " must have a value.";
            throw new IllegalArgumentException(msg);
        }

        void set(int value) {
            String msg = "Field " + this.designator + " must not have a value.";
            throw new IllegalArgumentException(msg);
        }
    }
}

