/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.journal;

import com.day.crx.core.journal.Duration;
import com.day.crx.core.journal.LogRotator;
import com.day.crx.core.journal.RotatingLogFile;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogRotator
implements LogRotator {
    private static Logger log = LoggerFactory.getLogger(DefaultLogRotator.class);
    private final File directory;
    private final String basename;
    private Duration maximumAge;
    private int maximumFiles;

    public DefaultLogRotator(File directory, String basename) {
        this.directory = directory;
        this.basename = basename;
    }

    public void setMaximumAge(Duration maximumAge) {
        this.maximumAge = maximumAge;
    }

    public void setMaximumFiles(int maximumFiles) {
        this.maximumFiles = maximumFiles;
    }

    public void rotate() throws IOException {
        long oldestValidTimeMillis = 0L;
        if (this.maximumAge != null) {
            Calendar oldestValidDate = Calendar.getInstance();
            this.maximumAge.subtractFrom(oldestValidDate);
            oldestValidTimeMillis = oldestValidDate.getTimeInMillis();
        }
        RotatingLogFile[] logFiles = RotatingLogFile.listFiles(this.directory, this.basename);
        for (int i = 0; i < logFiles.length; ++i) {
            File file = logFiles[i].getFile();
            if (oldestValidTimeMillis != 0L && file.lastModified() < oldestValidTimeMillis) {
                log.info("Log file " + file.getName() + " is older than maximum age: removed.");
                if (file.delete()) continue;
                log.warn("Unable to remove outdated log file: {}", (Object)file.getName());
                continue;
            }
            if (this.maximumFiles != 0 && logFiles[i].getVersion() >= this.maximumFiles) {
                log.info("Log file " + file.getName() + " exceeds maximum of files: removed.");
                if (file.delete()) continue;
                log.warn("Unable to remove outdated log file: {}", (Object)file.getName());
                continue;
            }
            logFiles[i].rotate();
        }
    }
}

