/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.journal;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.JournalException;

public class CRXFileRevision
extends FileRevision {
    private static final int UNINITIALIZED_VALUE = -1;
    private boolean sharedNothing;

    public CRXFileRevision(File file, boolean sync, boolean sharedNothing) throws JournalException {
        super(file, sync);
        this.value = -1L;
        this.sharedNothing = sharedNothing;
    }

    public synchronized long get() throws JournalException {
        try {
            if (this.closed) {
                throw new JournalException("Revision file closed.");
            }
            if (this.sharedNothing && this.value != -1L) {
                return this.value;
            }
            this.raf.seek(0L);
            this.value = this.raf.readLong();
            return this.value;
        }
        catch (IOException e) {
            throw new JournalException("I/O error occurred.", (Throwable)e);
        }
    }

    public synchronized void set(long value) throws JournalException {
        try {
            if (this.closed) {
                throw new JournalException("Revision file closed.");
            }
            if (this.sharedNothing && this.value == value) {
                return;
            }
            this.raf.seek(0L);
            this.raf.writeLong(value);
            if (this.sync) {
                this.raf.getFD().sync();
            }
            this.value = value;
        }
        catch (IOException e) {
            throw new JournalException("I/O error occurred.", (Throwable)e);
        }
    }
}

