/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.data;

import com.day.crx.core.cluster.OutgoingCall;
import com.day.crx.core.data.CallFactory;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataRecordOutputStream
extends OutputStream {
    private static Logger log = LoggerFactory.getLogger(DataRecordOutputStream.class);
    private final DataIdentifier id;
    private final CallFactory factory;
    private long position;
    private boolean error;
    private boolean closed;

    public DataRecordOutputStream(DataIdentifier id, CallFactory factory) {
        this.id = id;
        this.factory = factory;
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.error && len > 0) {
            try {
                this.writeBytes(this.id, this.position, b, off, len);
                this.position += (long)len;
            }
            catch (IOException e) {
                this.error = true;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBytes(DataIdentifier id, long offset, byte[] data, int off, int len) throws IOException {
        OutgoingCall call = this.factory.newCall(3);
        try {
            DataOutput out = call.getOutput();
            out.writeUTF(id.toString());
            out.writeLong(offset);
            out.writeInt(len);
            out.write(data, off, len);
            call.execute();
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            call.release();
            throw throwable;
        }
        call.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endAddRecord(DataIdentifier id) throws IOException {
        OutgoingCall call = this.factory.newCall(4);
        try {
            DataOutput out = call.getOutput();
            out.writeUTF(id.toString());
            call.execute();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            call.release();
            throw throwable;
        }
        call.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (!this.error) {
                try {
                    this.endAddRecord(this.id);
                }
                catch (IOException e) {
                    log.warn("Unable to end adding record.", (Throwable)e);
                }
            }
            super.close();
            Object var3_2 = null;
            this.closed = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.closed = true;
            throw throwable;
        }
    }
}

