/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.data;

import com.day.crx.core.cluster.ClusterController;
import com.day.crx.core.cluster.ClusterSkeleton;
import com.day.crx.core.cluster.IncomingCall;
import com.day.crx.core.cluster.OutgoingCall;
import com.day.crx.core.data.CallFactory;
import com.day.crx.core.data.ClusterDataStore;
import com.day.crx.core.data.DataRecordInputStream;
import com.day.crx.core.data.DataRecordOutputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterDataStoreSkeleton
implements ClusterSkeleton,
Closeable {
    static Logger log = LoggerFactory.getLogger(ClusterDataStoreSkeleton.class);
    private ClusterController controller;
    private final ClusterDataStore dataStore;
    static final String OBJECT_ID = "datastore";
    static final int OP_READ_BYTES = 1;
    static final int OP_BEGIN_ADD_RECORD = 2;
    static final int OP_WRITE_BYTES = 3;
    static final int OP_END_ADD_RECORD = 4;
    private Map<DataIdentifier, TempDataStoreRecord> tempRecords = Collections.synchronizedMap(new HashMap());

    public ClusterDataStoreSkeleton(ClusterDataStore dataStore, ClusterController controller) {
        this.dataStore = dataStore;
        this.controller = controller;
    }

    public void init() throws IOException {
        this.controller.register(OBJECT_ID, this);
    }

    public boolean onSlave() {
        return this.controller != null && this.controller.isSlave();
    }

    public void close() {
        if (this.controller != null) {
            this.controller.unregister(OBJECT_ID);
        }
    }

    public void activate() {
    }

    public void dispatch(IncomingCall call) throws IOException {
        switch (call.getOperation()) {
            case 1: {
                this.doReadBytes(call);
                return;
            }
            case 2: {
                this.doBeginAddRecord(call);
                return;
            }
            case 3: {
                this.doWriteBytes(call);
                return;
            }
            case 4: {
                this.doEndAddRecord(call);
                return;
            }
        }
        call.error("Unknown operation: " + call.getOperation());
    }

    public void deactivate() {
        this.tempRecords.clear();
    }

    public InputStream getInputStream(DataIdentifier id) {
        CallFactory factory = CallFactory.createOutgoingCallFactory(this.controller, OBJECT_ID);
        return new DataRecordInputStream(id, factory);
    }

    public OutputStream getOutputStream(DataIdentifier id) throws IOException {
        CallFactory factory = CallFactory.createOutgoingCallFactory(this.controller, OBJECT_ID);
        boolean newRecord = this.beginAddRecord(factory, id);
        if (!newRecord) {
            return null;
        }
        return new DataRecordOutputStream(id, factory);
    }

    public OutputStream getOutputStream(DataIdentifier id, String excludedSlaveId) throws IOException {
        CallFactory factory = CallFactory.createBroadcastCallFactory(this.controller, OBJECT_ID, excludedSlaveId);
        boolean newRecord = this.beginAddRecord(factory, id);
        if (!newRecord) {
            return null;
        }
        return new DataRecordOutputStream(id, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginAddRecord(CallFactory factory, DataIdentifier id) throws IOException {
        OutgoingCall call = factory.newCall(2);
        if (!call.hasRecipients()) {
            return false;
        }
        try {
            DataOutput out = call.getOutput();
            out.writeUTF(id.toString());
            if (call.isBroadcast()) {
                call.execute();
                boolean bl = true;
                return bl;
            }
            boolean bl = call.getInput().readBoolean();
            return bl;
        }
        finally {
            call.release();
        }
    }

    public void recordAdded(DataIdentifier id, File file) {
        if (this.onSlave()) {
            this.uploadRecord(id, file);
        } else {
            this.broadcastRecord(id, file, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadRecord(DataIdentifier id, File file) {
        block7: {
            OutputStream out = null;
            BufferedInputStream in = null;
            try {
                out = this.getOutputStream(id);
                if (out == null) {
                    return;
                }
                in = new BufferedInputStream(new FileInputStream(file));
                IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((OutputStream)out);
            }
            catch (IOException e) {
                String msg = "Unable to upload record.";
                log.warn(msg, (Throwable)e);
                break block7;
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly(in);
            }
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastRecord(DataIdentifier id, File file, String excludedSlaveId) {
        BufferedInputStream in;
        OutputStream out;
        block5: {
            out = null;
            in = null;
            out = this.getOutputStream(id, excludedSlaveId);
            if (out != null) break block5;
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly(in);
            return;
        }
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                String msg = "Unable to upload record.";
                log.warn(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly(in);
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadBytes(IncomingCall call) throws IOException {
        InputStream stream = null;
        DataInput in = call.getInput();
        DataOutput out = call.getOutput();
        String id = in.readUTF();
        long position = in.readLong();
        int length = in.readInt();
        try {
            DataRecord record = this.dataStore.getRecord(new DataIdentifier(id));
            stream = record.getStream();
            stream.skip(position);
            byte[] data = new byte[length];
            int read = stream.read(data);
            out.writeInt(read);
            if (read > 0) {
                out.write(data, 0, read);
            }
        }
        catch (DataStoreException e) {
            call.error("Record unavailable " + id + ": " + e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void doBeginAddRecord(IncomingCall call) throws IOException {
        DataInput in = call.getInput();
        DataOutput out = call.getOutput();
        DataIdentifier id = new DataIdentifier(in.readUTF());
        if (this.dataStore.getFile(id).exists()) {
            out.writeBoolean(false);
        } else {
            File tempFile = this.dataStore.newTemporaryFile();
            TempDataStoreRecord tempRecord = new TempDataStoreRecord(tempFile, new FileOutputStream(tempFile));
            this.tempRecords.put(id, tempRecord);
            out.writeBoolean(true);
        }
    }

    private void doWriteBytes(IncomingCall call) throws IOException {
        DataInput in = call.getInput();
        String id = in.readUTF();
        long position = in.readLong();
        int length = in.readInt();
        byte[] data = new byte[length];
        in.readFully(data);
        try {
            TempDataStoreRecord tempRecord = this.tempRecords.get(new DataIdentifier(id));
            if (tempRecord == null) {
                call.error("No temporary file for id: " + id);
                return;
            }
            if (tempRecord.size != position) {
                call.error("Position expected: " + position + ", actual: " + tempRecord.size);
                return;
            }
            tempRecord.tempOut.write(data);
            tempRecord.size += (long)length;
            call.ok();
        }
        catch (IOException e) {
            ClusterDataStore.handleDiskFull(e);
            throw e;
        }
    }

    private void doEndAddRecord(IncomingCall call) throws IOException {
        DataIdentifier id = new DataIdentifier(call.getInput().readUTF());
        String callerId = call.getCallerId();
        try {
            call.ok();
        }
        catch (IOException e) {
            log.warn("Unexpected error: {}", (Object)e.getMessage());
        }
        TempDataStoreRecord tempRecord = this.tempRecords.remove(id);
        if (tempRecord != null) {
            tempRecord.tempOut.close();
            try {
                File file = this.dataStore.addRecord(id, tempRecord.tempFile, tempRecord.tempFile.length());
                if (!this.onSlave()) {
                    this.broadcastRecord(id, file, callerId);
                }
            }
            catch (DataStoreException e) {
                log.error("Unable to add record.", (Throwable)e);
            }
            tempRecord.tempFile.delete();
        }
    }

    private static final class TempDataStoreRecord {
        final File tempFile;
        final FileOutputStream tempOut;
        long size = 0L;

        TempDataStoreRecord(File tempFile, FileOutputStream tempOut) {
            this.tempFile = tempFile;
            this.tempOut = tempOut;
        }
    }
}

