/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.data;

import com.day.crx.core.backup.BackupBarrier;
import com.day.crx.core.backup.LowDiskSpaceMonitor;
import com.day.crx.core.cluster.ClusterController;
import com.day.crx.core.data.ClusterDataStoreSkeleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataRecord;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordConsumer;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterDataStore
extends AbstractDataStore
implements RecordConsumer {
    static Logger log = LoggerFactory.getLogger(ClusterDataStore.class);
    private static final String DIGEST = "SHA-1";
    private static final int DEFAULT_MIN_RECORD_LENGTH = 4096;
    private static final int ACCESS_TIME_RESOLUTION = 2000;
    private static final String TMP = "tmp";
    private static final String PRODUCER_ID = "DS";
    private long minModifiedDate;
    private File directory;
    private String path;
    private int minRecordLength = 4096;
    protected Map<DataIdentifier, WeakReference<DataIdentifier>> inUse = Collections.synchronizedMap(new WeakHashMap());
    private ClusterDataStoreSkeleton skeleton;
    private ClusterNode clusterNode;
    private BackupBarrier barrier;
    private boolean prohibitDownload;
    private final Set<DataIdentifier> currentlyDownloading = new HashSet<DataIdentifier>();

    public void init(String homeDir) throws RepositoryException {
        if (this.path == null) {
            this.path = homeDir + "/repository/datastore";
        }
        this.directory = new File(this.path);
        this.directory.mkdirs();
        this.barrier = new BackupBarrier();
    }

    public void init(ClusterController controller, ClusterNode clusterNode) throws RepositoryException {
        try {
            this.skeleton = new ClusterDataStoreSkeleton(this, controller);
            this.skeleton.init();
        }
        catch (IllegalArgumentException e) {
            String msg = "Unable to register data store in cluster.";
            throw new RepositoryException(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = "Unable to register data store in cluster.";
            throw new RepositoryException(msg, (Throwable)e);
        }
        this.clusterNode = clusterNode;
        if (clusterNode != null) {
            Journal journal = clusterNode.getJournal();
            try {
                journal.register((RecordConsumer)this);
            }
            catch (JournalException e) {
                String msg = "Unable to register consumer in journal.";
                throw new RepositoryException(msg, (Throwable)e);
            }
            try {
                this.preprocessRecords(journal);
            }
            catch (JournalException e) {
                log.error("Unable to preprocess records in journal: {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preprocessRecords(Journal journal) throws JournalException {
        RecordIterator iter = this.clusterNode.getJournal().getRecords(this.getRevision());
        try {
            while (iter.hasNext()) {
                Record record = iter.nextRecord();
                if (!PRODUCER_ID.equals(record.getProducerId())) continue;
                this.consume(record);
            }
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        File file = this.getFile(identifier);
        ClusterDataStore clusterDataStore = this;
        synchronized (clusterDataStore) {
            if (file.exists()) {
                return this.getRecordFromFile(file, identifier);
            }
            if (this.skeleton != null && this.skeleton.onSlave() && !this.prohibitDownload) {
                while (this.currentlyDownloading.contains(identifier)) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException e) {
                        throw new DataStoreException("Interrupted while waiting for " + identifier, (Throwable)e);
                    }
                }
                if (file.exists()) {
                    return this.getRecordFromFile(file, identifier);
                }
            } else {
                return null;
            }
            this.currentlyDownloading.add(identifier);
        }
        try {
            clusterDataStore = this.downloadRecord(identifier);
            return clusterDataStore;
        }
        finally {
            ClusterDataStore clusterDataStore2 = this;
            synchronized (clusterDataStore2) {
                this.currentlyDownloading.remove(identifier);
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    private DataRecord getRecordFromFile(File file, DataIdentifier identifier) throws DataStoreException {
        if (this.minModifiedDate != 0L && file.canWrite() && ClusterDataStore.getLastModified(file) < this.minModifiedDate) {
            ClusterDataStore.setLastModified(file, System.currentTimeMillis() + 2000L);
        }
        this.usesIdentifier(identifier);
        return new FileDataRecord((AbstractDataStore)this, identifier, file);
    }

    void prohibitDownload() {
        this.prohibitDownload = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRecord downloadRecord(DataIdentifier id) throws DataStoreException {
        InputStream is = this.skeleton.getInputStream(id);
        try {
            DataRecord dataRecord = this.addRecordInternal(is, false);
            return dataRecord;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        DataRecord record = this.getRecordIfStored(identifier);
        if (record == null) {
            throw new DataStoreException("Record not found: " + identifier);
        }
        return record;
    }

    private void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    public DataRecord addRecord(InputStream stream) throws DataStoreException {
        return this.addRecordInternal(stream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRecord addRecordInternal(InputStream input, boolean propagate) throws DataStoreException {
        File temporary = null;
        try {
            LowDiskSpaceMonitor.getInstance().checkDiskSpace();
            this.barrier.waitForBackup();
            temporary = this.newTemporaryFile();
            DataIdentifier tempId = new DataIdentifier(temporary.getName());
            this.usesIdentifier(tempId);
            long length = 0L;
            MessageDigest digest = MessageDigest.getInstance(DIGEST);
            DigestOutputStream output = new DigestOutputStream(new FileOutputStream(temporary), digest);
            try {
                length = IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            finally {
                ((OutputStream)output).close();
            }
            DataIdentifier identifier = new DataIdentifier(ClusterDataStore.encodeHexString((byte[])digest.digest()));
            File file = this.addRecord(identifier, temporary, length);
            if (propagate) {
                if (this.skeleton != null) {
                    this.skeleton.recordAdded(identifier, file);
                }
                if (this.clusterNode != null) {
                    this.logToJournal(identifier);
                }
            }
            this.inUse.remove(tempId);
            FileDataRecord fileDataRecord = new FileDataRecord((AbstractDataStore)this, identifier, file);
            return fileDataRecord;
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataStoreException("SHA-1 not available", (Throwable)e);
        }
        catch (IOException e) {
            ClusterDataStore.handleDiskFull(e);
            throw new DataStoreException("Could not add record", (Throwable)e);
        }
        finally {
            if (temporary != null) {
                temporary.delete();
            }
        }
    }

    synchronized File addRecord(DataIdentifier id, File temporary, long length) throws IOException, DataStoreException {
        this.usesIdentifier(id);
        File file = this.getFile(id);
        File parent = file.getParentFile();
        if (!parent.isDirectory()) {
            parent.mkdirs();
        }
        if (file.exists() && file.length() == 0L) {
            file.delete();
        }
        if (!file.exists()) {
            temporary.renameTo(file);
            if (!file.exists()) {
                throw new IOException("Can not rename " + temporary.getAbsolutePath() + " to " + file.getAbsolutePath() + " (media read only?)");
            }
        } else {
            long now = System.currentTimeMillis();
            if (ClusterDataStore.getLastModified(file) < now + 2000L) {
                ClusterDataStore.setLastModified(file, now + 2000L);
            }
        }
        if (!file.isFile()) {
            throw new IOException("Not a file: " + file);
        }
        if (file.length() != length) {
            throw new IOException("SHA-1 collision: " + file);
        }
        return file;
    }

    File getFile(DataIdentifier identifier) {
        this.usesIdentifier(identifier);
        String string = identifier.toString();
        File file = this.directory;
        file = new File(file, string.substring(0, 2));
        file = new File(file, string.substring(2, 4));
        file = new File(file, string.substring(4, 6));
        return new File(file, string);
    }

    File newTemporaryFile() throws IOException {
        if (!this.directory.isDirectory()) {
            this.directory.mkdirs();
        }
        return File.createTempFile(TMP, null, this.directory);
    }

    public void updateModifiedDateOnAccess(long before) {
        this.minModifiedDate = before;
    }

    public int deleteAllOlderThan(long min) {
        return this.deleteOlderRecursive(this.directory, min);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteOlderRecursive(File file, long min) {
        int count = 0;
        if (file.isFile() && file.exists() && file.canWrite()) {
            ClusterDataStore clusterDataStore = this;
            synchronized (clusterDataStore) {
                DataIdentifier id;
                long lastModified;
                try {
                    lastModified = ClusterDataStore.getLastModified(file);
                }
                catch (DataStoreException e) {
                    log.warn("Failed to read modification date; file not deleted", (Throwable)e);
                    lastModified = min;
                }
                if (lastModified < min && !this.inUse.containsKey(id = new DataIdentifier(file.getName()))) {
                    if (log.isInfoEnabled()) {
                        log.info("Deleting old file " + file.getAbsolutePath() + " modified: " + new Timestamp(lastModified).toString() + " length: " + file.length());
                    }
                    if (!file.delete()) {
                        log.warn("Failed to delete old file " + file.getAbsolutePath());
                    }
                    ++count;
                }
            }
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                count += this.deleteOlderRecursive(f, min);
            }
            ClusterDataStore clusterDataStore = this;
            synchronized (clusterDataStore) {
                if (file != this.directory && file.list().length == 0) {
                    file.delete();
                }
            }
        }
        return count;
    }

    private void listRecursive(List<File> list, File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.listRecursive(list, f);
                    continue;
                }
                list.add(f);
            }
        }
    }

    public Iterator<DataIdentifier> getAllIdentifiers() {
        ArrayList<File> files = new ArrayList<File>();
        this.listRecursive(files, this.directory);
        ArrayList<DataIdentifier> identifiers = new ArrayList<DataIdentifier>();
        for (File f : files) {
            String name = f.getName();
            if (name.startsWith(TMP)) continue;
            DataIdentifier id = new DataIdentifier(name);
            identifiers.add(id);
        }
        return identifiers.iterator();
    }

    public void clearInUse() {
        this.inUse.clear();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String directoryName) {
        this.path = directoryName;
    }

    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    public void close() {
        if (this.skeleton != null) {
            this.skeleton.close();
        }
        this.barrier.close();
    }

    private static long getLastModified(File file) throws DataStoreException {
        long lastModified = file.lastModified();
        if (lastModified == 0L) {
            throw new DataStoreException("Failed to read record modified date: " + file.getAbsolutePath());
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLastModified(File file, long time) throws DataStoreException {
        if (!file.setLastModified(time)) {
            if (!file.canWrite()) {
                return;
            }
            try {
                RandomAccessFile r = new RandomAccessFile(file, "rw");
                try {
                    r.setLength(r.length());
                }
                finally {
                    r.close();
                }
            }
            catch (IOException e) {
                ClusterDataStore.handleDiskFull(e);
                throw new DataStoreException("An IO Exception occurred while trying to set the last modified date: " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    static void handleDiskFull(IOException e) {
        LowDiskSpaceMonitor.getInstance().handleDiskFull(e);
    }

    public void consume(Record record) {
        try {
            DataIdentifier id = new DataIdentifier(record.readString());
            this.getRecordIfStored(id);
        }
        catch (JournalException e) {
            String msg = "Unable to read data identifier: " + e.getMessage();
            log.error(msg);
        }
        catch (DataStoreException e) {
            String msg = "Unable to download data with identifier: " + e.getMessage();
            log.error(msg);
        }
    }

    public String getId() {
        return PRODUCER_ID;
    }

    public long getRevision() {
        return this.clusterNode.getRevision();
    }

    public void setRevision(long revision) {
        this.clusterNode.setRevision(revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToJournal(DataIdentifier id) {
        Record record = null;
        boolean succeeded = false;
        try {
            record = this.clusterNode.getJournal().getProducer(PRODUCER_ID).append();
            record.writeString(id.toString());
            record.update();
            this.clusterNode.setRevision(record.getRevision());
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }
}

