/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.data;

import com.day.crx.core.cluster.ClusterController;
import com.day.crx.core.cluster.OutgoingCall;
import com.day.crx.core.data.BroadcastCallFactory;
import com.day.crx.core.data.OutgoingCallFactory;
import java.io.IOException;

public abstract class CallFactory {
    protected final ClusterController controller;
    protected final String objectId;

    protected CallFactory(ClusterController controller, String objectId) {
        this.controller = controller;
        this.objectId = objectId;
    }

    public static CallFactory createOutgoingCallFactory(ClusterController controller, String objectId) {
        return new OutgoingCallFactory(controller, objectId);
    }

    public static CallFactory createBroadcastCallFactory(ClusterController controller, String objectId, String excludedSlaveId) {
        return new BroadcastCallFactory(controller, objectId, excludedSlaveId);
    }

    public abstract OutgoingCall newCall(int var1) throws IOException;
}

