/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.config;

import com.day.crx.core.config.CRXClusterConfig;
import com.day.crx.core.config.CRXConfigurationEntityResolver;
import com.day.crx.core.config.CRXRepositoryConfig;
import com.day.crx.core.config.CRXWorkspaceConfig;
import com.day.crx.core.config.ModuleConfig;
import com.day.crx.persistence.NativePersistenceManager;
import com.day.crx.persistence.tar.TarJournal;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.DataSourceConfig;
import org.apache.jackrabbit.core.config.RepositoryConfigurationParser;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.data.DataStoreFactory;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.journal.JournalFactory;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ISMLockingFactory;
import org.apache.jackrabbit.core.util.RepositoryLockMechanismFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CRXConfigurationParser
extends RepositoryConfigurationParser {
    public static final String MODULES_ELEMENT = "Modules";
    public static final String MODULE_ELEMENT = "Module";
    private static final String PROPERTY_SHARED_PATH = "sharedPath";
    private static final String PROPERTY_SHARED_NOTHING = "sharedNothing";
    private static final String PROPERTY_PREFERRED_MASTER = "preferredMaster";
    private static final String PROPERTY_OUT_OF_SYNC_RECOVERY_ENABLED = "outOfSyncRecoveryEnabled";
    private static final String PROPERTY_BIND_ADDRESS = "bindAddress";
    private static final String PROPERTY_PORT_LIST = "portList";
    private static final String PROPERTY_BECOME_MASTER_ON_TIMEOUT = "becomeMasterOnTimeout";
    public static final String SIMPLE_LOCKING_ATTRIBUTE = "simpleLocking";

    public CRXConfigurationParser(Properties variables) {
        super(variables);
    }

    protected EntityResolver getEntityResolver() {
        return CRXConfigurationEntityResolver.INSTANCE;
    }

    protected Document postParseModificationHook(Document document) {
        try {
            NodeList nodes = document.getElementsByTagName("SearchIndex");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element si = (Element)nodes.item(i);
                if (this.parseParameters(si).getProperty("path") != null) continue;
                si.getElementsByTagName("FileSystem");
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Element fs = (Element)nodes.item(j);
                    String path = this.parseParameters(fs).getProperty("path");
                    if (path == null) continue;
                    Element param = document.createElement("param");
                    param.setAttribute("name", "path");
                    param.appendChild(document.createTextNode(path));
                    si.appendChild(param);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    protected WorkspaceConfig parseWorkspaceConfig(Element root) throws ConfigurationException {
        boolean simpleLocking = false;
        String s = this.getAttribute(root, SIMPLE_LOCKING_ATTRIBUTE, null);
        if (s != null) {
            simpleLocking = Boolean.valueOf(s);
        } else {
            String clazz;
            Element lh = this.getElement(root, "LockHandler", false);
            if (lh != null && "com.day.crx.core.lock.CRXOwnerLockHandler".equals(clazz = this.getAttribute(lh, "class"))) {
                simpleLocking = true;
            }
        }
        final WorkspaceConfig wc = super.parseWorkspaceConfig(root);
        FileSystemFactory fsf = new FileSystemFactory(){

            public FileSystem getFileSystem() throws RepositoryException {
                return wc.getFileSystem();
            }
        };
        ISMLockingFactory ismlf = new ISMLockingFactory(){

            public ISMLocking getISMLocking() throws RepositoryException {
                return wc.getISMLocking();
            }
        };
        return new CRXWorkspaceConfig(wc.getHomeDir(), wc.getName(), wc.isClustered(), fsf, wc.getPersistenceManagerConfig(), (QueryHandlerFactory)(wc.isSearchEnabled() ? wc : null), ismlf, wc.getSecurityConfig(), wc.getImportConfig(), simpleLocking);
    }

    protected BeanConfig parseBeanConfig(Element parent, String name) throws ConfigurationException {
        Element element = this.getElement(parent, name);
        String className = this.getAttribute(element, "class");
        if (className.equals("com.day.crx.persistence.jdbc.BundleHSQLDbPersistenceManager")) {
            className = NativePersistenceManager.class.getName();
        }
        Properties properties = this.parseParameters(element);
        BeanConfig bc = new BeanConfig(className, properties);
        bc.setConnectionFactory(this.connectionFactory);
        return bc;
    }

    protected RepositoryConfigurationParser createSubParser(Properties variables) {
        Properties props = new Properties(this.getVariables());
        props.putAll((Map<?, ?>)variables);
        return new CRXConfigurationParser(props);
    }

    public CRXRepositoryConfig parseRepositoryConfig(InputSource xml) throws ConfigurationException {
        Element root = this.parseXML(xml);
        String home = this.getVariables().getProperty("rep.home");
        FileSystemFactory fsf = this.getFileSystemFactory(root, "FileSystem");
        Element security = this.getElement(root, "Security");
        SecurityConfig securityConfig = this.parseSecurityConfig(security);
        Element workspaces = this.getElement(root, "Workspaces");
        String workspaceDirectory = this.replaceVariables(this.getAttribute(workspaces, "rootPath"));
        String workspaceConfigDirectory = this.getAttribute(workspaces, "configRootPath", null);
        String defaultWorkspace = this.replaceVariables(this.getAttribute(workspaces, "defaultWorkspace"));
        int maxIdleTime = Integer.parseInt(this.getAttribute(workspaces, "maxIdleTime", "0"));
        Element template = this.getElement(root, "Workspace");
        VersioningConfig vc = this.parseVersioningConfig(root);
        QueryHandlerFactory qhf = this.getQueryHandlerFactory(root);
        CRXClusterConfig cc = this.parseClusterConfig(root, new File(home));
        String sharedPath = null;
        if (cc != null) {
            sharedPath = cc.getSharedPath();
        }
        DataStoreFactory dsf = this.getDataStoreFactory(root, sharedPath != null ? sharedPath : home);
        RepositoryLockMechanismFactory rlf = this.getRepositoryLockMechanismFactory(root);
        DataSourceConfig dsc = this.parseDataSourceConfig(root);
        ModuleConfig[] modules = this.parseModuleConfig(root);
        return new CRXRepositoryConfig(home, securityConfig, fsf, workspaceDirectory, workspaceConfigDirectory, defaultWorkspace, maxIdleTime, template, vc, qhf, cc, dsf, rlf, modules, dsc, this.connectionFactory, this);
    }

    protected CRXClusterConfig parseClusterConfig(Element parent, File home) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"Cluster".equals(child.getNodeName())) continue;
            Element element = (Element)child;
            String sharedPath = null;
            boolean preferredMaster = false;
            boolean sharedNothing = false;
            String bindAddress = null;
            String portList = null;
            boolean becomeMasterOnTimeout = false;
            boolean outOfSyncRecoveryEnabled = false;
            Element journal = this.getElement(element, "Journal", false);
            if (journal != null) {
                String s;
                String pm;
                String sn;
                Properties properties;
                BeanConfig config = this.parseBeanConfig(element, "Journal");
                if (config.getClassName().equals(TarJournal.class.getName())) {
                    sharedNothing = true;
                }
                if ((sharedPath = (properties = config.getParameters()).getProperty(PROPERTY_SHARED_PATH)) != null) {
                    sharedPath = this.replaceVariables(sharedPath);
                }
                if ((sn = properties.getProperty(PROPERTY_SHARED_NOTHING)) != null && sn.length() > 0) {
                    sharedNothing = Boolean.parseBoolean(sn);
                }
                if ((pm = properties.getProperty(PROPERTY_PREFERRED_MASTER)) != null) {
                    preferredMaster = Boolean.parseBoolean(this.replaceVariables(pm));
                }
                if ((bindAddress = properties.getProperty(PROPERTY_BIND_ADDRESS)) != null) {
                    bindAddress = this.replaceVariables(bindAddress);
                }
                if ((portList = properties.getProperty(PROPERTY_PORT_LIST)) != null) {
                    portList = this.replaceVariables(portList);
                }
                if ((s = properties.getProperty(PROPERTY_BECOME_MASTER_ON_TIMEOUT)) != null) {
                    becomeMasterOnTimeout = Boolean.parseBoolean(this.replaceVariables(s));
                }
                outOfSyncRecoveryEnabled = this.parseOutOfSyncRecoveryEnabledConfig(properties);
                if (properties.getProperty("revision") == null) {
                    Element param = journal.getOwnerDocument().createElement("param");
                    param.setAttribute("name", "revision");
                    param.setAttribute("value", new File(home, "revision.log").getPath());
                    journal.appendChild(param);
                }
            }
            ClusterConfig jcc = super.parseClusterConfig(parent, home);
            CRXClusterConfig cc = new CRXClusterConfig(jcc.getId(), jcc.getSyncDelay(), (JournalFactory)jcc);
            if (this.getElement(element, "FileSystem", false) != null) {
                cc.setClusterFileSystemFactory(this.getFileSystemFactory(element, "FileSystem"));
            }
            cc.setSharedPath(sharedPath);
            cc.setSharedNothing(sharedNothing);
            cc.setBindAddress(bindAddress);
            cc.setPortList(portList);
            cc.setPreferredMaster(preferredMaster);
            cc.setBecomeMasterOnTimeout(becomeMasterOnTimeout);
            cc.setOutOfSyncRecoveryEnabled(outOfSyncRecoveryEnabled);
            return cc;
        }
        return null;
    }

    private boolean parseOutOfSyncRecoveryEnabledConfig(Properties properties) {
        String outOfSyncRecoveryEnabled = properties.getProperty(PROPERTY_OUT_OF_SYNC_RECOVERY_ENABLED);
        return outOfSyncRecoveryEnabled != null && outOfSyncRecoveryEnabled.length() > 0 ? Boolean.parseBoolean(outOfSyncRecoveryEnabled) : false;
    }

    protected ModuleConfig[] parseModuleConfig(Element parent) throws ConfigurationException {
        ArrayList<ModuleConfig> moduleConfigs = new ArrayList<ModuleConfig>();
        Element modules = this.getElement(parent, MODULES_ELEMENT, false);
        if (modules != null) {
            NodeList children = modules.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element element;
                String className;
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !MODULE_ELEMENT.equals(child.getNodeName()) || (className = this.getAttribute(element = (Element)child, "class")) == null || className.length() == 0) continue;
                Properties properties = this.parseParameters(element);
                moduleConfigs.add(new ModuleConfig(className, properties));
            }
        }
        if (moduleConfigs.size() == 0) {
            return null;
        }
        return moduleConfigs.toArray(new ModuleConfig[moduleConfigs.size()]);
    }
}

