/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.config.ConfigurationEntityResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CRXConfigurationEntityResolver
implements EntityResolver {
    public static final EntityResolver INSTANCE = new CRXConfigurationEntityResolver();
    private final Map<String, String> publicIds = new HashMap<String, String>();
    private final Map<String, String> systemIds = new HashMap<String, String>();

    private CRXConfigurationEntityResolver() {
        this.publicIds.put("-//Day Management AG//DTD CRX 1.4//EN", "repository-1.4.dtd");
        this.systemIds.put("http://www.day.com/dtd/repository-1.4.dtd", "repository-1.4.dtd");
        this.publicIds.put("-//Day Management AG//DTD CRX 2.0//EN", "repository-2.0.dtd");
        this.systemIds.put("http://www.day.com/dtd/repository-2.0.dtd", "repository-2.0.dtd");
        this.publicIds.put("-//Day Management AG//DTD CRX 2.4//EN", "repository-2.4.dtd");
        this.systemIds.put("http://www.day.com/dtd/repository-2.4.dtd", "repository-2.4.dtd");
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream stream;
        String name = this.publicIds.get(publicId);
        if (name != null && (stream = this.getClass().getResourceAsStream(name)) != null) {
            return new InputSource(stream);
        }
        name = this.systemIds.get(systemId);
        if (name != null && (stream = this.getClass().getResourceAsStream(name)) != null) {
            return new InputSource(stream);
        }
        return ConfigurationEntityResolver.INSTANCE.resolveEntity(publicId, systemId);
    }
}

