/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ClosedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaggedDataOutput
implements DataOutput {
    private static final DataOutput CLOSED = new DataOutputStream((OutputStream)ClosedOutputStream.CLOSED_OUTPUT_STREAM);
    private static Logger log = LoggerFactory.getLogger(TaggedDataOutput.class);
    private DataOutput out;

    public TaggedDataOutput(DataOutput out) {
        this.out = out;
    }

    public void write(int b) throws IOException {
        this.writeTag('B', 1);
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.writeTag('B', len);
        this.out.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.writeTag('Z', 0);
        this.out.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.writeTag('B', 1);
        this.out.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.writeTag('S', 0);
        this.out.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.writeTag('C', 0);
        this.out.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.writeTag('I', 0);
        this.out.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.writeTag('J', 0);
        this.out.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.writeTag('F', 0);
        this.out.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.writeTag('D', 0);
        this.out.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        throw new IOException("Not implemented.");
    }

    public void writeChars(String s) throws IOException {
        throw new IOException("Not implemented.");
    }

    public void writeUTF(String str) throws IOException {
        this.writeTag('U', 0);
        this.out.writeUTF(str);
    }

    private void writeTag(char c, int len) throws IOException {
        this.out.write((byte)c);
        if (len != 0) {
            this.writeVarInt(len);
        }
    }

    public void writeVarInt(int n) throws IOException {
        do {
            int v = n & 0x7F;
            if ((n >>>= 7) != 0) {
                v |= 0x80;
            }
            this.out.write(v);
        } while (n != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.out != CLOSED) {
            try {
                try {
                    this.writeTag('X', 0);
                }
                catch (IOException e) {
                    log.warn("Unable to write terminator.", (Throwable)e);
                    Object var3_2 = null;
                    this.out = CLOSED;
                }
                Object var3_1 = null;
                this.out = CLOSED;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.out = CLOSED;
                throw throwable;
            }
        }
    }
}

