/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import com.day.crx.core.cluster.Backlog;
import com.day.crx.core.cluster.DefaultIncomingCall;
import com.day.crx.core.cluster.MsgFormatException;
import com.day.crx.core.cluster.MsgHeader;
import com.day.crx.core.cluster.ReplyHandler;
import com.day.crx.core.cluster.RequestHandler;
import com.day.crx.core.cluster.SocketInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketConnection
implements RequestHandler,
ReplyHandler {
    private static Logger log = LoggerFactory.getLogger(SocketConnection.class);
    private Socket socket;
    private final boolean buffered;
    private DataOutputStream out;
    private DataInputStream in;
    SynchronizedBoolean closed = new SynchronizedBoolean(false);
    private SynchronizedBoolean pingDisabled = new SynchronizedBoolean(false);
    private Backlog<String> backlog = null;
    static final MsgHeader CONNECTION_CLOSED = MsgHeader.newHeader();
    private final HashMap<Integer, Reply> replies = new HashMap();

    public SocketConnection(Socket socket) {
        this(socket, true);
    }

    public SocketConnection(Socket socket, boolean buffered) {
        this.socket = socket;
        this.buffered = buffered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendRequest(String target, int operation, boolean oneWay, long timeoutMs, byte[] body) throws IOException {
        MsgHeader hdr = MsgHeader.newRequestHeader(target, operation, oneWay);
        Reply reply = null;
        if (!oneWay) {
            HashMap<Integer, Reply> hashMap = this.replies;
            synchronized (hashMap) {
                reply = new Reply(hdr.getRequestID());
                this.replies.put(reply.requestID, reply);
            }
        }
        boolean sent = false;
        try {
            this.sendMesage(hdr, body);
            sent = true;
        }
        finally {
            if (!sent && reply != null) {
                HashMap<Integer, Reply> hashMap = this.replies;
                synchronized (hashMap) {
                    this.replies.remove(reply.requestID);
                }
                reply = null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Request (%08X) sent (%s#%d:%d)", hdr.getRequestID(), target, operation, body.length));
        }
        if (reply == null) {
            return new byte[0];
        }
        return reply.receive(timeoutMs);
    }

    public void sendReply(int requestID, int result, String msg, byte[] body) throws IOException {
        MsgHeader hdr = MsgHeader.newReplyHeader(requestID);
        hdr.setResult(result, msg);
        this.sendMesage(hdr, body);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Reply (%08X) sent (%d)", hdr.getRequestID(), body.length));
        }
    }

    private void sendPing() throws IOException {
        if (this.backlog != null) {
            this.backlog.add("Sending ping...");
        }
        this.sendMesage(MsgHeader.newPing(), new byte[0]);
        if (this.backlog != null) {
            this.backlog.add("Ping sent.");
        }
    }

    private void sendPong() throws IOException {
        if (this.backlog != null) {
            this.backlog.add("Sending pong.");
        }
        this.sendMesage(MsgHeader.newPong(), new byte[0]);
        if (this.backlog != null) {
            this.backlog.add("Pong sent.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMesage(MsgHeader hdr, byte[] body) throws IOException {
        DataOutputStream out;
        hdr.setLength(body.length);
        DataOutputStream dataOutputStream = out = this.getOutputStream();
        synchronized (dataOutputStream) {
            hdr.write(out);
            out.write(body);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultIncomingCall doReceiveCall() throws IOException {
        int consecutiveSoTimeouts = 0;
        while (!this.closed.get()) {
            try {
                if (this.backlog != null) {
                    this.backlog.add("Reading next message...");
                }
                MsgHeader hdr = MsgHeader.newHeader();
                byte[] body = hdr.read(this.getInputStream());
                if (this.backlog != null) {
                    this.backlog.add("Message read.");
                }
                consecutiveSoTimeouts = 0;
                if (hdr.isPing()) {
                    if (this.backlog != null) {
                        this.backlog.add("Ping received.");
                    }
                    if (this.pingDisabled.get()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Received ping, sending pong...");
                    }
                    this.sendPong();
                    continue;
                }
                if (hdr.isPong()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Received pong...");
                    }
                    if (this.backlog == null) continue;
                    this.backlog.add("Pong received.");
                    continue;
                }
                if (hdr.isRequest()) {
                    if (this.backlog != null) {
                        this.backlog.add(String.format("Request (%08X) received (%s#%d:%d), exiting loop...", hdr.getRequestID(), hdr.getTarget(), hdr.getOperation(), hdr.getLength()));
                    }
                    return new DefaultIncomingCall(this, hdr.getRequestID(), hdr.getTarget(), hdr.getOperation(), hdr.isOneWay(), body);
                }
                this.handleReply(hdr, body);
            }
            catch (EOFException e) {
                if (this.backlog != null) {
                    this.backlog.add("Caught EOFException...");
                }
                if (this.closed.get()) continue;
                if (this.backlog != null) {
                    this.backlog.add("Remote endpoint closed connection, throwing...");
                }
                throw e;
            }
            catch (SocketTimeoutException e) {
                if (this.backlog != null) {
                    this.backlog.add("Caught SocketTimeoutException...");
                }
                int repliesWaiting = 0;
                HashMap<Integer, Reply> hashMap = this.replies;
                synchronized (hashMap) {
                    repliesWaiting = this.replies.size();
                }
                if (this.pingDisabled.get()) {
                    consecutiveSoTimeouts = 0;
                    continue;
                }
                if (++consecutiveSoTimeouts == 2) {
                    String msg = String.format("Read timed out twice with %d pending requests, sending ping...", repliesWaiting);
                    if (repliesWaiting != 0) {
                        log.warn(msg);
                    } else {
                        log.debug(msg);
                    }
                    this.sendPing();
                    continue;
                }
                if (consecutiveSoTimeouts != 5) continue;
                if (this.backlog != null) {
                    this.backlog.add("Too many consecutive timeouts, throwing...");
                }
                throw e;
            }
            catch (MsgFormatException e) {
                if (this.backlog != null) {
                    this.backlog.add(String.format("Caught MsgFormatException(%s)...", e.getMessage()));
                }
                if (e.isBadMagic()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Bad message format: {}", (Object)e.getMessage());
                    continue;
                }
                log.warn(String.format("Bad message format: %s", e.getMessage()));
            }
            catch (IOException e) {
                if (this.backlog != null) {
                    this.backlog.add(String.format("Caught IOException(%s)...", e.getMessage()));
                }
                if (this.closed.get()) continue;
                if (this.backlog != null) {
                    this.backlog.add("I/O exception occurred while connection still open, throwing...");
                }
                throw e;
            }
            catch (Exception e) {
                if (this.backlog != null) {
                    this.backlog.add(String.format("Unexpected exception occurred (%s), throwing...", e.toString()));
                }
                IOException ioe = new IOException("Unexpected exception while receiving calls");
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (this.backlog != null) {
            this.backlog.add("Exiting loop with no more calls.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReply(MsgHeader hdr, byte[] body) {
        Reply slot = null;
        if (this.backlog != null) {
            this.backlog.add(String.format("Reply (%08X) received (%d), handling...", hdr.getRequestID(), hdr.getLength()));
        }
        HashMap<Integer, Reply> hashMap = this.replies;
        synchronized (hashMap) {
            slot = this.replies.remove(hdr.getRequestID());
        }
        if (slot != null) {
            slot.set(hdr, body);
        } else {
            log.warn("Reply received with no matching request: " + hdr.getRequestID());
        }
        if (this.backlog != null) {
            this.backlog.add("Reply handled.");
        }
    }

    public DefaultIncomingCall receiveCall() throws IOException {
        return this.doReceiveCall();
    }

    private DataOutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("Connection closed");
        }
        if (this.out == null) {
            OutputStream out = this.socket.getOutputStream();
            if (this.buffered) {
                out = new BufferedOutputStream(out);
            }
            this.out = new DataOutputStream(out);
        }
        return this.out;
    }

    private DataInputStream getInputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("Connection closed");
        }
        if (this.in == null) {
            FilterInputStream in = new SocketInputStream(this.socket.getInputStream());
            if (this.buffered) {
                in = new BufferedInputStream(in);
            }
            this.in = new DataInputStream(in);
        }
        return this.in;
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.socket.getInetAddress(), this.socket.getPort());
    }

    void disablePing() {
        this.pingDisabled.set(true);
    }

    public void createBacklog(long ageMs) {
        this.backlog = new Backlog(ageMs);
    }

    public void dumpBacklog() {
        if (this.backlog == null) {
            return;
        }
        log.info("BACKLOG: START");
        Iterator<Backlog.Entry<String>> entries = this.backlog.iterator();
        while (entries.hasNext()) {
            Backlog.Entry<String> entry = entries.next();
            log.info(String.format("BACKLOG: %s: %s", new Timestamp(entry.timeMs).toString(), entry.value));
        }
        log.info("BACKLOG: END");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed.set(true)) {
            return;
        }
        HashMap<Integer, Reply> hashMap = this.replies;
        synchronized (hashMap) {
            for (Reply slot : this.replies.values()) {
                slot.set(CONNECTION_CLOSED, null);
            }
            this.replies.clear();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    class Reply {
        private final Object monitor = new Object();
        final int requestID;
        private MsgHeader hdr;
        private byte[] body;

        public Reply(int requestID) {
            this.requestID = requestID;
        }

        public byte[] receive(long timeoutMs) throws IOException {
            try {
                if (timeoutMs == 0L) {
                    this.waitForReply();
                } else {
                    this.waitForReply(timeoutMs);
                }
            }
            catch (InterruptedException e) {
                InterruptedIOException iioe = new InterruptedIOException("Thread was interrupted.");
                iioe.initCause(e);
                throw iioe;
            }
            if (this.hdr == CONNECTION_CLOSED) {
                throw new InterruptedIOException("Connection closed.");
            }
            if (this.hdr == null) {
                throw new InterruptedIOException(String.format("Operation timed out after %d ms.", timeoutMs));
            }
            switch (this.hdr.getResult()) {
                case 1: {
                    return this.body;
                }
                case 2: {
                    throw new IOException(this.hdr.getMessage());
                }
            }
            throw new IOException("Unexpected result code: " + this.hdr.getResult());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForReply(long timeoutMs) throws InterruptedException {
            Object object = this.monitor;
            synchronized (object) {
                long waitTime = timeoutMs;
                long start = System.currentTimeMillis();
                while (this.hdr == null && !SocketConnection.this.closed.get() && waitTime > 0L) {
                    this.monitor.wait(waitTime);
                    waitTime = timeoutMs - (System.currentTimeMillis() - start);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForReply() throws InterruptedException {
            Object object = this.monitor;
            synchronized (object) {
                while (this.hdr == null && !SocketConnection.this.closed.get()) {
                    this.monitor.wait(0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(MsgHeader hdr, byte[] body) {
            Object object = this.monitor;
            synchronized (object) {
                this.hdr = hdr;
                this.body = body;
                this.monitor.notify();
            }
        }
    }
}

