/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import com.day.crx.core.cluster.MsgFormatException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

class MsgHeader {
    private static final byte[] MAGIC = "DRMP".getBytes();
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final int VERSION = 2;
    private static final int MAX_LENGTH = 0x40000000;
    private static final int FLAG_ONE_WAY = 1;
    private static final int FLAG_PING = 2;
    private static final int FLAG_REQUEST = 4;
    static final int OP_OK = 1;
    static final int OP_FAIL = 2;
    private static int requestIdCounter;
    private byte[] magic;
    private int requestID;
    private int length;
    private int flags;
    private String target;
    private int operation;
    private int result;
    private String msg;
    private static final char[] HEXCHARS;

    private MsgHeader(String target, int operation, boolean oneWay) {
        this.requestID = MsgHeader.nextRequestID();
        this.target = target;
        this.operation = operation;
        if (oneWay) {
            this.flags |= 1;
        }
        this.flags |= 4;
    }

    private MsgHeader(boolean isRequest) {
        if (isRequest) {
            this.flags = 4;
        }
    }

    private MsgHeader(int requestID) {
        this.requestID = requestID;
    }

    public static MsgHeader newRequestHeader(String target, int operation, boolean oneWay) {
        return new MsgHeader(target, operation, oneWay);
    }

    public static MsgHeader newHeader() {
        return new MsgHeader(false);
    }

    public static MsgHeader newPing() {
        MsgHeader hdr = new MsgHeader(true);
        hdr.flags |= 2;
        return hdr;
    }

    public static MsgHeader newPong() {
        MsgHeader hdr = new MsgHeader(false);
        hdr.flags |= 2;
        return hdr;
    }

    public static MsgHeader newReplyHeader(int requestID) {
        return new MsgHeader(requestID);
    }

    public byte[] read(DataInput in) throws IOException {
        this.magic = new byte[4];
        in.readFully(this.magic);
        if (!Arrays.equals(this.magic, MAGIC)) {
            throw new MsgFormatException("Magic bytes expected: " + MsgHeader.byteArrayToString(MAGIC) + ", actual: " + MsgHeader.byteArrayToString(this.magic), true);
        }
        byte version = in.readByte();
        if (version != 2) {
            throw new MsgFormatException("Version expected: 2, actual: " + MsgHeader.byteArrayToString(new byte[]{version}));
        }
        this.flags = in.readByte();
        in.readFully(new byte[2]);
        if (this.isPingOrPong()) {
            return null;
        }
        this.requestID = in.readInt();
        this.length = in.readInt();
        if (this.length < 0 || this.length > 0x40000000) {
            throw new MsgFormatException("Message length out of range from 0 to 1073741824: " + this.length);
        }
        if (this.isRequest()) {
            this.target = in.readUTF();
            this.operation = in.readByte();
        } else {
            byte by = in.readByte();
            this.result = by;
            switch (by) {
                case 1: {
                    break;
                }
                case 2: {
                    this.msg = in.readUTF();
                    break;
                }
                default: {
                    throw new MsgFormatException("Illegal result code: " + this.result);
                }
            }
        }
        byte[] body = new byte[this.length];
        in.readFully(body);
        return body;
    }

    public void write(DataOutput out) throws IOException {
        out.write(MAGIC);
        out.writeByte(2);
        out.writeByte(this.flags);
        out.write(CRLF);
        if (this.isPingOrPong()) {
            return;
        }
        out.writeInt(this.requestID);
        out.writeInt(this.length);
        if (this.isRequest()) {
            out.writeUTF(this.target);
            out.writeByte(this.operation);
        } else {
            out.write(this.result);
            if (this.result == 2) {
                out.writeUTF(this.msg);
            }
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) throws IOException {
        if (length < 0 || length > 0x40000000) {
            throw new MsgFormatException("Message length out of range from 0 to 1073741824: " + length);
        }
        this.length = length;
    }

    public boolean isOneWay() {
        return (this.flags & 1) != 0;
    }

    public void setOneWay(boolean oneWay) {
        this.flags = oneWay ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isPing() {
        return (this.flags & 6) == 6;
    }

    public boolean isPong() {
        return (this.flags & 6) == 2;
    }

    boolean isPingOrPong() {
        return (this.flags & 2) != 0;
    }

    public boolean isRequest() {
        return (this.flags & 4) != 0;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public String getTarget() {
        return this.target;
    }

    public int getOperation() {
        return this.operation;
    }

    public int getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setResult(int result, String msg) {
        this.result = result;
        this.msg = msg;
    }

    private static String byteArrayToString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (byte v : b) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            int n = 0xFF & v;
            buf.append(HEXCHARS[n >> 4]);
            buf.append(HEXCHARS[n & 0xF]);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextRequestID() {
        Class<MsgHeader> clazz = MsgHeader.class;
        synchronized (MsgHeader.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++requestIdCounter;
        }
    }

    static {
        HEXCHARS = "0123456789abcdef".toCharArray();
    }
}

