/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import com.day.crx.core.cluster.OutgoingCall;
import com.day.crx.core.cluster.ProxyDataInput;
import com.day.crx.core.cluster.ProxyDataOutput;
import com.day.crx.core.cluster.RequestHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

class DefaultOutgoingCall
implements OutgoingCall {
    private RequestHandler handler;
    private final String target;
    private final int operation;
    private final boolean oneWay;
    private long timeoutMs;
    private boolean executed;
    private final ByteArrayOutputStream outb = new ByteArrayOutputStream(512);
    ProxyDataOutput out;
    ByteArrayInputStream inb;
    private ProxyDataInput in;

    public DefaultOutgoingCall(RequestHandler handler, String target, int operation) {
        this(handler, target, operation, false);
    }

    public DefaultOutgoingCall(RequestHandler handler, String target, int operation, boolean oneWay) {
        this.handler = handler;
        this.target = target;
        this.operation = operation;
        this.oneWay = oneWay;
    }

    public String getTarget() {
        return this.target;
    }

    public int getOperation() {
        return this.operation;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public long getExecutionTimeout() {
        return this.timeoutMs;
    }

    public void setExecutionTimeout(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public DataOutput getOutput() throws IllegalStateException {
        this.checkConnected();
        this.checkNotExecuted();
        if (this.out == null) {
            this.out = new ProxyDataOutput(new DataOutputStream(this.outb));
        }
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException, IllegalStateException {
        this.checkConnected();
        this.checkNotExecuted();
        try {
            this.doExecute();
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExecute() throws IOException {
        if (!this.executed) {
            try {
                byte[] body = this.handler.sendRequest(this.target, this.operation, this.oneWay, this.timeoutMs, this.outb.toByteArray());
                this.inb = new ByteArrayInputStream(body);
            }
            finally {
                this.executed = true;
            }
        }
    }

    public DataInput getInput() throws IllegalStateException {
        this.checkConnected();
        if (this.in == null) {
            this.in = new ProxyDataInput(null){

                protected DataInput doOpenIn() throws IOException {
                    DefaultOutgoingCall.this.doExecute();
                    if (DefaultOutgoingCall.this.out != null) {
                        DefaultOutgoingCall.this.out.close();
                    }
                    return new DataInputStream(DefaultOutgoingCall.this.inb);
                }
            };
        }
        return this.in;
    }

    public boolean isBroadcast() {
        return false;
    }

    public boolean hasRecipients() {
        return true;
    }

    public void release() throws IllegalStateException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
        this.handler = null;
        if (!this.executed) {
            throw new IllegalStateException("Call not executed.");
        }
    }

    void checkConnected() throws IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("Not connected.");
        }
    }

    void checkNotExecuted() throws IllegalStateException {
        if (this.executed) {
            throw new IllegalStateException("Arguments already transmitted.");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(">");
        buf.append(this.target);
        buf.append('#');
        buf.append(Integer.toString(this.operation));
        return buf.toString();
    }
}

