/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import com.day.crx.core.cluster.IncomingCall;
import com.day.crx.core.cluster.ProxyDataInput;
import com.day.crx.core.cluster.ProxyDataOutput;
import com.day.crx.core.cluster.ReplyHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

class DefaultIncomingCall
implements IncomingCall {
    private ReplyHandler handler;
    private final int requestID;
    private final String target;
    private final int operation;
    private final boolean oneWay;
    private String callerId;
    private boolean replied;
    private ByteArrayInputStream inb;
    private ProxyDataInput in;
    private final ByteArrayOutputStream outb = new ByteArrayOutputStream(512);
    private ProxyDataOutput out;

    public DefaultIncomingCall(ReplyHandler handler, int requestID, String target, int operation, boolean oneWay, byte[] body) {
        this.handler = handler;
        this.requestID = requestID;
        this.target = target;
        this.operation = operation;
        this.oneWay = oneWay;
        this.inb = new ByteArrayInputStream(body);
    }

    public String getCallerId() {
        return this.callerId;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public DataInput getInput() throws IllegalStateException {
        this.checkConnected();
        this.checkNotReplied();
        if (this.in == null) {
            this.in = new ProxyDataInput(new DataInputStream(this.inb));
        }
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ok() throws IOException {
        this.checkConnected();
        this.checkNotReplied();
        try {
            this.reply(1, null);
        }
        finally {
            this.doRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String msg) throws IOException {
        this.checkConnected();
        this.checkNotReplied();
        try {
            this.reply(2, msg);
        }
        finally {
            this.doRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reply(int result, String msg) throws IOException {
        if (!this.replied) {
            try {
                this.doReply(result, msg);
            }
            finally {
                this.replied = true;
            }
        }
    }

    private void doReply(int result, String msg) throws IOException {
        if (!this.oneWay) {
            this.handler.sendReply(this.requestID, result, msg, this.outb.toByteArray());
        }
    }

    public DataOutput getOutput() throws IOException {
        this.checkConnected();
        if (this.out == null) {
            this.out = new ProxyDataOutput(new DataOutputStream(this.outb));
        }
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws IOException {
        try {
            if (this.handler != null && !this.replied) {
                this.reply(1, null);
            }
        }
        finally {
            this.doRelease();
        }
    }

    private void doRelease() {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
        this.handler = null;
    }

    public String getTarget() {
        return this.target;
    }

    public int getOperation() {
        return this.operation;
    }

    void checkConnected() throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected.");
        }
    }

    boolean isConnected() {
        return this.handler != null;
    }

    void checkNotReplied() throws IllegalStateException {
        if (this.hasReplied()) {
            throw new IllegalStateException("Result already transmitted.");
        }
    }

    boolean hasReplied() throws IllegalStateException {
        return this.replied;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("<");
        buf.append(this.target);
        buf.append('#');
        buf.append(Integer.toString(this.operation));
        return buf.toString();
    }
}

