/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import com.day.crx.core.cluster.BroadcastCall;
import com.day.crx.core.cluster.ClusterController;
import com.day.crx.core.cluster.ClusterNodeInfo;
import com.day.crx.core.cluster.DefaultIncomingCall;
import com.day.crx.core.cluster.IncomingCall;
import com.day.crx.core.cluster.OutgoingCall;
import com.day.crx.core.cluster.RequestHandler;
import com.day.crx.core.cluster.SocketConnection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClusterMaster {
    private static final boolean DISABLE_REVERSE_HOST_LOOKUP = Boolean.parseBoolean(System.getProperty("com.day.crx.core.cluster.DisableReverseHostLookup", "false"));
    private static final long DEFAULT_AGE_MS = 10000L;
    static Logger log = LoggerFactory.getLogger(ClusterMaster.class);
    final ClusterController controller;
    private final InetAddress bindaddr;
    private final int[] ports;
    private final int receiveTimeout;
    final String masterId;
    private final String clusterId;
    private final SynchronizedBoolean stopped = new SynchronizedBoolean(false);
    final SynchronizedBoolean blockIncoming = new SynchronizedBoolean(false);
    private final CountDownLatch opening = new CountDownLatch(1);
    private final SynchronizedBoolean listenerStopped = new SynchronizedBoolean(false);
    final Map<String, Slave> slaves = Collections.synchronizedMap(new HashMap());
    final SecureRandom random = new SecureRandom();
    private final ExecutorService socketConnectExecutor;
    private ServerSocket server;
    private final AtomicBoolean potentialMasterDetected = new AtomicBoolean();

    public ClusterMaster(ClusterController controller, InetAddress bindaddr, int[] ports, final String masterId, String clusterId, int receiveTimeout) {
        this.controller = controller;
        this.bindaddr = bindaddr;
        this.ports = ports;
        this.masterId = masterId;
        this.clusterId = clusterId;
        this.receiveTimeout = receiveTimeout;
        this.socketConnectExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName(String.format("Master (%s) - Socket connector", masterId));
                return t;
            }
        });
    }

    public boolean startListener(boolean force) throws IOException {
        this.potentialMasterDetected.set(false);
        IOException last = null;
        for (int port : this.ports) {
            try {
                this.listen(this.bindaddr, port);
                return true;
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (IOException e) {
                last = e;
            }
        }
        if (!force) {
            return false;
        }
        IOException e = new IOException("Could not create a listener on any of the following ports: " + Arrays.toString(this.ports));
        if (last != null) {
            e.initCause(last);
        }
        throw e;
    }

    public void acceptConnections() {
        this.opening.countDown();
    }

    public InetSocketAddress getSocketAddress() {
        if (this.server != null) {
            InetAddress addr = this.server.getInetAddress();
            if (addr.isAnyLocalAddress()) {
                try {
                    addr = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    log.warn("Unable to determine local host name.", (Throwable)e);
                }
            }
            return new InetSocketAddress(addr, this.server.getLocalPort());
        }
        return null;
    }

    public InetAddress getInetAddress() {
        if (this.server != null) {
            return this.server.getInetAddress();
        }
        return null;
    }

    public ClusterNodeInfo[] getSlaveInfos() {
        Collection<Slave> infos = this.slaves.values();
        ClusterNodeInfo[] result = new Slave[infos.size()];
        infos.toArray(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutgoingCall broadcast(String obj, int op, Set<String> exclude) {
        if (exclude == null) {
            exclude = Collections.emptySet();
        }
        ArrayList<SocketConnection> recipients = new ArrayList<SocketConnection>();
        Map<String, Slave> map = this.slaves;
        synchronized (map) {
            for (Slave s : this.slaves.values()) {
                if (exclude.contains(s.getId()) || s.connection == null) continue;
                recipients.add(s.connection);
            }
        }
        return new BroadcastCall(recipients.toArray(new RequestHandler[0]), obj, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        if (this.stopped.set(true)) {
            return false;
        }
        this.stopListener();
        this.socketConnectExecutor.shutdownNow();
        Map<String, Slave> map = this.slaves;
        synchronized (map) {
            for (Slave slave : this.slaves.values()) {
                if (!slave.stop()) continue;
                this.controller.slaveDisconnected(slave.id);
            }
            this.slaves.clear();
        }
        return true;
    }

    void stopListener() {
        if (this.listenerStopped.set(true)) {
            // empty if block
        }
        if (this.server != null) {
            try {
                this.server.close();
                this.server = null;
            }
            catch (IOException e) {
                log.warn("I/O Error on listener shutdown.", (Throwable)e);
            }
        }
    }

    boolean isRunning() {
        return !this.listenerStopped.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockIncomingCalls() {
        if (this.blockIncoming.set(true)) {
            return;
        }
        this.stopListener();
        Map<String, Slave> map = this.slaves;
        synchronized (map) {
            for (Slave slave : this.slaves.values()) {
                slave.blockIncomingCalls();
            }
        }
    }

    private void listen(InetAddress addr, int port) throws IOException {
        final ServerSocket server = new ServerSocket(port, 50, addr);
        Thread t = new Thread(new Runnable(){

            public void run() {
                ClusterMaster.this.acceptLoop(server);
            }
        });
        String name = String.format("Master (%s) [%s:%d] - Listener", this.masterId, addr != null ? addr.toString() : "*", server.getLocalPort());
        t.setName(name);
        t.setDaemon(true);
        t.start();
        try {
            this.controller.attempt(new ClusterController.IOOperation(){

                public void execute() throws IOException {
                    new Socket(server.getInetAddress(), server.getLocalPort()).close();
                }
            }, "Connecting to '" + name + "'");
        }
        catch (IOException e) {
            if (addr != null) {
                throw e;
            }
            final InetAddress loopback = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            this.controller.attempt(new ClusterController.IOOperation(){

                public void execute() throws IOException {
                    new Socket(loopback, server.getLocalPort()).close();
                }
            }, "Connecting to '" + name + "' via looback");
        }
        this.server = server;
    }

    void acceptLoop(ServerSocket server) {
        while (!this.listenerStopped.get()) {
            try {
                final Socket socket = server.accept();
                if (this.blockIncoming.get()) continue;
                try {
                    this.socketConnectExecutor.execute(new Runnable(){

                        public void run() {
                            ClusterMaster.this.connect(socket);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    break;
                }
            }
            catch (SocketException e) {
                if (this.listenerStopped.get()) break;
                log.warn("Error on accepting next request", (Throwable)e);
                break;
            }
            catch (IOException e) {
                log.warn("Error on accepting socket", (Throwable)e);
            }
        }
    }

    void connect(Socket socket) {
        try {
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(this.receiveTimeout);
        }
        catch (IOException e) {
            log.warn("I/O error while setting socket options.", (Throwable)e);
        }
        SocketConnection conn = new SocketConnection(socket);
        try {
            if (this.connect(conn)) {
                return;
            }
        }
        catch (EOFException e) {
            log.debug("Remote endpoint closed while connecting", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("I/O error while processing connect.", (Throwable)e);
        }
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connect(SocketConnection conn) throws IOException {
        boolean bl;
        DefaultIncomingCall call;
        block8: {
            boolean bl2;
            block7: {
                boolean bl3;
                block6: {
                    call = conn.receiveCall();
                    try {
                        String target = call.getTarget();
                        if (!target.equals("")) {
                            call.error("No skeleton found with id: " + target);
                            bl3 = false;
                            Object var6_7 = null;
                            break block6;
                        }
                        switch (call.getOperation()) {
                            case 0: {
                                bl2 = this.login(conn, call);
                                break block7;
                            }
                            default: {
                                call.error("Operation not implemented: " + call.getOperation());
                                bl = false;
                                break;
                            }
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        call.release();
                        throw throwable;
                    }
                }
                call.release();
                return bl3;
            }
            Object var6_8 = null;
            call.release();
            return bl2;
        }
        Object var6_9 = null;
        call.release();
        return bl;
    }

    private boolean login(SocketConnection conn, IncomingCall call) throws IOException {
        DataInput in = call.getInput();
        String slaveId = in.readUTF();
        if (slaveId.equals(this.masterId)) {
            call.error("Slave id is equal to master id: " + this.masterId);
            return false;
        }
        Slave slave = this.slaves.get(slaveId);
        if (slave != null) {
            call.error("Slave already connected: " + slaveId);
            return false;
        }
        String clusterId = in.readUTF();
        if (!clusterId.equals(this.clusterId)) {
            call.error("Expected clusterId: " + this.clusterId + ", actual: " + clusterId);
            return false;
        }
        String os = in.readUTF();
        String hostaddr = in.readUTF();
        InetAddress bindaddr = null;
        if (!hostaddr.equals("*")) {
            try {
                bindaddr = InetAddress.getByName(hostaddr);
                if (!(DISABLE_REVERSE_HOST_LOOKUP || this.controller.isLocalIPAddress(bindaddr) || bindaddr.isReachable(ClusterController.CONNECT_TIMEOUT_MS))) {
                    throw new IOException("Host not reachable after " + ClusterController.CONNECT_TIMEOUT_MS + "ms");
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Rejecting login from slave ''{0}'' with bind address {1} : {2}", slaveId, hostaddr, e.getMessage());
                log.error(msg);
                call.error(msg);
                return false;
            }
        }
        String repositoryHome = in.readUTF();
        boolean canBecomeMaster = in.readBoolean();
        slave = new Slave(slaveId, os, bindaddr, repositoryHome, conn);
        DataOutput out = call.getOutput();
        try {
            if (!this.opening.await(100L, TimeUnit.MILLISECONDS)) {
                if (canBecomeMaster && slaveId.compareTo(this.masterId) > 0) {
                    call.error("You are a potential master, " + slaveId);
                    this.potentialMasterDetected.set(true);
                    this.stopListener();
                    return false;
                }
                out.writeBoolean(true);
                return false;
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.stopped.get()) {
            String msg = MessageFormat.format("Rejecting login from slave ''{0}'' because the master is stopped", slaveId);
            log.info(msg);
            call.error(msg);
            return false;
        }
        out.writeBoolean(false);
        out.writeUTF(this.masterId);
        out.write(slave.getLoginToken());
        this.slaves.put(slaveId, slave);
        slave.start();
        this.controller.setClusteredFlag(this.slaves.size() > 0);
        this.controller.slaveConnected(slaveId, slave.getBindAddress());
        return true;
    }

    AtomicBoolean getPotentialMasterDetected() {
        return this.potentialMasterDetected;
    }

    class Slave
    extends ClusterNodeInfo {
        private final byte[] loginToken;
        private final SynchronizedBoolean stopped;
        SocketConnection connection;
        private final InetAddress bindaddr;
        private final InetAddress addr;
        private final int port;
        private final ExecutorService incomingCallExecutor;

        public Slave(final String slaveId, String os, InetAddress bindaddr, String repositoryHome, SocketConnection connection) {
            super(slaveId, os, null, repositoryHome);
            this.loginToken = new byte[20];
            this.stopped = new SynchronizedBoolean(false);
            this.connection = connection;
            this.bindaddr = bindaddr;
            InetSocketAddress sa = connection.getSocketAddress();
            this.addr = sa.getAddress();
            this.port = sa.getPort();
            ClusterMaster.this.random.nextBytes(this.loginToken);
            this.incomingCallExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    t.setName(String.format("Master (%s) - Call Dispatcher for slave (%s)", ClusterMaster.this.masterId, slaveId));
                    return t;
                }
            });
        }

        public void start() {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    Slave.this.receiveAndDispatch(Slave.this.connection);
                }
            });
            String name = String.format("Master (%s) -> Slave (%s) [%s:%d]", ClusterMaster.this.masterId, this.id, this.addr.getHostAddress(), this.port);
            t.setName(name);
            t.setDaemon(true);
            t.start();
        }

        public byte[] getLoginToken() {
            return this.loginToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        void dispatch(DefaultIncomingCall call) {
            block21: {
                log.debug("Dispatching call on master for slave '{}': {}", (Object)this.id, (Object)call);
                call.setCallerId(this.id);
                String msg = null;
                ClusterMaster.this.controller.dispatch(call);
                Object var5_3 = null;
                try {
                    if (msg != null && call.isConnected() && !call.hasReplied()) {
                        call.error(msg);
                    }
                }
                catch (IOException e2) {
                    log.debug("Error while sending back error response.", (Throwable)e2);
                }
                try {
                    call.release();
                }
                catch (IOException e2) {
                    log.debug("Error while releasing incoming call.", (Throwable)e2);
                }
                break block21;
                {
                    catch (IOException e) {
                        log.info("I/O exception on dispatching request: {}", (Object)e.getMessage());
                        log.debug("Stacktrace", (Throwable)e);
                        msg = e.getMessage();
                        Object var5_4 = null;
                        try {
                            if (msg != null && call.isConnected() && !call.hasReplied()) {
                                call.error(msg);
                            }
                        }
                        catch (IOException e2) {
                            log.debug("Error while sending back error response.", (Throwable)e2);
                        }
                        try {
                            call.release();
                        }
                        catch (IOException e2) {
                            log.debug("Error while releasing incoming call.", (Throwable)e2);
                        }
                        break block21;
                    }
                    catch (Exception e) {
                        log.warn("Unexpected exception on dispatching request", (Throwable)e);
                        msg = e.getMessage();
                        Object var5_5 = null;
                        try {
                            if (msg != null && call.isConnected() && !call.hasReplied()) {
                                call.error(msg);
                            }
                        }
                        catch (IOException e2) {
                            log.debug("Error while sending back error response.", (Throwable)e2);
                        }
                        try {
                            call.release();
                        }
                        catch (IOException e2) {
                            log.debug("Error while releasing incoming call.", (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        if (msg != null && call.isConnected() && !call.hasReplied()) {
                            call.error(msg);
                        }
                    }
                    catch (IOException e2) {
                        log.debug("Error while sending back error response.", (Throwable)e2);
                    }
                    try {
                        call.release();
                    }
                    catch (IOException e2) {
                        log.debug("Error while releasing incoming call.", (Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }

        void receiveAndDispatch(SocketConnection conn) {
            if (conn != null && log.isDebugEnabled()) {
                conn.createBacklog(10000L);
            }
            try {
                DefaultIncomingCall call;
                while (!this.stopped.get() && (call = conn.receiveCall()) != null) {
                    if (ClusterMaster.this.blockIncoming.get()) continue;
                    try {
                        this.incomingCallExecutor.execute(new Runnable(){

                            public void run() {
                                Slave.this.dispatch(call);
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        break;
                    }
                }
                return;
            }
            catch (EOFException e) {
                log.debug("EOF", (Throwable)e);
            }
            catch (IOException e) {
                log.warn("Unexpected I/O failure while receiving incoming calls.", (Throwable)e);
            }
            conn.dumpBacklog();
            if (this.stop()) {
                ClusterMaster.this.controller.slaveDisconnected(this.id);
                ClusterMaster.this.slaves.remove(this.id);
                ClusterMaster.this.controller.setClusteredFlag(ClusterMaster.this.slaves.size() > 0);
            }
        }

        void blockIncomingCalls() {
            this.connection.disablePing();
        }

        public boolean stop() {
            if (this.stopped.set(true)) {
                return false;
            }
            this.incomingCallExecutor.shutdownNow();
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            return true;
        }

        public String getHostname() {
            return this.getBindAddress().getHostName();
        }

        public InetAddress getBindAddress() {
            return this.bindaddr != null ? this.bindaddr : this.addr;
        }

        public String toString() {
            return this.id + " [" + this.addr.getHostAddress() + ":" + this.port + "]";
        }
    }
}

