/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.backup;

import com.day.crx.core.ResourceMonitor;
import com.day.crx.core.backup.LowDiskSpaceMonitor;
import com.day.crx.core.backup.heapdump.HeapDumper;
import com.day.crx.core.backup.heapdump.IbmHeapDumper;
import com.day.crx.core.backup.heapdump.JMapHeapDumper;
import com.day.crx.core.backup.heapdump.SunHotSpotHeapDumper;
import java.io.File;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfMemoryMonitor {
    private static final Logger log = LoggerFactory.getLogger(ResourceMonitor.class);
    private static final boolean DISABLED = Boolean.getBoolean("crx.memoryCheckDisabled");
    private static final int MEMORY_MAX_USAGE = Integer.parseInt(System.getProperty("crx.memoryMaxUsage", "98"));
    private static final int MEMORY_MIN_STDEV = Integer.parseInt(System.getProperty("crx.memoryMinStdev", "1"));
    private static final String HEAP_DUMP_PATH = "crx.heapDumpPath";
    private static final OutOfMemoryMonitor INSTANCE = new OutOfMemoryMonitor(ManagementFactory.getMemoryMXBean(), ManagementFactory.getOperatingSystemMXBean(), ManagementFactory.getRuntimeMXBean(), ManagementFactory.getGarbageCollectorMXBeans(), 100, new SunHotSpotHeapDumper(), new IbmHeapDumper(), new JMapHeapDumper());
    private final MemoryMXBean mem;
    private final OperatingSystemMXBean os;
    private final RuntimeMXBean rt;
    private final List<GarbageCollectorMXBean> gcs;
    private final SimpleDateFormat memoryDumpFileDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final HeapDumper[] dumpers;
    private final Samples usedMemoryRatios;
    private final Samples gcTimeRatios;
    private long lastCpuTime;
    private long lastGcTime;
    private Method getProcessCpuTime;
    private Boolean hasProcessCpuTime;

    public OutOfMemoryMonitor(MemoryMXBean mem, OperatingSystemMXBean os, RuntimeMXBean rt, List<GarbageCollectorMXBean> gcs, int samples, HeapDumper ... dumpers) {
        this.mem = mem;
        this.os = os;
        this.rt = rt;
        this.gcs = gcs;
        this.usedMemoryRatios = new Samples(samples);
        this.gcTimeRatios = new Samples(samples);
        this.lastCpuTime = this.getProcessCpuTime();
        this.lastGcTime = OutOfMemoryMonitor.getCollectionTime(gcs);
        this.dumpers = dumpers;
    }

    private HeapDumper getFirstAvailableDumper() {
        if (this.dumpers != null) {
            for (HeapDumper dumper : this.dumpers) {
                if (dumper.isAvailable()) {
                    return dumper;
                }
                log.warn("Dumper {} cannot be invoked in current running JVM: {}", new Object[]{dumper.getClass().getName(), dumper.hintMessage()});
            }
        }
        log.warn("No dumper is available - please check your settings!");
        return null;
    }

    public static OutOfMemoryMonitor getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAvailableMemory() throws IOException {
        if (DISABLED) {
            return;
        }
        this.takeSample();
        Samples usedMemory = this.getUsedMemoryRatios();
        int meanMemoryUsage = usedMemory.mean();
        if (log.isDebugEnabled()) {
            log.debug("Mean memory usage accross last samples: {}% (stdev: {}, last: {})", new Object[]{meanMemoryUsage, usedMemory.stdev(), usedMemory.last()});
        }
        if (meanMemoryUsage > MEMORY_MAX_USAGE) {
            log.warn("Exceeded max memory threshold of {}%, using {}% (mean)", (Object)MEMORY_MAX_USAGE, (Object)meanMemoryUsage);
            double stdev = usedMemory.stdev();
            if (stdev < (double)MEMORY_MIN_STDEV) {
                log.error("stdev of memory usage samples is {}, which is lower than {}. shutting down", (Object)stdev, (Object)MEMORY_MIN_STDEV);
                HeapDumper dumper = this.getFirstAvailableDumper();
                String heapDumpPath = System.getProperty(HEAP_DUMP_PATH);
                if (dumper != null && heapDumpPath != null) {
                    boolean skipDump = false;
                    File dir = new File(heapDumpPath);
                    if (!dir.exists()) {
                        if (!dir.mkdirs()) {
                            log.error("Impossible to dump Heap Memory to {}, directory cannot be created, please make sure the current user has enough rights.", new Object[]{dir.getAbsolutePath()});
                            skipDump = true;
                        }
                    } else if (!dir.isDirectory()) {
                        log.error("Impossible to dump Heap Memory to {}, {} system property does not point to a valid directory.", new Object[]{dir.getAbsolutePath(), HEAP_DUMP_PATH});
                        skipDump = true;
                    }
                    if (!skipDump) {
                        File target = new File(dir, "heapdump_" + this.memoryDumpFileDateFormat.format(new Date()) + ".hprof");
                        log.info("Generating Heap Memory dump to {}...", new Object[]{target.getPath()});
                        try {
                            dumper.dump(target);
                            log.info("Heap Memory dump {} successfully generated", new Object[]{target.getPath()});
                        }
                        catch (Exception e) {
                            try {
                                log.error("An error occurred while dumping the Heap Memory, caused by {}: {}", new Object[]{e.getClass().getName(), e.getMessage()});
                            }
                            catch (Throwable throwable) {
                                String message = String.format("More than %d usage and stdev less than %d.", MEMORY_MAX_USAGE, MEMORY_MIN_STDEV);
                                LowDiskSpaceMonitor.getInstance().closeRepository(message);
                                throw new IOException(message);
                            }
                            String message = String.format("More than %d usage and stdev less than %d.", MEMORY_MAX_USAGE, MEMORY_MIN_STDEV);
                            LowDiskSpaceMonitor.getInstance().closeRepository(message);
                            throw new IOException(message);
                        }
                        String message = String.format("More than %d usage and stdev less than %d.", MEMORY_MAX_USAGE, MEMORY_MIN_STDEV);
                        LowDiskSpaceMonitor.getInstance().closeRepository(message);
                        throw new IOException(message);
                    }
                }
            }
        }
    }

    private long getProcessCpuTime() {
        if (this.hasProcessCpuTime == null) {
            try {
                this.getProcessCpuTime = this.os.getClass().getMethod("getProcessCpuTime", new Class[0]);
                this.getProcessCpuTime.setAccessible(true);
                this.hasProcessCpuTime = Boolean.TRUE;
            }
            catch (NoSuchMethodException e) {
                this.hasProcessCpuTime = Boolean.FALSE;
            }
        }
        if (this.getProcessCpuTime != null) {
            try {
                long processCpuTimeNs = (Long)this.getProcessCpuTime.invoke((Object)this.os, new Object[0]);
                return processCpuTimeNs / 1000000L;
            }
            catch (Exception e) {
                this.getProcessCpuTime = null;
                this.hasProcessCpuTime = false;
            }
        }
        return this.rt.getUptime();
    }

    private static long getCollectionTime(List<GarbageCollectorMXBean> gcBeans) {
        long collectionTime = 0L;
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            collectionTime += gcBean.getCollectionTime();
        }
        return collectionTime;
    }

    void takeSample() {
        long cpuTime = this.getProcessCpuTime();
        long cpuTimeDelta = cpuTime - this.lastCpuTime;
        if (cpuTimeDelta <= 0L) {
            return;
        }
        long usedMemory = this.mem.getHeapMemoryUsage().getUsed();
        long maxMemory = this.mem.getHeapMemoryUsage().getMax();
        int usedMemoryRatio = (int)(usedMemory * 100L / maxMemory);
        this.usedMemoryRatios.add(usedMemoryRatio);
        long gcTime = OutOfMemoryMonitor.getCollectionTime(this.gcs);
        long gcTimeDelta = gcTime - this.lastGcTime;
        if (gcTimeDelta < 0L) {
            gcTimeDelta = 0L;
        } else if (gcTimeDelta > cpuTimeDelta) {
            gcTimeDelta = cpuTimeDelta;
        }
        int gcTimeRatio = (int)(100L * gcTimeDelta / cpuTimeDelta);
        this.gcTimeRatios.add(gcTimeRatio);
        this.lastCpuTime = cpuTime;
        this.lastGcTime = gcTime;
    }

    public Samples getGcTimeRatios() {
        return this.gcTimeRatios;
    }

    public Samples getUsedMemoryRatios() {
        return this.usedMemoryRatios;
    }

    public static class Samples {
        private int[] samples;
        private int index;
        private int count;
        private int sum;

        public Samples(int size) {
            this.samples = new int[size];
        }

        public void add(int sample) {
            if (this.index == this.samples.length) {
                this.index = 0;
            }
            if (this.count < this.samples.length) {
                ++this.count;
            } else {
                this.sum -= this.samples[this.index];
            }
            this.samples[this.index++] = sample;
            this.sum += sample;
        }

        public int mean() {
            return this.count == 0 ? 0 : this.sum / this.count;
        }

        public int last() {
            if (this.count == 0) {
                return 0;
            }
            int index = (this.index + this.samples.length - 1) % this.samples.length;
            return this.samples[index];
        }

        public double stdev() {
            if (this.count != this.samples.length) {
                return Double.NaN;
            }
            int mean = this.mean();
            double squareSum = 0.0;
            for (int i = 0; i < this.samples.length; ++i) {
                int index = (this.index + i) % this.samples.length;
                int diff = this.samples[index] - mean;
                squareSum += (double)(diff * diff);
            }
            return Math.sqrt(squareSum / (double)(this.count - 1));
        }
    }
}

