/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.backup;

import com.day.crx.core.ResourceMonitor;
import com.day.crx.core.backup.BackupManager;
import com.day.io.disk.DiskSpaceUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileSystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowDiskSpaceMonitor {
    public static final String MINIMUM = "crx.diskSpaceMin";
    public static final String TEST_DIR = "crx.diskSpaceTestDir";
    public static final String BEHAVIOR_OPTION = "crx.onLowDiskSpace";
    public static final String ALLOC_RETRIES_OPTION = "crx.allocRetries";
    public static final String ALLOC_SIZE_OPTION = "crx.allocSize";
    static final Logger LOG;
    private static final Behavior BEHAVIOR;
    private static final LowDiskSpaceMonitor INSTANCE;
    protected long defaultMeasureInterval = DiskSpaceUtil.getInstance().getDefaultMeasureInterval();
    protected long measureInterval = DiskSpaceUtil.getInstance().getDefaultMeasureInterval();
    protected String testDir = System.getProperty("crx.diskSpaceTestDir", ".");
    protected ArrayList<RankedCloseable> closeables = new ArrayList();
    private long lastMeasuredTime;
    private long lastMeasuredAvailable;
    private boolean throwLogged;
    private AtomicBoolean closingRepository = new AtomicBoolean();
    private static final int ALLOC_RETRIES;
    private static final int ALLOC_SIZE;
    private static final String OOM_MESSAGE;
    private SoftReference<byte[]> allocatedMemory;
    private int consecutiveOOMs;

    public static void main(String ... args) {
        String dir = System.getProperty(TEST_DIR, ".");
        while (true) {
            long y;
            long t = System.currentTimeMillis();
            long x = DiskSpaceUtil.getInstance().getAvailableDiskSpaceMB(new File(dir), 0L);
            t = System.currentTimeMillis() - t;
            System.out.println("DiskSpaceUtil.getAvailableDiskSpaceMB: " + x + " (" + t + " ms)");
            t = System.currentTimeMillis();
            try {
                y = FileSystemUtils.freeSpaceKb((String)new File(dir).getAbsolutePath()) / 1024L;
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
                y = -1L;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("FileSystemUtils.freeSpaceKb: " + y + " (" + t + " ms)");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public static LowDiskSpaceMonitor getInstance() {
        return INSTANCE;
    }

    void logError(String message) {
        LOG.error(message);
        System.out.println(message);
        System.out.flush();
        System.err.println(message);
        System.out.flush();
    }

    private long getMinDiskSpace() {
        return Long.decode(System.getProperty(MINIMUM, "100"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Closeable closeable, int rank) {
        LOG.debug("registering closeable: {}", (Object)closeable);
        ArrayList<RankedCloseable> arrayList = this.closeables;
        synchronized (arrayList) {
            this.closeables.add(new RankedCloseable(closeable, rank));
            this.unregister(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Closeable closeable) {
        LOG.debug("unregistering closeable: {}", (Object)closeable);
        ArrayList<RankedCloseable> arrayList = this.closeables;
        synchronized (arrayList) {
            Iterator<RankedCloseable> it = this.closeables.iterator();
            while (it.hasNext()) {
                RankedCloseable ref = it.next();
                Closeable c = (Closeable)ref.get();
                if (c != null && c != closeable) continue;
                it.remove();
            }
        }
    }

    public void checkDiskSpace() throws IOException {
        if (this.measureInterval < 0L) {
            return;
        }
        long minDiskSpace = this.getMinDiskSpace();
        if (minDiskSpace <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.lastMeasuredTime != 0L && now < this.lastMeasuredTime + this.measureInterval) {
            return;
        }
        this.lastMeasuredTime = now;
        boolean throwException = false;
        try {
            throwException = this.checkAvailable(minDiskSpace);
        }
        catch (Exception e) {
            LOG.error("Unexpected error", (Throwable)e);
        }
        if (throwException) {
            throw new IOException("Disk space is low");
        }
    }

    public void handleDiskFull(IOException e) {
        if (BEHAVIOR != Behavior.CLOSE) {
            return;
        }
        String message = e.getMessage();
        boolean diskFull = false;
        if (message != null) {
            if (message.indexOf("There is not enough space on the disk") >= 0) {
                diskFull = true;
            } else if (message.indexOf("Not enough space") >= 0) {
                diskFull = true;
            } else if (message.indexOf("No space left on device") >= 0) {
                diskFull = true;
            }
        }
        if (diskFull) {
            this.closeRepository(0L, 1L);
        }
    }

    private boolean checkAvailable(long minDiskSpace) {
        long available = this.getAvailableDiskSpaceMB();
        if (available < 0L) {
            this.measureInterval = this.defaultMeasureInterval;
            return false;
        }
        if (this.lastMeasuredAvailable == 0L) {
            this.measureInterval = 1000L;
        } else {
            long used = this.lastMeasuredAvailable - available;
            long usedPerSecond = used * 1000L / Math.max(1000L, this.measureInterval);
            if (usedPerSecond <= 0L) {
                this.measureInterval = this.defaultMeasureInterval;
            } else {
                this.measureInterval = (available - minDiskSpace) * 1000L / usedPerSecond / 4L;
                this.measureInterval = Math.min(this.defaultMeasureInterval, this.measureInterval);
            }
        }
        this.lastMeasuredAvailable = available;
        if (available < minDiskSpace * 2L) {
            this.measureInterval = 1000L;
        }
        this.measureInterval = Math.max(this.measureInterval, 1000L);
        if (available > minDiskSpace) {
            return false;
        }
        switch (BEHAVIOR) {
            case WAIT: {
                this.waitForEnoughDiskSpace(minDiskSpace, available);
                return false;
            }
            case THROW: {
                if (!this.throwLogged) {
                    this.logError("Not enough disk space: " + available + " MB available.\n" + "At least " + minDiskSpace + " MB is required.");
                    this.throwLogged = true;
                }
                this.measureInterval = 0L;
                return true;
            }
        }
        this.closeRepository(minDiskSpace, available);
        return true;
    }

    private void closeRepository(long minDiskSpace, long available) {
        this.closeRepository("Not enough disk space: " + available + " MB available.\n" + "At least " + minDiskSpace + " MB is required.\n" + "The repository will be closed now.");
    }

    public void closeRepository(final String msg) {
        if (this.closingRepository.getAndSet(true)) {
            LOG.debug("The repository is closed or closing");
            return;
        }
        Thread closer = new Thread("ClosingThread"){

            public void run() {
                LowDiskSpaceMonitor.this.doCloseRepository(msg);
            }
        };
        try {
            closer.start();
            closer.join();
        }
        catch (InterruptedException e) {
            LOG.debug("Expected InterruptedException during emergency shutdown: ", (Throwable)e);
        }
    }

    void doCloseRepository(String msg) {
        try {
            this.logError(msg);
            if (this.closeables.size() > 0) {
                final AtomicBoolean closeFailed = new AtomicBoolean();
                final AtomicBoolean allClosed = new AtomicBoolean();
                Thread t = new Thread("Close"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        LOG.warn("Closing " + LowDiskSpaceMonitor.this.closeables.size() + " objects");
                        try {
                            ArrayList<RankedCloseable> list;
                            ArrayList<RankedCloseable> arrayList = LowDiskSpaceMonitor.this.closeables;
                            synchronized (arrayList) {
                                list = new ArrayList<RankedCloseable>(LowDiskSpaceMonitor.this.closeables);
                            }
                            Collections.sort(list);
                            for (RankedCloseable closeable : list) {
                                LOG.warn("Closing {}", (Object)closeable);
                                try {
                                    closeable.close();
                                    LOG.warn("Finished closing object {}", (Object)closeable);
                                }
                                catch (IOException e) {
                                    closeFailed.set(true);
                                    LOG.warn("Closing {} failed: ", (Object)closeable, (Object)e);
                                }
                            }
                            arrayList = LowDiskSpaceMonitor.this.closeables;
                            synchronized (arrayList) {
                                LowDiskSpaceMonitor.this.closeables.clear();
                            }
                            allClosed.set(true);
                        }
                        catch (Exception e) {
                            LOG.warn("Closing failed", (Throwable)e);
                        }
                    }
                };
                t.start();
                t.join(30000L);
                if (!closeFailed.get() && allClosed.get()) {
                    LOG.debug("Closed");
                    return;
                }
            }
        }
        catch (Throwable e) {
            LOG.warn("Closing the repository failed: " + e, e);
        }
        try {
            LOG.warn("Calling System.exit now");
            Thread t = new Thread("System exit"){

                public void run() {
                    System.exit(1);
                }
            };
            t.start();
            t.join(30000L);
            LOG.warn("Calling Runtime.halt now");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Runtime.getRuntime().halt(2);
    }

    protected long getAvailableDiskSpaceMB() {
        long x = DiskSpaceUtil.getInstance().getAvailableDiskSpaceMB(new File(this.testDir), 1000L);
        if (x < 0L) {
            try {
                String p = new File(this.testDir).getAbsolutePath();
                x = FileSystemUtils.freeSpaceKb((String)p) / 1024L;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        LOG.debug("Available disk space: " + (x < 0L ? "unknown" : x + " MB"));
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEnoughDiskSpace(final long minDiskSpace, long available) {
        this.logError("Not enough disk space: " + available + " MB available.\n" + "At least " + minDiskSpace + " MB is required.\n" + "Please free up disk space to continue.");
        File block = null;
        try {
            block = File.createTempFile("blockWrites-", null);
            block.deleteOnExit();
            this.logError("To disable checking for this process, please delete the temporary file " + block.getAbsolutePath());
            this.logError("To disable checking in the future, set the system property crx.diskSpaceMin to 0.");
        }
        catch (IOException e) {
            // empty catch block
        }
        final File blockWrites = block;
        try {
            BackupManager.getInstance().executeGuarded(new Runnable(){

                public void run() {
                    while (true) {
                        if (blockWrites != null && !blockWrites.exists()) {
                            LowDiskSpaceMonitor.this.logError("The file was deleted; continuing");
                            LowDiskSpaceMonitor.this.measureInterval = -1L;
                            break;
                        }
                        long nowAvailable = LowDiskSpaceMonitor.this.getAvailableDiskSpaceMB();
                        if (nowAvailable > minDiskSpace) {
                            LowDiskSpaceMonitor.this.logError("Space was freed up (now " + nowAvailable + " MB); continuing");
                            break;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        finally {
            if (blockWrites != null) {
                blockWrites.delete();
            }
        }
    }

    static {
        int val;
        Behavior behavior;
        LOG = LoggerFactory.getLogger(ResourceMonitor.class);
        INSTANCE = new LowDiskSpaceMonitor();
        String setting = BEHAVIOR_OPTION;
        String b = System.getProperty(setting, Behavior.CLOSE.toString());
        try {
            behavior = Behavior.valueOf(b);
        }
        catch (Exception e) {
            LOG.warn("Unsupported value for setting " + setting + ": " + b, (Throwable)e);
            behavior = Behavior.CLOSE;
        }
        BEHAVIOR = behavior;
        b = System.getProperty(ALLOC_RETRIES_OPTION, "6");
        try {
            val = Integer.parseInt(b);
        }
        catch (RuntimeException e) {
            LOG.warn("Unsupported value for setting crx.allocRetries: " + b, (Throwable)e);
            val = 6;
        }
        ALLOC_RETRIES = val;
        b = System.getProperty(ALLOC_SIZE_OPTION, "10000");
        try {
            val = Integer.parseInt(b);
        }
        catch (RuntimeException e) {
            LOG.warn("Unsupported value for setting crx.allocSize: " + b, (Throwable)e);
            val = 10000;
        }
        ALLOC_SIZE = val;
        OOM_MESSAGE = String.format("Less than %d bytes available on %d consecutives tries.", ALLOC_SIZE, ALLOC_RETRIES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RankedCloseable
    extends WeakReference<Closeable>
    implements Comparable<RankedCloseable>,
    Closeable {
        private final int rank;

        public RankedCloseable(Closeable referent, int rank) {
            super(referent);
            this.rank = rank;
        }

        @Override
        public int compareTo(RankedCloseable other) {
            return new Integer(this.rank).compareTo(other.rank);
        }

        @Override
        public void close() throws IOException {
            Closeable c = (Closeable)this.get();
            if (c != null) {
                c.close();
            }
        }

        public String toString() {
            Closeable c = (Closeable)this.get();
            return c == null ? "null" : c.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Behavior {
        CLOSE,
        WAIT,
        THROW;

    }
}

