/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.backup;

import com.day.crx.core.CRXRepositoryImpl;
import com.day.crx.core.backup.Backup;
import com.day.crx.core.backup.BackupListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupManager {
    private static final Logger log = LoggerFactory.getLogger(BackupManager.class);
    private static final BackupManager instance = new BackupManager();
    private final List<BackupListener> listeners = new ArrayList<BackupListener>();
    protected Backup currentBackup = null;
    private int delay = 10;

    public static BackupManager getInstance() {
        return instance;
    }

    private BackupManager() {
    }

    public synchronized boolean isBackupInProgress() {
        return this.currentBackup != null && !this.currentBackup.isFinished();
    }

    public synchronized int getBackupProgress() {
        if (this.isBackupInProgress()) {
            return this.currentBackup.getProgress();
        }
        return 0;
    }

    public synchronized File getBackupTarget() {
        if (this.isBackupInProgress()) {
            return this.currentBackup.getZipFile();
        }
        return null;
    }

    public synchronized Boolean getBackupWasSuccessful() {
        return this.currentBackup == null || this.currentBackup.exception == null;
    }

    public synchronized String getBackupResult() {
        return this.currentBackup == null ? "No backup excecuted so far." : this.currentBackup.getStatusMessage();
    }

    public synchronized void startBackup(CRXRepositoryImpl repository, String target) throws RepositoryException {
        File homeDir = repository.getHomeDir();
        try {
            homeDir = homeDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RepositoryException("Unexpected repository directory: " + homeDir, (Throwable)e);
        }
        this.startBackup(homeDir.getParentFile().getParentFile(), target);
    }

    public synchronized void startBackup(File installDir, String target) throws RepositoryException {
        File targetFile;
        String targetFileName = target;
        if (targetFileName == null || targetFileName.length() == 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");
            targetFileName = "backup-" + df.format(new Date()) + ".zip";
        }
        if (!(targetFile = new File(targetFileName)).isAbsolute()) {
            File targetDir = installDir.getParentFile();
            targetFile = new File(targetDir, targetFileName);
        }
        if (!this.isBackupInProgress()) {
            this.startBackup(installDir, targetFile);
        }
    }

    synchronized Backup startBackup(File installDir, File targetFile) {
        this.currentBackup = new Backup(installDir, targetFile);
        this.currentBackup.setDelay(this.delay);
        this.currentBackup.start();
        return this.currentBackup;
    }

    public synchronized void cancelBackup() {
        if (this.isBackupInProgress()) {
            try {
                this.currentBackup.cancel();
            }
            catch (Exception e) {
                log.warn("Problem cancelling the backup process", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeGuarded(Runnable runnable) {
        this.notifyBeforeBackup();
        try {
            runnable.run();
        }
        finally {
            this.notifyAfterBackup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(BackupListener listener) {
        List<BackupListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(BackupListener listener) {
        List<BackupListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBeforeBackup() {
        BackupListener[] tmp;
        List<BackupListener> list = this.listeners;
        synchronized (list) {
            tmp = this.listeners.toArray(new BackupListener[this.listeners.size()]);
        }
        for (BackupListener b : tmp) {
            b.beforeBackup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAfterBackup() {
        BackupListener[] tmp;
        List<BackupListener> list = this.listeners;
        synchronized (list) {
            tmp = this.listeners.toArray(new BackupListener[this.listeners.size()]);
        }
        for (BackupListener b : tmp) {
            b.afterBackup();
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }
}

