/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.backup;

import com.day.crx.core.backup.BackupManager;
import com.day.crx.core.backup.FileUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Backup {
    protected static Logger log = LoggerFactory.getLogger(Backup.class);
    private static final String IN_PROGRESS_FILE_NAME = "backupInProgress.txt";
    protected static final String[] EXCLUDE_LIST = new String[]{".lock", "listener.properties", "lock.properties", "cluster_node.id", "cq.pid"};
    protected static final String[] APPEND_ONLY_FILE_LIST = new String[]{".*datastore\\/.*", ".*\\.tar$"};
    protected final File installDir;
    protected File tempDir;
    protected File copyTargetDir;
    protected final File target;
    protected final Object monitor = new Object();
    protected volatile boolean finished;
    protected volatile Exception exception;
    protected volatile String statusMsg = "";
    private volatile int progress;
    protected int delay;
    protected int minProgress;
    protected int maxProgress;
    protected volatile boolean canceled;
    boolean createZip;
    private static final long MODIFIED_DISTANCE = 10000L;

    Backup(File installDir, File target) {
        this.installDir = installDir;
        this.target = target;
        this.createZip = target.getName().endsWith(".zip");
        String installDirName = installDir.getAbsolutePath();
        if (!installDirName.endsWith(File.separator)) {
            installDirName = installDirName + File.separator;
        }
        if (target.getAbsolutePath().startsWith(installDirName)) {
            throw new IllegalArgumentException("The target file must be outside the backup folder");
        }
        if (installDirName.startsWith(target.getAbsolutePath())) {
            throw new IllegalArgumentException("The target directory must not be a parent of the install directory");
        }
    }

    void setProgressBorders(int min, int max) {
        this.minProgress = min;
        this.maxProgress = max;
    }

    void cleanUp() throws InterruptedException, IOException {
        if (this.tempDir != null) {
            if (FileUtil.NIO_FILE_COPY) {
                int waitAtMostSeconds = 20;
                int maxRetries = 20;
                int sleepMillis = waitAtMostSeconds * 1000 / maxRetries;
                for (int i = 0; this.tempDir.exists() && i < maxRetries; ++i) {
                    try {
                        FileUtil.delete(this.tempDir);
                        continue;
                    }
                    catch (Exception e) {
                        Thread.sleep(sleepMillis);
                        System.gc();
                    }
                }
            } else {
                FileUtil.delete(this.tempDir);
            }
        }
    }

    void start() {
        Thread worker = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                File backupInProgressFile;
                block26: {
                    long startBackup;
                    block25: {
                        long start;
                        backupInProgressFile = null;
                        startBackup = start = System.currentTimeMillis();
                        Backup.this.statusMsg = "Backup in progress.";
                        try {
                            int copyEndPos;
                            log.info("Backup started.");
                            if (Backup.this.createZip) {
                                Backup.this.createTemporaryDirectory();
                                Backup.this.copyTargetDir = Backup.this.tempDir;
                                copyEndPos = 700;
                            } else {
                                Backup.this.target.mkdirs();
                                Backup.this.copyTargetDir = Backup.this.target;
                                backupInProgressFile = new File(Backup.this.target, Backup.IN_PROGRESS_FILE_NAME);
                                try {
                                    backupInProgressFile.createNewFile();
                                    if (!backupInProgressFile.exists() || !backupInProgressFile.isFile()) {
                                        throw new IOException("Not a file");
                                    }
                                }
                                catch (IOException e) {
                                    log.error("Could not create file " + backupInProgressFile.getAbsolutePath(), (Throwable)e);
                                }
                                copyEndPos = 1000;
                            }
                            Backup.this.setProgressBorders(0, (int)((double)copyEndPos * 0.9));
                            final long size = FileUtil.sumFileSizes(Backup.this.installDir);
                            log.info("Read size ({}) in {}", (Object)FileUtil.readableBytes(size), (Object)FileUtil.readableTime(System.currentTimeMillis() - start));
                            start = System.currentTimeMillis();
                            if (!Backup.this.createZip) {
                                Backup.this.deleteOldFiles();
                                log.info("Deleted old unmatched files in {}", (Object)FileUtil.readableTime(System.currentTimeMillis() - start));
                            }
                            Backup.this.copyFiles(size, 0L, Backup.this.delay, 1);
                            long onlyNewerThan = start - 10000L;
                            start = System.currentTimeMillis();
                            Backup.this.setProgressBorders((int)((double)copyEndPos * 0.9), (int)((double)copyEndPos * 0.95));
                            Backup.this.copyFiles(size, onlyNewerThan, Backup.this.delay, 2);
                            onlyNewerThan = start - 10000L;
                            start = System.currentTimeMillis();
                            Backup.this.setProgressBorders((int)((double)copyEndPos * 0.95), (int)((double)copyEndPos * 0.98));
                            Backup.this.copyFiles(size, onlyNewerThan, Backup.this.delay, 3);
                            final long onlyNewer = start - 10000L;
                            Backup.this.setProgressBorders((int)((double)copyEndPos * 0.98), copyEndPos);
                            BackupManager.getInstance().executeGuarded(new Runnable(){

                                public void run() {
                                    Backup.this.copyFiles(size, onlyNewer, 0, 4);
                                }
                            });
                            if (!Backup.this.canceled && Backup.this.exception == null && Backup.this.createZip) {
                                Backup.this.setProgressBorders(copyEndPos, 1000);
                                start = System.currentTimeMillis();
                                Backup.this.zipFiles(size);
                                log.info("Compressed in {}", (Object)FileUtil.readableTime(System.currentTimeMillis() - start));
                            }
                            Object var14_9 = null;
                            if (!Backup.this.canceled) break block25;
                        }
                        catch (Throwable throwable) {
                            Object var14_10 = null;
                            if (Backup.this.canceled) {
                                log.info("Backup canceled");
                            } else if (Backup.this.exception != null) {
                                log.warn("Backup failed with error", (Throwable)Backup.this.exception);
                                try {
                                    Backup.this.cleanUp();
                                }
                                catch (Exception e) {
                                    log.warn("Can't clean up temporary files", (Throwable)e);
                                }
                            } else {
                                log.info("Backup completed. Finished in {}", (Object)FileUtil.readableTime(System.currentTimeMillis() - startBackup));
                            }
                            if (backupInProgressFile != null && backupInProgressFile.exists()) {
                                backupInProgressFile.delete();
                            }
                            Backup.this.setProgress(1000);
                            Backup.this.statusMsg = Backup.this.canceled ? "Backup canceled" : (Backup.this.exception != null ? "Backup finished with error '" + Backup.this.exception.getMessage() + "'" : "Backup completed");
                            Object object = Backup.this.monitor;
                            synchronized (object) {
                                Backup.this.finished = true;
                                Backup.this.monitor.notifyAll();
                            }
                            throw throwable;
                        }
                        log.info("Backup canceled");
                        break block26;
                    }
                    if (Backup.this.exception != null) {
                        log.warn("Backup failed with error", (Throwable)Backup.this.exception);
                        try {
                            Backup.this.cleanUp();
                        }
                        catch (Exception e) {
                            log.warn("Can't clean up temporary files", (Throwable)e);
                        }
                    } else {
                        log.info("Backup completed. Finished in {}", (Object)FileUtil.readableTime(System.currentTimeMillis() - startBackup));
                    }
                }
                if (backupInProgressFile != null && backupInProgressFile.exists()) {
                    backupInProgressFile.delete();
                }
                Backup.this.setProgress(1000);
                Backup.this.statusMsg = Backup.this.canceled ? "Backup canceled" : (Backup.this.exception != null ? "Backup finished with error '" + Backup.this.exception.getMessage() + "'" : "Backup completed");
                Object object = Backup.this.monitor;
                synchronized (object) {
                    Backup.this.finished = true;
                    Backup.this.monitor.notifyAll();
                }
            }
        }, "Backup Worker Thread");
        worker.start();
    }

    protected void deleteOldFiles() {
        try {
            FileUtil.deleteOld(this.target, this.installDir, new String[]{IN_PROGRESS_FILE_NAME});
        }
        catch (IOException e) {
            log.info("Couldn't delete old files");
            this.exception = e;
        }
    }

    protected void createTemporaryDirectory() {
        try {
            this.tempDir = FileUtil.createTempDirectory("backup.", ".temp", this.target.getParentFile());
        }
        catch (IOException e) {
            log.error("Failed to create temporary directory");
            this.exception = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void copyFiles(long size, long onlyNewerThan, int delay, int stage) {
        if (this.exception != null) return;
        if (this.canceled) {
            return;
        }
        long start = System.currentTimeMillis();
        FileUtil.FileCopyListener copyListener = this.createListener(size, "Copied", delay);
        try {
            try {
                boolean onlyDifferent = !this.createZip;
                FileUtil.copy(this.installDir, this.copyTargetDir, copyListener, onlyNewerThan, onlyDifferent);
            }
            catch (Exception e) {
                log.error("Failed to copy files");
                this.exception = e;
                Object var12_10 = null;
                long done = System.currentTimeMillis() - start;
                log.info("Done stage #" + stage + " in {} with {} delay copied {}, skipped {}.", new Object[]{FileUtil.readableTime(done), delay, FileUtil.readableBytes(copyListener.totalBytesCopied()), FileUtil.readableBytes(copyListener.totalBytesSkipped())});
                return;
            }
            Object var12_9 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            long done = System.currentTimeMillis() - start;
            log.info("Done stage #" + stage + " in {} with {} delay copied {}, skipped {}.", new Object[]{FileUtil.readableTime(done), delay, FileUtil.readableBytes(copyListener.totalBytesCopied()), FileUtil.readableBytes(copyListener.totalBytesSkipped())});
            throw throwable;
        }
        long done = System.currentTimeMillis() - start;
        log.info("Done stage #" + stage + " in {} with {} delay copied {}, skipped {}.", new Object[]{FileUtil.readableTime(done), delay, FileUtil.readableBytes(copyListener.totalBytesCopied()), FileUtil.readableBytes(copyListener.totalBytesSkipped())});
    }

    private FileUtil.FileCopyListener createListener(final long totalSize, final String message, final double delay) {
        return new FileUtil.FileCopyListener(){
            private long completedFilesLength = 0L;
            private long skippedFilesLength = 0L;
            private long currentFileLength;
            private String currentFilePath;

            public boolean canSkip(File file) {
                String fileName = file.getAbsolutePath().replace('\\', '/');
                for (String suffix : EXCLUDE_LIST) {
                    if (!fileName.endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }

            public boolean isReadOnly(File file) {
                String fileName = file.getAbsolutePath().replace('\\', '/');
                for (String ro : APPEND_ONLY_FILE_LIST) {
                    if (!fileName.matches(ro)) continue;
                    return true;
                }
                return false;
            }

            public void copied(long pos, long total) {
                if (Backup.this.canceled) {
                    throw new RuntimeException("Backup canceled");
                }
                this.setPos(pos);
                int millis = (int)delay;
                if (delay != (double)millis && Math.random() <= delay - (double)millis) {
                    ++millis;
                }
                if (millis > 0) {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }

            public void skip() {
                this.skippedFilesLength += this.currentFileLength;
                this.currentFileLength = 0L;
            }

            public void fileCopyEnd() {
                this.completedFilesLength += this.currentFileLength;
            }

            public void fileCopyStart(File src, boolean compress) {
                if (Backup.this.canceled) {
                    throw new RuntimeException("Backup canceled");
                }
                this.currentFilePath = src.getAbsolutePath();
                this.currentFileLength = src.length();
                this.setPos(0L);
                if (log.isDebugEnabled()) {
                    String fileName = src.getAbsolutePath();
                    log.debug(message + " {}. ({}%)", (Object)fileName, (Object)Backup.this.getProgress());
                    Backup.this.statusMsg = message + " " + fileName;
                }
            }

            private void setPos(long pos) {
                Backup.this.setProgress(Backup.this.minProgress + (int)((pos + this.completedFilesLength + this.skippedFilesLength) * (long)(Backup.this.maxProgress - Backup.this.minProgress) / totalSize));
            }

            public void onError(IOException e) {
                log.debug("Could not copy file " + this.currentFilePath + ": " + e, (Throwable)e);
            }

            public long totalBytesCopied() {
                return this.completedFilesLength;
            }

            public long totalBytesSkipped() {
                return this.skippedFilesLength;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFiles(long size) {
        if (this.exception != null || this.canceled) {
            return;
        }
        try {
            String tempZipFile;
            block9: {
                tempZipFile = this.target.getAbsolutePath() + ".temp";
                BufferedOutputStream out = null;
                try {
                    out = new BufferedOutputStream(new FileOutputStream(tempZipFile), 4096);
                    FileUtil.writeZipStream(this.tempDir, out, this.createListener(size, "Compress", this.delay));
                    Object var6_5 = null;
                    if (out == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    if (this.exception != null || this.canceled) {
                        new File(tempZipFile).delete();
                    }
                    throw throwable;
                }
                ((OutputStream)out).close();
            }
            if (this.exception != null || this.canceled) {
                new File(tempZipFile).delete();
            }
            boolean done = new File(tempZipFile).renameTo(this.target);
            if (!done) {
                throw new IOException("Could not rename " + tempZipFile + " to " + this.target.getAbsolutePath());
            }
            FileUtil.delete(this.tempDir);
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    public void cancel() throws InterruptedException, IOException {
        this.canceled = true;
        this.waitUntilFinished();
        this.cleanUp();
    }

    public Exception getException() {
        return this.exception;
    }

    public String getStatusMessage() {
        return this.statusMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this.monitor;
        synchronized (object) {
            return this.finished;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public File getZipFile() {
        return this.target;
    }

    protected void setProgress(int progress) {
        this.progress = Math.max(this.minProgress, Math.min(this.maxProgress, progress));
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilFinished() throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            while (!this.finished) {
                this.monitor.wait(10000L);
            }
        }
    }
}

