/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core;

import com.day.crx.persistence.tar.ClusterOutOfSyncException;
import java.io.File;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryOutOfSyncRecovery {
    private static final String FIVE_MINUTES_ROLLBACK = "-00:05:00";
    private static final String OUT_OF_SYNC_RECOVERY = "Out of sync recovery";
    private static final Logger logger = LoggerFactory.getLogger(RepositoryOutOfSyncRecovery.class);

    public void handleOutOfSyncException(RepositoryException repoException, String homeDir) throws RepositoryException {
        ClusterOutOfSyncException outOfSyncException = this.extractOutOfSyncException(repoException);
        if (outOfSyncException == null) {
            throw repoException;
        }
        String rollback = this.findRollback(outOfSyncException);
        logger.info("Out of sync recovery is rolling back to " + rollback);
        try {
            this.writeRollbackFile(homeDir, rollback);
        }
        catch (IOException e) {
            new RepositoryException("Out of sync recovery failed to create the rollback file", (Throwable)e);
        }
    }

    private ClusterOutOfSyncException extractOutOfSyncException(RepositoryException repoException) {
        Throwable cause = repoException.getCause();
        int depth = 10;
        for (int i = 0; i < depth && cause != null; cause = cause.getCause(), ++i) {
            if (!(cause instanceof ClusterOutOfSyncException)) continue;
            return (ClusterOutOfSyncException)cause;
        }
        return null;
    }

    private String findRollback(ClusterOutOfSyncException outOfSyncException) throws RepositoryException {
        String lastCommonTransaction = outOfSyncException.getLastCommonTransaction();
        if (lastCommonTransaction == null) {
            boolean journal = outOfSyncException.isJournal();
            if (!journal) {
                throw new RepositoryException("Out of sync recovery could not find a common transaction to rollback.");
            }
            logger.info("Out of sync recovery could not find a common transaction but rolling back -00:05:00 for journal.");
            lastCommonTransaction = FIVE_MINUTES_ROLLBACK;
        }
        return lastCommonTransaction;
    }

    private void writeRollbackFile(String homeDir, String rollback) throws IOException {
        File rollbackFile = new File(homeDir, "rollback_to.txt");
        logger.info("Out of sync recovery created rollback file: " + rollbackFile.getPath());
        FileUtils.writeStringToFile((File)rollbackFile, (String)rollback);
    }
}

