/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;

public class IgnoringFileSystem
implements FileSystem {
    private FileSystem fs;
    private boolean ignoring;

    public IgnoringFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    public boolean isIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(boolean ignoring) {
        this.ignoring = ignoring;
    }

    public void init() throws FileSystemException {
    }

    public void createFolder(String folderPath) throws FileSystemException {
        if (!this.ignoring) {
            this.fs.createFolder(folderPath);
        }
    }

    public void deleteFile(String filePath) throws FileSystemException {
        if (!this.ignoring) {
            this.fs.deleteFile(filePath);
        }
    }

    public void deleteFolder(String folderPath) throws FileSystemException {
        if (!this.ignoring) {
            this.fs.deleteFolder(folderPath);
        }
    }

    public OutputStream getOutputStream(String filePath) throws FileSystemException {
        if (!this.ignoring) {
            return this.fs.getOutputStream(filePath);
        }
        return new NullOutputStream();
    }

    public void close() throws FileSystemException {
        this.fs.close();
    }

    public boolean exists(String path) throws FileSystemException {
        return this.fs.exists(path);
    }

    public InputStream getInputStream(String filePath) throws FileSystemException {
        return this.fs.getInputStream(filePath);
    }

    public boolean hasChildren(String path) throws FileSystemException {
        return this.fs.hasChildren(path);
    }

    public boolean isFile(String path) throws FileSystemException {
        return this.fs.isFile(path);
    }

    public boolean isFolder(String path) throws FileSystemException {
        return this.fs.isFolder(path);
    }

    public long lastModified(String path) throws FileSystemException {
        return this.fs.lastModified(path);
    }

    public long length(String filePath) throws FileSystemException {
        return this.fs.length(filePath);
    }

    public String[] list(String folderPath) throws FileSystemException {
        return this.fs.list(folderPath);
    }

    public String[] listFiles(String folderPath) throws FileSystemException {
        return this.fs.listFiles(folderPath);
    }

    public String[] listFolders(String folderPath) throws FileSystemException {
        return this.fs.listFolders(folderPath);
    }
}

