/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core;

import com.day.crx.CRXSession;
import com.day.crx.core.CRXRepositoryImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.commons.iterator.NodeIterable;
import org.apache.jackrabbit.commons.iterator.PropertyIterable;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.UserManagerConfig;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.UnknownPrincipal;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRXSecurityMigration
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(CRXSecurityMigration.class);
    private static final Map<String, List<String>> ACT2PRIV = new HashMap<String, List<String>>();
    private static final String CRX_SYSTEM_WSP_NAME = "crx.system";
    private static final String SECURITY_ROOT_PATH = "/rep:security";
    private static final String PRINCIPALS_PATH = "/rep:security/rep:principals";
    private static final String CQ_MIRROR_GROUP = "cq:MirrorGroup";
    private static final String CQ_MIRROR_USER = "cq:MirrorUser";
    private static final String SLING_NS_URI = "http://sling.apache.org/jcr/sling/1.0";
    private static final String SLING_NS_PREFIX = "sling";
    private static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    private static final String REP_AC = "rep:accessControl";
    private static final String REP_ACTIONS = "rep:actions";
    private static final String REP_GROUP = "rep:Group";
    private static final String REP_GROUPS = "rep:groups";
    private static final String REP_GRANT_PERMISSION = "rep:GrantPermission";
    private static final String REP_ID = "rep:id";
    private static final String REP_MEMBER = "rep:member";
    private static final String REP_PASSWORD = "rep:password";
    private static final String REP_PRINCIPAL = "rep:principal";
    private static final String REP_USER = "rep:User";
    private static final String REP_USERS = "rep:users";
    private static final String REP_USER_ID = "rep:userId";
    private static final String REP_WORKSPACES = "rep:workspaces";
    private static final String USERS_PATH = "/rep:security/rep:principals/rep:users";
    private static final String GROUPS_PATH = "/rep:security/rep:principals/rep:groups";
    private static final String REP_MIGRATED_WSP_NAMES = "rep:migratedWorkspaceNames";
    private static final String SUDOERS_AC = "rep:sudoers/rep:accessControl";
    private final List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    private CRXRepositoryImpl repository;
    private boolean needsMigration = false;
    private CRXSession session;
    private CRXSession securitySession;
    private UserManagerImpl userMgr;
    private NamePathResolver resolver;
    private Node existingUserHome = null;
    private Node existingGroupHome = null;

    protected CRXSecurityMigration(CRXRepositoryImpl repository) throws RepositoryException {
        this.repository = repository;
    }

    public static CRXSecurityMigration create(CRXRepositoryImpl repository) throws RepositoryException {
        CRXSecurityMigration m = new CRXSecurityMigration(repository);
        m.prepare();
        return m;
    }

    protected void prepare() throws RepositoryException {
        String groupsHome;
        try {
            this.securitySession = this.repository.internalGetSystemSession(CRX_SYSTEM_WSP_NAME);
        }
        catch (NoSuchWorkspaceException e) {
            return;
        }
        RepositoryConfig repoConfig = this.repository.getConfig();
        String wspName = repoConfig.getDefaultWorkspaceName();
        if (this.securitySession.getRootNode().hasProperty(REP_MIGRATED_WSP_NAMES)) {
            Value[] values = this.securitySession.getRootNode().getProperty(REP_MIGRATED_WSP_NAMES).getValues();
            ArrayList<String> wspNames = new ArrayList<String>();
            for (Value v : values) {
                wspNames.add(v.getString());
            }
            if (wspNames.contains(wspName)) {
                return;
            }
        }
        if (!this.securitySession.itemExists(PRINCIPALS_PATH)) {
            return;
        }
        this.session = this.repository.internalGetSystemSession(this.repository.getConfig().getDefaultWorkspaceName());
        this.resolver = new DefaultNamePathResolver((Session)this.session);
        long timestamp = System.currentTimeMillis();
        String usersHome = this.getUsersHome();
        if (this.session.itemExists(usersHome)) {
            String movedUserPath = usersHome + "-" + timestamp;
            this.session.getWorkspace().move(usersHome, movedUserPath);
            this.existingUserHome = this.session.getNode(movedUserPath);
        }
        if (this.session.itemExists(groupsHome = this.getGroupsHome())) {
            String movedGroupPath = groupsHome + "-" + timestamp;
            this.session.getWorkspace().move(groupsHome, movedGroupPath);
            this.existingGroupHome = this.session.getNode(movedGroupPath);
        }
        this.needsMigration = true;
    }

    public void rollback() throws RepositoryException {
        if (this.needsMigration) {
            Workspace ws = this.session.getWorkspace();
            if (this.existingUserHome != null) {
                ws.move(this.existingUserHome.getPath(), this.getUsersHome());
            }
            if (this.existingGroupHome != null) {
                ws.move(this.existingGroupHome.getPath(), this.getGroupsHome());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() throws RepositoryException {
        if (!this.needsMigration) {
            return;
        }
        NamespaceRegistry nsReg = this.session.getWorkspace().getNamespaceRegistry();
        try {
            nsReg.getPrefix(SLING_NS_URI);
        }
        catch (NamespaceException e) {
            nsReg.registerNamespace(SLING_NS_PREFIX, SLING_NS_URI);
        }
        this.session = this.session.getSession(this.session.getWorkspace().getName());
        if (this.existingUserHome != null) {
            this.existingUserHome = this.session.getNode(this.existingUserHome.getPath());
        }
        if (this.existingGroupHome != null) {
            this.existingGroupHome = this.session.getNode(this.existingGroupHome.getPath());
        }
        this.userMgr = (UserManagerImpl)this.session.getUserManager();
        boolean isAutoSave = this.userMgr.isAutoSave();
        try {
            Workspace ws = this.session.getWorkspace();
            this.userMgr.autoSave(true);
            ProgressListener pl = new ProgressListener(){

                public void migrated(Authorizable auth, String fromPath) {
                    try {
                        String toPath = "?";
                        Principal p = auth.getPrincipal();
                        if (p instanceof ItemBasedPrincipal) {
                            toPath = ((ItemBasedPrincipal)p).getPath();
                        }
                        log.info("migrated {} from {} to {}", new Object[]{auth.getID(), fromPath, toPath});
                    }
                    catch (RepositoryException e) {
                        log.warn("exception while reading from Authorizable", (Throwable)e);
                    }
                }
            };
            this.addListener(pl);
            try {
                Node root;
                log.info("Migrating access control for workspace {}", (Object)ws.getName());
                CRXSession s = this.session.getSession(ws.getName());
                try {
                    this.traverse(s.getRootNode(), this.resolver.getJCRName(NT_REP_ACCESS_CONTROLLABLE), new ACMigration(s));
                }
                finally {
                    s.logout();
                }
                Node principalsRoot = this.securitySession.getNode(PRINCIPALS_PATH);
                if (principalsRoot.hasNode(REP_USERS)) {
                    Node users = principalsRoot.getNode(REP_USERS);
                    this.traverse(users, REP_USER, new CreateUsers());
                    this.traverse(users, REP_USER, new AssignImpersonators());
                }
                if (principalsRoot.hasNode(REP_GROUPS)) {
                    Node groups = principalsRoot.getNode(REP_GROUPS);
                    this.traverse(groups, REP_GROUP, new CreateGroups());
                    this.traverse(groups, REP_GROUP, new AssignMembers());
                }
                if ((root = this.securitySession.getRootNode()).hasNode(REP_WORKSPACES)) {
                    Node workspaces = root.getNode(REP_WORKSPACES);
                    for (Node wsp : new NodeIterable(workspaces.getNodes())) {
                        new AssignWorkspaceAccess().run(wsp);
                    }
                }
            }
            finally {
                this.removeListener(pl);
            }
            ArrayList<Value> wspNames = new ArrayList<Value>();
            if (this.securitySession.getRootNode().hasProperty(REP_MIGRATED_WSP_NAMES)) {
                wspNames.addAll(Arrays.asList(this.securitySession.getRootNode().getProperty(REP_MIGRATED_WSP_NAMES).getValues()));
            }
            wspNames.add(this.securitySession.getValueFactory().createValue(ws.getName()));
            this.securitySession.getRootNode().setProperty(REP_MIGRATED_WSP_NAMES, wspNames.toArray(new Value[wspNames.size()]));
            this.securitySession.save();
        }
        finally {
            this.userMgr.autoSave(isAutoSave);
            this.session.logout();
        }
    }

    public void addListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    private static void copyProperties(Node node, Authorizable authorizable) throws RepositoryException {
        for (Property p : new PropertyIterable(node.getProperties())) {
            PropertyDefinition def = p.getDefinition();
            if (def.isProtected() || p.getType() == 9) continue;
            String name = p.getName();
            try {
                if (p.isMultiple()) {
                    authorizable.setProperty(name, p.getValues());
                    continue;
                }
                authorizable.setProperty(name, p.getValue());
            }
            catch (ConstraintViolationException e) {}
        }
    }

    private void deleteAuthorizableNode(String authId) throws RepositoryException {
        try {
            this.getNodeForAuthorizable(authId).remove();
            this.session.save();
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    private Node getNodeForAuthorizable(String authId) throws RepositoryException {
        String uuid;
        try {
            uuid = UUID.nameUUIDFromBytes(authId.toLowerCase().getBytes("UTF-8")).toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException((Throwable)e);
        }
        return this.session.getNodeByIdentifier(uuid);
    }

    private String getGroupsHome() {
        Properties params = this.getUserManagerConfig().getParameters();
        return params.getProperty("groupsPath");
    }

    private String getUsersHome() {
        Properties params = this.getUserManagerConfig().getParameters();
        return params.getProperty("usersPath");
    }

    private UserManagerConfig getUserManagerConfig() {
        return this.repository.getConfig().getSecurityConfig().getSecurityManagerConfig().getUserManagerConfig();
    }

    protected static String getRelativeHomePath(String name) {
        String ip = "0-9";
        char first = Character.toLowerCase(name.charAt(0));
        if (first >= 'a' && first <= 'z') {
            ip = String.valueOf(first);
        }
        return ip + "/" + name;
    }

    protected static String getIntermediatePath(Node authNode, String prefixPath) throws RepositoryException {
        int prefixLen;
        String[] authPathSegments = Text.explode((String)authNode.getPath(), (int)47);
        String[] interPathSegments = new String[authPathSegments.length - ((prefixLen = Text.explode((String)prefixPath, (int)47).length) + 1)];
        if (interPathSegments.length == 0) {
            return "";
        }
        System.arraycopy(authPathSegments, prefixLen, interPathSegments, 0, interPathSegments.length);
        return Text.implode((String[])interPathSegments, (String)"/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreHome(Authorizable auth, String authPathPrefix, Node previousAuthHome) throws RepositoryException {
        Principal principal = auth.getPrincipal();
        if (principal instanceof ItemBasedPrincipal) {
            String path = ((ItemBasedPrincipal)principal).getPath();
            Session s = previousAuthHome.getSession();
            if (!s.nodeExists(path)) {
                log.warn("Unable to get user node for principal {}", (Object)principal.getName());
                return;
            }
            Node destHome = s.getNode(path);
            if (!previousAuthHome.hasNode(path = path.substring(authPathPrefix.length() + 1)) && !previousAuthHome.hasNode(path = CRXSecurityMigration.getRelativeHomePath(auth.getID()))) {
                Value[] values;
                if (auth.hasProperty(REP_ID) && (values = auth.getProperty(REP_ID)).length > 0) {
                    path = CRXSecurityMigration.getRelativeHomePath(values[0].getString());
                }
                if (!previousAuthHome.hasNode(path)) {
                    log.info("No previous home node found for {}", (Object)destHome.getPath());
                    return;
                }
            }
            Node srcHome = previousAuthHome.getNode(path);
            boolean success = false;
            try {
                log.info("Restoring previous home content for {}", (Object)destHome.getPath());
                CRXSecurityMigration.restoreHome(srcHome, destHome);
                s.save();
                success = true;
            }
            finally {
                if (!success) {
                    s.refresh(false);
                }
            }
        } else {
            log.error("Migration of existing home node failed. Cannot get path for authorizable {}. Principal is not item based.", (Object)auth.getID());
        }
    }

    protected static void restoreHome(Node src, Node dest) throws RepositoryException {
        Session session = src.getSession();
        NodeTypeManager ntMgr = session.getWorkspace().getNodeTypeManager();
        PropertyIterator it = src.getProperties();
        while (it.hasNext()) {
            CRXSecurityMigration.copy(it.nextProperty(), dest);
        }
        dest.setProperty(SLING_RESOURCE_TYPE, REP_USER);
        it = src.getNodes();
        while (it.hasNext()) {
            String primaryType;
            Node child = it.nextNode();
            if (child.getDefinition().isProtected() || !ntMgr.hasNodeType(primaryType = child.getProperty("jcr:primaryType").getString()) || primaryType.equals(CQ_MIRROR_USER) || primaryType.equals(CQ_MIRROR_GROUP)) continue;
            session.move(child.getPath(), dest.getPath() + "/" + child.getName());
        }
        AccessControlManager acMgr = session.getAccessControlManager();
        AccessControlPolicy[] srcPolicies = acMgr.getPolicies(src.getPath());
        JackrabbitAccessControlList srcACL = CRXSecurityMigration.getACLFromPolicies(srcPolicies);
        if (srcACL == null) {
            return;
        }
        AccessControlPolicy[] destPolicies = acMgr.getPolicies(dest.getPath());
        JackrabbitAccessControlList destACL = CRXSecurityMigration.getACLFromPolicies(destPolicies);
        if (destACL == null) {
            AccessControlPolicy acp;
            AccessControlPolicyIterator it2 = acMgr.getApplicablePolicies(dest.getPath());
            while (it2.hasNext() && (destACL = CRXSecurityMigration.getACLFromPolicies(acp = it2.nextAccessControlPolicy())) == null) {
            }
        }
        if (destACL == null) {
            return;
        }
        HashSet<String> principalNames = new HashSet<String>();
        for (AccessControlEntry ace : destACL.getAccessControlEntries()) {
            principalNames.add(ace.getPrincipal().getName());
        }
        for (AccessControlEntry ace : srcACL.getAccessControlEntries()) {
            if (principalNames.contains(ace.getPrincipal().getName())) continue;
            UnknownPrincipal p = new UnknownPrincipal(ace.getPrincipal().getName());
            boolean allow = true;
            if (ace instanceof JackrabbitAccessControlEntry) {
                allow = ((JackrabbitAccessControlEntry)ace).isAllow();
            }
            destACL.addEntry((Principal)p, ace.getPrivileges(), allow, CRXSecurityMigration.getRestrictions(ace));
        }
        acMgr.setPolicy(dest.getPath(), (AccessControlPolicy)destACL);
    }

    protected static Map<String, Value> getRestrictions(AccessControlEntry ace) throws RepositoryException {
        HashMap<String, Value> restrictions = new HashMap<String, Value>();
        if (ace instanceof JackrabbitAccessControlEntry) {
            JackrabbitAccessControlEntry jace = (JackrabbitAccessControlEntry)ace;
            for (String name : jace.getRestrictionNames()) {
                restrictions.put(name, jace.getRestriction(name));
            }
        }
        return restrictions;
    }

    protected static JackrabbitAccessControlList getACLFromPolicies(AccessControlPolicy ... policies) throws RepositoryException {
        for (AccessControlPolicy acp : policies) {
            if (!(acp instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)acp;
        }
        return null;
    }

    public static Property copy(Property src, Node dstParent) throws RepositoryException {
        if (!src.getDefinition().isProtected()) {
            String name = src.getName();
            if (dstParent.hasProperty(name)) {
                return null;
            }
            if (src.getDefinition().isMultiple()) {
                return dstParent.setProperty(name, src.getValues());
            }
            return dstParent.setProperty(name, src.getValue());
        }
        return null;
    }

    protected void notifyMigrated(Authorizable auth, String fromPath) {
        for (ProgressListener listener : this.listeners) {
            listener.migrated(auth, fromPath);
        }
    }

    protected void traverse(Node node, String typeName, Task task) throws RepositoryException {
        ArrayList<String> types = new ArrayList<String>();
        types.add(node.getProperty("jcr:primaryType").getString());
        if (node.hasProperty("jcr:mixinTypes")) {
            Value[] values;
            for (Value v : values = node.getProperty("jcr:mixinTypes").getValues()) {
                types.add(v.getString());
            }
        }
        for (String type : types) {
            if (!type.equals(typeName)) continue;
            task.run(node);
            break;
        }
        NodeIterator children = node.getNodes();
        while (children.hasNext()) {
            this.traverse(children.nextNode(), typeName, task);
        }
    }

    protected String getGroupPrincipalName(Node groupNode) throws RepositoryException {
        String principalName = null;
        if (groupNode.hasProperty(this.resolver.getJCRName(P_PRINCIPAL_NAME))) {
            principalName = groupNode.getProperty(this.resolver.getJCRName(P_PRINCIPAL_NAME)).getString();
        }
        if (principalName == null && groupNode.hasProperty(REP_ID)) {
            principalName = groupNode.getProperty(REP_ID).getString();
        }
        if (principalName == null) {
            principalName = Text.unescapeIllegalJcrChars((String)groupNode.getName());
        }
        return principalName;
    }

    protected String getUserPrincipalName(Node userNode) throws RepositoryException {
        String userId = userNode.getProperty(REP_USER_ID).getString();
        String principalName = null;
        if (userNode.hasProperty(this.resolver.getJCRName(P_PRINCIPAL_NAME))) {
            principalName = userNode.getProperty(this.resolver.getJCRName(P_PRINCIPAL_NAME)).getString();
        }
        if (principalName == null) {
            principalName = userId;
        }
        return principalName;
    }

    static {
        InputStream in = null;
        String config = System.getProperty("crx.security.migration.config");
        if (config != null) {
            try {
                in = new FileInputStream(config);
            }
            catch (FileNotFoundException e) {
                log.warn("{} does not exist. Using default security migration config.", (Object)config);
            }
        }
        if (in == null) {
            in = CRXSecurityMigration.class.getResourceAsStream("security_migration.properties");
        }
        try {
            Properties props = new Properties();
            props.load(in);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String action = (String)entry.getKey();
                ArrayList<String> privileges = new ArrayList<String>();
                for (String priv : Text.explode((String)((String)entry.getValue()), (int)44)) {
                    privileges.add(priv.trim());
                }
                ACT2PRIV.put(action, privileges);
            }
        }
        catch (IOException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    private static class TmpEntry {
        private final Principal principal;
        private final Privilege[] privileges;
        private final boolean isAllow;

        private TmpEntry(Principal principal, Privilege[] privileges, boolean isAllow) {
            this.principal = principal;
            this.privileges = privileges;
            this.isAllow = isAllow;
        }
    }

    protected static class ACMigration
    implements Task {
        protected final CRXSession session;
        protected final NamePathResolver resolver;
        protected final JackrabbitAccessControlManager acMgr;
        protected final PrincipalManager principalMgr;

        public ACMigration(CRXSession session) throws RepositoryException {
            this.session = session;
            this.resolver = new DefaultNamePathResolver((Session)session);
            this.acMgr = (JackrabbitAccessControlManager)session.getAccessControlManager();
            this.principalMgr = session.getPrincipalManager();
        }

        public void run(Node context) throws RepositoryException {
            if (context.hasNode(CRXSecurityMigration.REP_AC)) {
                log.info("migrating access control on {}", (Object)context.getPath());
                JackrabbitAccessControlList acl = null;
                AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(context.getPath());
                while (it.hasNext()) {
                    AccessControlPolicy acp = it.nextAccessControlPolicy();
                    if (!(acp instanceof JackrabbitAccessControlList)) continue;
                    acl = (JackrabbitAccessControlList)acp;
                    break;
                }
                if (acl == null) {
                    for (AccessControlPolicy acp : this.acMgr.getPolicies(context.getPath())) {
                        if (!(acp instanceof JackrabbitAccessControlList)) continue;
                        acl = (JackrabbitAccessControlList)acp;
                        break;
                    }
                }
                if (acl == null) {
                    log.warn("Unable to get/create ACL for node at path '{}'", (Object)context.getPath());
                    return;
                }
                ArrayList<TmpEntry> entries = new ArrayList<TmpEntry>();
                Node ac = context.getNode(CRXSecurityMigration.REP_AC);
                for (Node perm : new NodeIterable(ac.getNodes())) {
                    Value[] actions;
                    String type = perm.getProperty("jcr:primaryType").getString();
                    boolean allow = type.equals(CRXSecurityMigration.REP_GRANT_PERMISSION);
                    String principalName = perm.getProperty(CRXSecurityMigration.REP_PRINCIPAL).getString();
                    Principal principal = this.principalMgr.getPrincipal(principalName);
                    if (principal == null) {
                        principal = new UnknownPrincipal(principalName);
                    }
                    try {
                        actions = perm.getProperty(CRXSecurityMigration.REP_ACTIONS).getValues();
                    }
                    catch (ValueFormatException e) {
                        actions = new Value[]{perm.getProperty(CRXSecurityMigration.REP_ACTIONS).getValue()};
                    }
                    ArrayList<Privilege> privileges = new ArrayList<Privilege>();
                    for (Value act : actions) {
                        String action = act.getString();
                        Privilege[] privs = this.getPrivilegesForAction(action);
                        if (privs != null) {
                            privileges.addAll(Arrays.asList(privs));
                            continue;
                        }
                        if (action.equals("sudo") || action.equals("workspaceAccess")) continue;
                        log.warn("Unable to map action '{}' to JSR 283 privilege", (Object)act.getString());
                    }
                    if (log.isInfoEnabled()) {
                        StringBuilder actionStr = new StringBuilder("[");
                        String sep = "";
                        for (Value act : actions) {
                            actionStr.append(sep);
                            actionStr.append(act.getString());
                            sep = ", ";
                        }
                        actionStr.append("]");
                        StringBuilder privStr = new StringBuilder("[");
                        sep = "";
                        for (Privilege priv : privileges) {
                            privStr.append(sep);
                            privStr.append(priv.getName());
                            sep = ", ";
                        }
                        privStr.append("]");
                        log.info("{} {}, mapped {} to {}", new Object[]{allow ? "allow" : "deny", principalName, actionStr, privStr});
                    }
                    if (privileges.isEmpty()) continue;
                    entries.add(0, new TmpEntry(principal, privileges.toArray(new Privilege[privileges.size()]), allow));
                }
                if (!entries.isEmpty()) {
                    for (TmpEntry entry : entries) {
                        acl.addEntry(entry.principal, entry.privileges, entry.isAllow);
                    }
                    if (log.isInfoEnabled()) {
                        StringBuilder strB = new StringBuilder("ACL @ ");
                        strB.append(context.getPath()).append(" : ");
                        for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                            strB.append("\n- ");
                            strB.append(ace.getPrincipal().getName());
                            strB.append(", [ ");
                            String delim = "";
                            for (Privilege privilege : ace.getPrivileges()) {
                                strB.append(delim);
                                strB.append(privilege.getName());
                                delim = ",";
                            }
                            strB.append(" ], ");
                            boolean isAllow = ((JackrabbitAccessControlEntry)ace).isAllow();
                            strB.append(isAllow ? "allow" : "deny");
                        }
                        log.info(strB.toString());
                    }
                    this.acMgr.setPolicy(context.getPath(), (AccessControlPolicy)acl);
                }
                ac.remove();
                this.session.save();
            }
        }

        protected Privilege[] getPrivilegesForAction(String action) throws RepositoryException {
            List privs = (List)ACT2PRIV.get(action);
            if (privs != null) {
                Privilege[] privileges = new Privilege[privs.size()];
                int i = 0;
                for (String p : privs) {
                    privileges[i++] = this.acMgr.privilegeFromName(p);
                }
                return privileges;
            }
            return null;
        }
    }

    protected class AssignWorkspaceAccess
    implements Task {
        protected AssignWorkspaceAccess() {
        }

        public void run(Node context) throws RepositoryException {
            String wspName = context.getName();
            if (context.hasNode(CRXSecurityMigration.REP_AC)) {
                context.getNode(CRXSecurityMigration.REP_AC).getNodes();
            }
        }
    }

    protected class AssignImpersonators
    implements Task {
        protected AssignImpersonators() {
        }

        public void run(Node userNode) throws RepositoryException {
            String userId = userNode.getProperty(CRXSecurityMigration.REP_USER_ID).getString();
            if (!userNode.hasNode(CRXSecurityMigration.SUDOERS_AC)) {
                return;
            }
            Node sudoersAC = userNode.getNode(CRXSecurityMigration.SUDOERS_AC);
            NodeIterator grants = sudoersAC.getNodes();
            if (!grants.hasNext()) {
                return;
            }
            Authorizable auth = CRXSecurityMigration.this.userMgr.getAuthorizable(userId);
            if (auth == null) {
                throw new RepositoryException("authorizable not found for userId " + userId);
            }
            if (auth instanceof User) {
                User user = (User)auth;
                Impersonation imp = user.getImpersonation();
                while (grants.hasNext()) {
                    Node n = grants.nextNode();
                    if (!n.hasProperty(CRXSecurityMigration.REP_PRINCIPAL)) continue;
                    String principalName = n.getProperty(CRXSecurityMigration.REP_PRINCIPAL).getString();
                    imp.grantImpersonation((Principal)new PrincipalImpl(principalName));
                }
            } else {
                throw new RepositoryException("not a user: " + userNode.getPath());
            }
        }
    }

    protected class CreateUsers
    implements Task {
        protected CreateUsers() {
        }

        public void run(Node userNode) throws RepositoryException {
            Value[] values;
            User user;
            String password = null;
            try {
                password = userNode.getProperty(CRXSecurityMigration.REP_PASSWORD).getString();
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            String userId = userNode.getProperty(CRXSecurityMigration.REP_USER_ID).getString();
            CRXSecurityMigration.this.deleteAuthorizableNode(userId);
            String principalName = CRXSecurityMigration.this.getUserPrincipalName(userNode);
            PrincipalImpl principal = new PrincipalImpl(principalName);
            try {
                String path = CRXSecurityMigration.getIntermediatePath(userNode, CRXSecurityMigration.USERS_PATH);
                user = CRXSecurityMigration.this.userMgr.createUser(userId, password != null ? password : "", (Principal)principal, path);
            }
            catch (AuthorizableExistsException e) {
                Authorizable auth = CRXSecurityMigration.this.userMgr.getAuthorizable((Principal)principal);
                if (auth instanceof User) {
                    user = (User)auth;
                }
                log.error("Authorizable '" + principalName + "' already " + "exists. Cannot migrate user with same id");
                return;
            }
            if (password != null && ((values = user.getProperty(CRXSecurityMigration.REP_PASSWORD)) == null || values.length == 1 && !values[0].getString().equals(password))) {
                String authPath = CRXSecurityMigration.this.getNodeForAuthorizable(userId).getPath();
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    CRXSecurityMigration.this.session.exportSystemView(authPath, (OutputStream)out, false, true);
                    String export = out.toString("UTF-8");
                    int passPropIdx = export.indexOf(CRXSecurityMigration.REP_PASSWORD);
                    int passValueStartIdx = export.indexOf("<sv:value>", passPropIdx);
                    int passValueEndIdx = export.indexOf("</sv:value>", passPropIdx);
                    StringBuilder xml = new StringBuilder();
                    xml.append(export.substring(0, passValueStartIdx));
                    xml.append("<sv:value>");
                    xml.append(password);
                    xml.append(export.substring(passValueEndIdx));
                    CRXSecurityMigration.this.session.importXML(Text.getRelativeParent((String)authPath, (int)1), (InputStream)new ByteArrayInputStream(xml.toString().getBytes("UTF-8")), 2);
                    CRXSecurityMigration.this.session.save();
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
                user = (User)CRXSecurityMigration.this.userMgr.getAuthorizable(userId);
            }
            CRXSecurityMigration.copyProperties(userNode, (Authorizable)user);
            if (CRXSecurityMigration.this.existingUserHome != null) {
                try {
                    CRXSecurityMigration.this.restoreHome((Authorizable)user, CRXSecurityMigration.this.userMgr.getUsersPath(), CRXSecurityMigration.this.existingUserHome);
                }
                catch (RepositoryException e) {
                    log.error("Error while copying home content", (Throwable)e);
                }
            }
            CRXSecurityMigration.this.notifyMigrated((Authorizable)user, userNode.getPath());
        }
    }

    protected class AssignMembers
    implements Task {
        protected AssignMembers() {
        }

        public void run(Node groupNode) throws RepositoryException {
            if (groupNode.hasProperty(CRXSecurityMigration.REP_MEMBER)) {
                Authorizable auth = CRXSecurityMigration.this.userMgr.getAuthorizable(CRXSecurityMigration.this.getGroupPrincipalName(groupNode));
                if (!auth.isGroup()) {
                    throw new RepositoryException("expected group for principal: " + CRXSecurityMigration.this.getGroupPrincipalName(groupNode));
                }
                Group group = (Group)auth;
                for (Value v : groupNode.getProperty(CRXSecurityMigration.REP_MEMBER).getValues()) {
                    String ref = v.getString();
                    try {
                        String principalName;
                        Node n = CRXSecurityMigration.this.securitySession.getNodeByIdentifier(ref);
                        if (n.isNodeType(CRXSecurityMigration.REP_GROUP)) {
                            principalName = CRXSecurityMigration.this.getGroupPrincipalName(n);
                        } else if (n.isNodeType(CRXSecurityMigration.REP_USER)) {
                            principalName = CRXSecurityMigration.this.getUserPrincipalName(n);
                        } else {
                            log.warn("rep:member references {}", (Object)n.getProperty("jcr:primaryType").getString());
                            continue;
                        }
                        auth = CRXSecurityMigration.this.userMgr.getAuthorizable((Principal)new PrincipalImpl(principalName));
                        if (auth != null) {
                            group.addMember(auth);
                            continue;
                        }
                        log.warn("Authorization not found for principal name: {}", (Object)principalName);
                    }
                    catch (ItemNotFoundException e) {
                        log.warn("Dangling member reference in group {}: {}", (Object)Text.unescapeIllegalJcrChars((String)groupNode.getName()), (Object)ref);
                    }
                }
            }
        }
    }

    protected class CreateGroups
    implements Task {
        protected CreateGroups() {
        }

        public void run(Node groupNode) throws RepositoryException {
            Group group;
            String principalName = CRXSecurityMigration.this.getGroupPrincipalName(groupNode);
            CRXSecurityMigration.this.deleteAuthorizableNode(principalName);
            PrincipalImpl principal = new PrincipalImpl(principalName);
            try {
                String path = CRXSecurityMigration.getIntermediatePath(groupNode, CRXSecurityMigration.GROUPS_PATH);
                group = CRXSecurityMigration.this.userMgr.createGroup((Principal)principal, path);
            }
            catch (AuthorizableExistsException e) {
                log.debug("Group already exists: {}", (Object)principalName);
                group = CRXSecurityMigration.this.userMgr.getAuthorizable((Principal)principal);
            }
            CRXSecurityMigration.copyProperties(groupNode, (Authorizable)group);
            if (CRXSecurityMigration.this.existingGroupHome != null) {
                try {
                    CRXSecurityMigration.this.restoreHome((Authorizable)group, CRXSecurityMigration.this.userMgr.getGroupsPath(), CRXSecurityMigration.this.existingGroupHome);
                }
                catch (RepositoryException e) {
                    log.error("Error while copying home content", (Throwable)e);
                }
            }
            CRXSecurityMigration.this.notifyMigrated((Authorizable)group, groupNode.getPath());
        }
    }

    protected static interface Task {
        public void run(Node var1) throws RepositoryException;
    }

    public static interface ProgressListener {
        public void migrated(Authorizable var1, String var2);
    }
}

