/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

import com.day.crx.cluster.Connection;
import com.day.crx.cluster.TransportHandler;
import com.day.crx.cluster.TransportHandlerContext;
import com.day.crx.cluster.http.HttpConnection;
import com.day.crx.cluster.http.HttpProcessor;
import com.day.crx.cluster.http.HttpTransport;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class HttpTransportHandler
implements TransportHandler,
HttpTransport {
    public static final int OP_FAIL = -1;
    private TransportHandlerContext context;

    public void init(TransportHandlerContext context) {
        this.context = context;
    }

    public Connection createConnection(Socket s) throws IOException {
        return new HttpConnection(this.context, s);
    }

    public void process(InputStream in, OutputStream out) throws IOException {
        HttpProcessor processor = new HttpProcessor(this.context, in, out);
        processor.enterLoop();
    }

    static void readFully(InputStream in, byte[] b) throws IOException {
        int len;
        for (int off = 0; off < b.length; off += len) {
            len = in.read(b, off, b.length - off);
            if (len > 0) continue;
            throw new EOFException();
        }
    }

    static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int n;
        for (int read = 0; read < len; read += n) {
            n = in.read(b, off + read, len - read);
            if (n > 0) continue;
            throw new EOFException();
        }
    }
}

