/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ChunkedOutputStream
extends FilterOutputStream {
    private static final int MAX_CHUNK_SIZE = 65535;
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final byte[] LAST_CHUNK = "0000\r\n\r\n".getBytes();
    private final byte[] prefix = new byte[4];
    private final byte[] data;
    private int offset;

    public ChunkedOutputStream(OutputStream out, int size) {
        super(out);
        if (size < 1 || size > 65535) {
            String msg = "Chunk size smaller than 1 or bigger than 65535";
            throw new IllegalArgumentException(msg);
        }
        this.data = new byte[size];
    }

    public ChunkedOutputStream(OutputStream out) {
        this(out, 65535);
    }

    public void write(int b) throws IOException {
        if (this.offset == this.data.length) {
            this.writeChunk();
        }
        this.data[this.offset++] = (byte)(b & 0xFF);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int written = 0;
        while (written < len) {
            if (this.offset == this.data.length) {
                this.writeChunk();
            }
            int available = Math.min(len - written, this.data.length - this.offset);
            System.arraycopy(b, off + written, this.data, this.offset, available);
            written += available;
            this.offset += available;
        }
    }

    private void writeChunk() throws IOException {
        ChunkedOutputStream.toHexString(this.offset, this.prefix);
        this.out.write(this.prefix);
        this.out.write(CRLF);
        this.out.write(this.data, 0, this.offset);
        this.out.write(CRLF);
        this.offset = 0;
    }

    private static void toHexString(int n, byte[] b) {
        for (int i = b.length - 1; i >= 0; --i) {
            int c = n & 0xF;
            c = c >= 0 && c <= 9 ? (c += 48) : (c += 55);
            b[i] = (byte)c;
            n >>= 4;
        }
    }

    public void flush() throws IOException {
        if (this.offset > 0) {
            this.writeChunk();
        }
        super.flush();
    }

    public void close() throws IOException {
        if (this.offset > 0) {
            this.writeChunk();
        }
        this.out.write(LAST_CHUNK);
        super.flush();
    }

    public static void main(String[] args) throws Exception {
        int len;
        ChunkedOutputStream cout = new ChunkedOutputStream(System.out);
        byte[] data = new byte[2048];
        while ((len = System.in.read(data)) > 0) {
            cout.write(data, 0, len);
            cout.flush();
        }
        cout.close();
    }
}

