/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

import com.day.crx.cluster.http.HttpTransportHandler;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class ChunkedInputStream
extends FilterInputStream {
    private static final int MAX_CHUNK_SIZE = 65535;
    private static final byte[] CRLF = "\r\n".getBytes();
    private final byte[] prefix = new byte[4];
    private final byte[] data = new byte[65535];
    private final byte[] suffix = new byte[2];
    private int offset;
    private int length;
    private boolean lastChunk;

    public ChunkedInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        if (!this.lastChunk) {
            if (this.offset == this.length) {
                this.readChunk();
            }
            if (this.offset < this.length) {
                return this.data[this.offset++] & 0xFF;
            }
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        while (read < len && !this.lastChunk) {
            if (this.offset == this.length) {
                this.readChunk();
            }
            int available = Math.min(len - read, this.length - this.offset);
            System.arraycopy(this.data, this.offset, b, off + read, available);
            read += available;
            this.offset += available;
        }
        return read == 0 && this.lastChunk ? -1 : read;
    }

    private void readChunk() throws IOException {
        this.length = 0;
        this.offset = 0;
        HttpTransportHandler.readFully(this.in, this.prefix);
        this.length = ChunkedInputStream.parseInt(this.prefix);
        if (this.length < 0 || this.length > 65535) {
            String msg = "Chunk size smaller than 0 or bigger than 65535";
            throw new IOException(msg);
        }
        HttpTransportHandler.readFully(this.in, this.suffix);
        if (!Arrays.equals(this.suffix, CRLF)) {
            String msg = "Missing carriage return/line feed combination.";
            throw new IOException(msg);
        }
        HttpTransportHandler.readFully(this.in, this.data, 0, this.length);
        HttpTransportHandler.readFully(this.in, this.suffix);
        if (!Arrays.equals(this.suffix, CRLF)) {
            String msg = "Missing carriage return/line feed combination.";
            throw new IOException(msg);
        }
        if (this.length == 0) {
            this.lastChunk = true;
        }
    }

    private static int parseInt(byte[] b) throws IOException {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            byte c = b[i];
            result <<= 4;
            if (c >= 48 && c <= 57) {
                result += c - 48;
                continue;
            }
            if (c >= 65 && c <= 70) {
                result += c - 65 + 10;
                continue;
            }
            if (c >= 97 && c <= 102) {
                result += c - 97 + 10;
                continue;
            }
            String msg = "Not a hexadecimal character: " + c;
            throw new IOException(msg);
        }
        return result;
    }

    public void close() throws IOException {
        while (!this.lastChunk) {
            this.readChunk();
        }
    }

    public static void main(String[] args) throws Exception {
        int len;
        ChunkedInputStream cin = new ChunkedInputStream(System.in);
        byte[] data = new byte[2048];
        while ((len = cin.read(data)) > 0) {
            System.out.write(data, 0, len);
        }
        cin.close();
    }
}

