/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.ClusterController;
import com.day.crx.cluster.Connection;
import com.day.crx.cluster.InvokeHandler;
import com.day.crx.cluster.LoginException;
import com.day.crx.cluster.ObjectId;
import com.day.crx.cluster.Request;
import com.day.crx.cluster.ResponseHandler;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportHandlerContext
extends InvokeHandler {
    private static final long RELOAD_DELAY = 1000L;
    private static final ObjectId OBJECT_ID = new ObjectId("context");
    private static final String LOGIN_OPERATION = "login";
    private static Logger log = LoggerFactory.getLogger(TransportHandlerContext.class);
    private final ClusterController controller;
    private final Map<String, Slave> slaves = new LinkedHashMap<String, Slave>();
    private final Object reconnectMonitor = new Object();

    TransportHandlerContext(ClusterController controller) {
        super(OBJECT_ID);
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(String identity, String info, boolean isLocal) throws IllegalArgumentException {
        Map<String, Slave> map = this.slaves;
        synchronized (map) {
            if (!isLocal && identity.equals(this.controller.getIdentity())) {
                String msg = "Slave has same identity as master: " + identity;
                throw new IllegalArgumentException(msg);
            }
            if (this.slaves.containsKey(identity)) {
                String msg = "Slave already connected: " + identity;
                throw new IllegalArgumentException(msg);
            }
            if (!this.controller.checkIdentity(identity)) {
                String msg = "Not allowed to connect: " + identity;
                throw new IllegalArgumentException(msg);
            }
            Thread.currentThread().setName(identity);
            log.info("Connected.");
            this.controller.setCurrentIdentity(identity);
            Slave slave = new Slave(identity, info, isLocal);
            this.slaves.put(identity, slave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        String identity = this.controller.getRemoteIdentity();
        if (identity != null) {
            Map<String, Slave> map = this.slaves;
            synchronized (map) {
                this.slaves.remove(identity);
                log.info("Disconnected.");
                this.controller.setCurrentIdentity(null);
            }
        }
    }

    public boolean checkKey(String key) {
        return this.controller.checkKey(key);
    }

    public String getIdentity() {
        return this.controller.getIdentity();
    }

    public InvokeHandler getInvokeHandler(ObjectId objectId) throws IOException {
        if (objectId.equals(this.getObjectId())) {
            return this;
        }
        return this.controller.getHandler(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection reconnect() throws IOException {
        Object object = this.reconnectMonitor;
        synchronized (object) {
            Connection connection = this.controller.getConnection();
            if (connection.isClosed()) {
                this.controller.electMaster();
                connection = this.controller.getConnection();
            }
            return connection;
        }
    }

    public Map<String, Slave> getSlaves() {
        return Collections.unmodifiableMap(this.slaves);
    }

    public Slave getSlave(String identity) {
        return this.slaves.get(identity);
    }

    public void dump(PrintWriter pw) {
        this.controller.dump(pw);
        pw.println("slaves: ");
        for (Slave slave : this.slaves.values()) {
            pw.println("    " + slave);
        }
    }

    public void login(Connection connection, String key, String identity, boolean isLocal) throws IOException {
        String info = System.getProperty("os.name") + " " + System.getProperty("os.version");
        String remoteAddr = connection.getRemoteAddress();
        Request request = connection.createRequest(this.getObjectId(), LOGIN_OPERATION);
        request.setRetries(1);
        try {
            request.writeUTF(key);
            request.writeUTF(identity);
            request.writeBoolean(isLocal);
            request.writeUTF(info);
            request.invoke();
        }
        catch (IOException e) {
            String msg = "Login failed to master running at " + remoteAddr;
            Throwable cause = e.getCause();
            throw new LoginException(msg, cause != null ? cause : e);
        }
    }

    @Override
    protected void doInvoke(String operation, DataInput in, ResponseHandler handler) throws IOException {
        if (operation.equals(LOGIN_OPERATION)) {
            String key = in.readUTF();
            String identity = in.readUTF();
            boolean isLocal = in.readBoolean();
            String info = in.readUTF();
            if (!this.checkKey(key)) {
                String msg = "Key does not match.";
                handler.createExceptionReply(new LoginException(msg));
            }
            try {
                this.connected(identity, info, isLocal);
            }
            catch (IllegalArgumentException e) {
                handler.createExceptionReply(new LoginException(e.getMessage()));
            }
            return;
        }
        String msg = "Operation unknown: " + operation;
        throw new IOException(msg);
    }

    public class Slave {
        private final String identity;
        private final String os;
        private final boolean isLocal;
        private final Properties props = new Properties();
        private long lastLoaded;
        private long lastModified;
        private long lastFileSize;

        public Slave(String identity, String os, boolean isLocal) {
            this.identity = identity;
            this.os = os;
            this.isLocal = isLocal;
            this.loadProperties();
        }

        public String getIdentity() {
            return this.identity;
        }

        public String getOS() {
            return this.os;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public String getProperty(String key) {
            this.loadProperties();
            return this.props.getProperty(key);
        }

        protected synchronized void loadProperties() {
            File identityFile = TransportHandlerContext.this.controller.getIdentityFile(this.identity);
            if (!identityFile.exists()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime <= this.lastLoaded + 1000L) {
                return;
            }
            long modified = identityFile.lastModified();
            long length = identityFile.length();
            if (modified > this.lastModified || length != this.lastFileSize) {
                try {
                    this.loadProperties(identityFile);
                    this.lastModified = modified;
                    this.lastFileSize = length;
                }
                catch (IOException e) {
                    String msg = "Unable to load properties from " + identityFile.getPath();
                    log.warn(msg, (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadProperties(File identityFile) throws IOException {
            FileInputStream in = new FileInputStream(identityFile);
            try {
                this.props.clear();
                this.props.load(in);
            }
            finally {
                in.close();
            }
        }
    }
}

