/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.AbstractMasterElection;
import com.day.crx.cluster.TransportHandler;
import com.day.crx.cluster.TransportHandlerContext;
import java.io.IOException;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.util.RepositoryLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryLockElection
extends AbstractMasterElection {
    private static Logger log = LoggerFactory.getLogger(RepositoryLockElection.class);
    private final int lockTimeout;
    private RepositoryLock controlLock;

    public RepositoryLockElection(String controlPath, String identity, String host, int port, int[] candidatePorts, TransportHandler handler, TransportHandlerContext context, int lockTimeout) throws IOException {
        super(controlPath, identity, host, port, candidatePorts, handler, context);
        this.lockTimeout = lockTimeout;
    }

    protected void doElect(boolean becomeMaster) throws IOException {
        long start = System.currentTimeMillis();
        while (true) {
            Properties prop;
            if ((prop = this.readControlFile()) != null) {
                this.listenerAddress = prop.getProperty("address");
                this.checkKey = prop.getProperty("check");
                if (this.tryConnect()) {
                    log.info("Entered slave mode, connected to: " + this.listenerAddress);
                    this.isMaster = false;
                    break;
                }
            }
            this.createListener();
            try {
                this.controlLock = new RepositoryLock();
                this.controlLock.init(this.controlFolder.getPath());
            }
            catch (RepositoryException e) {
                IOException e2 = new IOException(e.toString());
                e2.initCause(e);
                throw e2;
            }
            try {
                this.controlLock.acquire();
                log.info("Entered master mode.");
                this.saveListenerAddress(this.controlFile);
                this.isMaster = true;
            }
            catch (Exception e) {
                long time;
                log.info("Unable to acquire control lock", (Throwable)e);
                if (this.lockTimeout <= 0 || (time = System.currentTimeMillis() - start) <= (long)this.lockTimeout) continue;
                throw new IOException("Lock timeout trying to lock " + this.controlFolder);
            }
            break;
        }
    }

    public void close() {
        super.close();
        if (this.controlLock != null) {
            this.controlLock.release();
            this.controlLock = null;
        }
    }
}

