/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.TypeId;

public class ObjectId {
    private final TypeId typeId;
    private final String instanceId;

    public ObjectId(TypeId typeId, String instanceId) {
        this.typeId = typeId;
        this.instanceId = instanceId;
    }

    public ObjectId(String instanceId) {
        this.typeId = TypeId.EMPTY;
        this.instanceId = instanceId;
    }

    public int hashCode() {
        return this.typeId.hashCode() ^ this.instanceId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectId) {
            ObjectId other = (ObjectId)obj;
            return this.typeId.equals(other.typeId) && this.instanceId.equals(other.instanceId);
        }
        return false;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public TypeId getTypeId() {
        return this.typeId;
    }

    public String toString() {
        return this.typeId + "@" + this.instanceId;
    }

    public static ObjectId valueOf(String s) {
        int sep = s.lastIndexOf(64);
        if (sep == -1) {
            String msg = "Bad object id: " + s;
            throw new IllegalArgumentException(msg);
        }
        return new ObjectId(TypeId.valueOf(s.substring(0, sep)), s.substring(sep + 1));
    }
}

