/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.MasterInfoImplBase;
import com.day.crx.cluster.SlaveInfo;
import com.day.crx.cluster.SlaveInfoImpl;
import com.day.crx.cluster.TransportHandlerContext;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterInfoImpl
extends MasterInfoImplBase {
    private static Logger log = LoggerFactory.getLogger(MasterInfoImplBase.class);
    private TransportHandlerContext context;

    public MasterInfoImpl(TransportHandlerContext context) {
        this.context = context;
    }

    public String getOS() {
        return this.getController().getInfo();
    }

    public String getIdentity() {
        return this.getController().getIdentity();
    }

    public String getControlFolder() {
        File controlFolder = this.getController().getControlFolder();
        try {
            return controlFolder.getCanonicalPath();
        }
        catch (IOException e) {
            String msg = "Unable to return canonical path for: " + controlFolder;
            log.warn(msg, (Throwable)e);
            return controlFolder.getAbsolutePath();
        }
    }

    public String getProperty(String key) {
        return this.getController().getProperty(key);
    }

    public SlaveInfo[] getSlaveInfos() {
        Collection<TransportHandlerContext.Slave> slaves = this.context.getSlaves().values();
        SlaveInfo[] ret = new SlaveInfo[slaves.size()];
        int i = 0;
        for (TransportHandlerContext.Slave slave : slaves) {
            ret[i++] = new SlaveInfoImpl(slave);
        }
        return ret;
    }

    protected String getProperty(String identity, String key) {
        TransportHandlerContext.Slave slave = this.context.getSlave(identity);
        if (slave == null) {
            log.warn("Unknown slave: " + identity);
            return null;
        }
        return slave.getProperty(key);
    }

    public boolean isDaemon() {
        return true;
    }
}

