/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityLock {
    private static Logger log = LoggerFactory.getLogger(IdentityLock.class);
    private static final long ONE_SECOND_MS = 1000L;
    private final long lockTimeoutMs;
    private final long waitTimeoutMs;
    private Object identity;
    private int locks;
    private long lastAccessed;
    private int interruptLevel;

    public IdentityLock(long lockTimeoutMs) {
        this.lockTimeoutMs = lockTimeoutMs;
        this.waitTimeoutMs = Math.min(1000L, lockTimeoutMs);
    }

    public IdentityLock() {
        this(0L);
    }

    public synchronized void acquire(Object identity) throws InterruptedException {
        this.checkInactivity();
        if (!identity.equals(this.identity)) {
            while (this.identity != null) {
                this.wait(this.waitTimeoutMs);
                this.checkInactivity();
            }
            this.identity = identity;
        }
        ++this.locks;
        this.touch();
    }

    public synchronized boolean attempt(Object identity, long timeout) throws InterruptedException {
        this.checkInactivity();
        if (!identity.equals(this.identity)) {
            if (this.identity != null) {
                this.wait(timeout);
                this.checkInactivity();
            }
            if (this.identity != null) {
                return false;
            }
            this.identity = identity;
        }
        ++this.locks;
        this.touch();
        return true;
    }

    public synchronized void checkLock(Object identity) {
        if (!identity.equals(this.identity)) {
            String msg = "Lock held by: " + this.identity + ", not by: " + identity;
            throw new IllegalStateException(msg);
        }
        this.touch();
    }

    public synchronized void enterLock(Object identity) {
        if (!identity.equals(this.identity)) {
            String msg = "Lock held by: " + this.identity + ", not by: " + identity;
            throw new IllegalStateException(msg);
        }
        ++this.interruptLevel;
    }

    public synchronized void exitLock(Object identity) {
        if (!identity.equals(this.identity)) {
            String msg = "Lock held by: " + this.identity + ", not by: " + identity;
            log.warn(msg);
            return;
        }
        if (--this.interruptLevel == 0) {
            this.notify();
        }
    }

    public synchronized boolean holdsLock(Object identity) {
        return identity.equals(this.identity);
    }

    public synchronized void release(Object identity) throws IllegalStateException {
        if (!identity.equals(this.identity)) {
            String msg = "Lock held by: " + this.identity + ", not by: " + identity;
            throw new IllegalStateException(msg);
        }
        if (--this.locks == 0) {
            this.identity = null;
            this.notify();
        }
    }

    private void touch() {
        this.lastAccessed = System.currentTimeMillis();
    }

    private void checkInactivity() throws InterruptedException {
        long now;
        if (this.lockTimeoutMs != 0L && this.locks > 0 && this.interruptLevel == 0 && (now = System.currentTimeMillis()) - this.lastAccessed > this.lockTimeoutMs) {
            String msg = "Breaking lock of " + this.identity + " after " + this.lockTimeoutMs + " ms of inactivity.";
            this.locks = 0;
            this.identity = null;
            this.notify();
            throw new InterruptedException(msg);
        }
    }

    public int getHoldCount() {
        return this.locks;
    }
}

